/*
 * Decompiled with CFR 0.152.
 */
package de.galan.dmsexchange.exchange.container;

import de.galan.dmsexchange.exchange.DocumentValidationException;
import de.galan.dmsexchange.exchange.container.AbstractContainer;
import de.galan.dmsexchange.meta.Document;
import de.galan.dmsexchange.meta.DocumentFile;
import de.galan.dmsexchange.meta.Revision;
import de.galan.dmsexchange.meta.ValidationResult;
import de.galan.dmsexchange.util.archive.TarUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class ContainerSerializer
extends AbstractContainer {
    public byte[] archive(Document document, boolean standalone) throws IOException, DocumentValidationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.archive(document, standalone, (OutputStream)baos);
        return baos.toByteArray();
    }

    public void archive(Document document, boolean standalone, OutputStream outputstream) throws IOException, DocumentValidationException {
        this.validateDocument(document);
        try (TarArchiveOutputStream tar = TarUtil.create(outputstream, standalone);){
            String documentJson = this.getVerjson().writePlain((Object)document);
            byte[] metadata = documentJson.getBytes(StandardCharsets.UTF_8);
            TarUtil.addEntry(tar, metadata, "meta.json");
            for (DocumentFile df : document.getDocumentFiles()) {
                for (Revision revision : df.getRevisions()) {
                    String generated = this.generateRevisionName(df, revision);
                    TarUtil.addEntry(tar, revision.getData(), generated);
                }
            }
            tar.flush();
        }
    }

    protected void validateDocument(Document document) throws DocumentValidationException {
        ValidationResult result = document.validate();
        if (result.hasErrors()) {
            throw new DocumentValidationException("Invalid Document", result);
        }
    }
}

