/*
 * Decompiled with CFR 0.152.
 */
package de.galan.dmsexchange.meta;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.galan.commons.time.Instants;
import de.galan.dmsexchange.meta.Comment;
import de.galan.dmsexchange.meta.Context;
import de.galan.dmsexchange.meta.DocumentFile;
import de.galan.dmsexchange.meta.Source;
import de.galan.dmsexchange.meta.User;
import de.galan.dmsexchange.meta.Validatable;
import de.galan.dmsexchange.meta.ValidationResult;
import de.galan.dmsexchange.util.UtcFormatter;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class Document
implements Validatable {
    private String version = "1.0.0";
    private ZonedDateTime createdTime = Instants.from((Instant)Instants.now()).toZdt();
    private User createdBy;
    private Source source;
    private List<DocumentFile> documentFiles = new ArrayList<DocumentFile>();
    private Context context;
    private String note;
    private String location;
    private List<Comment> comments = new ArrayList<Comment>();
    private String idUser;
    private String idSystem;
    private String project;
    private String directory;
    private List<String> labels = new ArrayList<String>();
    private Boolean optionIndexed;
    private Boolean optionOcr;

    @Override
    public void validate(ValidationResult result) {
        if (StringUtils.isBlank((CharSequence)this.getVersion())) {
            result.add("Version is not set");
        }
        if (this.getDocumentFiles() == null || this.getDocumentFiles().isEmpty()) {
            result.add("Document does not contain any DocumentFile");
        }
        this.validate(result, this.getDocumentFiles());
        this.validate(result, this.getComments());
        this.validate(result, this.getSource());
    }

    public String getVersion() {
        return this.version;
    }

    public ZonedDateTime getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(ZonedDateTime createdTime) {
        this.createdTime = createdTime;
    }

    public Document createdTime(ZonedDateTime createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public Document createdTime(String createdTime) {
        this.setCreatedTime(UtcFormatter.parse(createdTime));
        return this;
    }

    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public Document createdBy(User createdBy) {
        this.setCreatedBy(createdBy);
        return this;
    }

    public Document createdBy(String createdBy) {
        this.setCreatedBy(new User(createdBy));
        return this;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public Document source(Source source) {
        this.setSource(source);
        return this;
    }

    @JsonIgnore
    public String getSourceAsString() {
        return this.source == null ? "unknown" : this.getSource().toString();
    }

    public void addDocumentFile(DocumentFile file) {
        this.getDocumentFiles().add(file);
    }

    public List<DocumentFile> getDocumentFiles() {
        if (this.documentFiles == null) {
            this.documentFiles = new ArrayList<DocumentFile>();
        }
        return this.documentFiles;
    }

    public Document documentFile(DocumentFile file) {
        this.addDocumentFile(file);
        return this;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Document context(Context context) {
        this.setContext(context);
        return this;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Document note(String note) {
        this.setNote(note);
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Document location(String location) {
        this.setLocation(location);
        return this;
    }

    public List<Comment> getComments() {
        if (this.comments == null) {
            this.comments = new ArrayList<Comment>();
        }
        return this.comments;
    }

    public void addComments(Comment ... commentsToAdd) {
        this.getComments().addAll(Arrays.asList(commentsToAdd));
    }

    public Document comments(Comment ... commentsToAdd) {
        this.addComments(commentsToAdd);
        return this;
    }

    public String getIdUser() {
        return this.idUser;
    }

    public void setIdUser(String idUser) {
        this.idUser = idUser;
    }

    public Document idUser(String idUser) {
        this.setIdUser(idUser);
        return this;
    }

    public String getIdSystem() {
        return this.idSystem;
    }

    public void setIdSystem(String idSystem) {
        this.idSystem = idSystem;
    }

    public Document idSystem(String idSystem) {
        this.setIdSystem(idSystem);
        return this;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public Document project(String project) {
        this.setProject(project);
        return this;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public Document diretory(String directory) {
        this.setDirectory(directory);
        return this;
    }

    public List<String> getLabels() {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        return this.labels;
    }

    public void addLabels(String ... labelsToAdd) {
        this.getLabels().addAll(Arrays.asList(labelsToAdd));
    }

    public Document labels(String ... labelsToAdd) {
        this.addLabels(labelsToAdd);
        return this;
    }

    public Boolean getOptionIndexed() {
        return this.optionIndexed;
    }

    public void setOptionIndexed(Boolean optionIndexed) {
        this.optionIndexed = optionIndexed;
    }

    public Document optionIndexed(Boolean optionIndexed) {
        this.setOptionIndexed(optionIndexed);
        return this;
    }

    public Boolean getOptionOcr() {
        return this.optionOcr;
    }

    public void setOptionOcr(Boolean optionOcr) {
        this.optionOcr = optionOcr;
    }

    public Document optionOcr(Boolean optionOcr) {
        this.setOptionOcr(optionOcr);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.version, this.documentFiles, this.context, this.note, this.location, this.comments, this.idUser, this.idSystem, this.project, this.directory, this.labels, this.optionIndexed, this.optionOcr);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Document) {
            Document other = (Document)obj;
            return new EqualsBuilder().append((Object)this.version, (Object)other.version).append((Object)this.createdTime, (Object)other.createdTime).append((Object)this.createdBy, (Object)other.createdBy).append((Object)this.source, (Object)other.source).append(this.documentFiles, other.documentFiles).append((Object)this.context, (Object)other.context).append((Object)this.note, (Object)other.note).append((Object)this.location, (Object)other.location).append(this.comments, other.comments).append((Object)this.idUser, (Object)other.idUser).append((Object)this.idSystem, (Object)other.idSystem).append((Object)this.project, (Object)other.project).append((Object)this.directory, (Object)other.directory).append(this.labels, other.labels).append((Object)this.optionIndexed, (Object)other.optionIndexed).append((Object)this.optionOcr, (Object)other.optionOcr).isEquals();
        }
        return false;
    }
}

