/*
 * Decompiled with CFR 0.152.
 */
package de.galan.dmsexchange.meta;

import de.galan.dmsexchange.meta.Revision;
import de.galan.dmsexchange.meta.Rotation;
import de.galan.dmsexchange.meta.Validatable;
import de.galan.dmsexchange.meta.ValidationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class DocumentFile
implements Validatable {
    private String filename;
    private Rotation rotation;
    private List<Revision> revisions = new ArrayList<Revision>();

    public DocumentFile() {
    }

    public DocumentFile(String filename) {
        this();
        this.setFilename(filename);
    }

    @Override
    public void validate(ValidationResult result) {
        if (StringUtils.isBlank((CharSequence)this.getFilename())) {
            result.add("No filename for document-file");
        }
        if (this.getRevisions() == null || this.getRevisions().isEmpty()) {
            result.add("No revisions for document-file");
        }
        this.validate(result, this.revisions);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public List<Revision> getRevisions() {
        return this.revisions;
    }

    public void addRevision(Revision ... revisionToAdd) {
        this.revisions.addAll(Arrays.asList(revisionToAdd));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filename, this.rotation, this.revisions});
    }

    public boolean equals(Object obj) {
        if (obj instanceof DocumentFile) {
            DocumentFile other = (DocumentFile)obj;
            return new EqualsBuilder().append((Object)this.filename, (Object)other.filename).append((Object)this.rotation, (Object)other.rotation).append(this.revisions, other.revisions).isEquals();
        }
        return false;
    }
}

