/*
 * Decompiled with CFR 0.152.
 */
package de.galan.dmsexchange.meta;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.io.Files;
import de.galan.dmsexchange.meta.User;
import de.galan.dmsexchange.meta.Validatable;
import de.galan.dmsexchange.meta.ValidationResult;
import de.galan.dmsexchange.util.UtcFormatter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class Revision
implements Validatable {
    private User addedBy;
    private ZonedDateTime addedTime;
    @JsonIgnore
    private byte[] data;

    public Revision() {
    }

    public Revision(ZonedDateTime addedTime) {
        this(addedTime, null, null);
    }

    public Revision(ZonedDateTime addedTime, User addedBy, byte[] data) {
        this.setAddedTime(addedTime);
        this.setAddedBy(addedBy);
        this.setData(data);
    }

    @Override
    public void validate(ValidationResult result) {
        if (this.getAddedTime() == null) {
            result.add("No addedTime for revision");
        }
        if (this.getData() == null || this.getData().length == 0) {
            result.add("No data for revision");
        }
        if (this.getAddedBy() != null) {
            this.getAddedBy().validate(result);
        }
    }

    public User getAddedBy() {
        return this.addedBy;
    }

    public void setAddedBy(User addedBy) {
        this.addedBy = addedBy;
    }

    public Revision addedBy(User addedBy) {
        this.setAddedBy(addedBy);
        return this;
    }

    public Revision addedBy(String addedBy) {
        this.setAddedBy(new User(addedBy));
        return this;
    }

    public ZonedDateTime getAddedTime() {
        return this.addedTime;
    }

    public void setAddedTime(ZonedDateTime addedTime) {
        this.addedTime = addedTime;
    }

    public Revision addedTime(ZonedDateTime addedTime) {
        this.setAddedTime(addedTime);
        return this;
    }

    public Revision addedTime(String addedTime) {
        this.setAddedTime(UtcFormatter.parse(addedTime));
        return this;
    }

    @JsonIgnore
    public byte[] getData() {
        return this.data;
    }

    @JsonIgnore
    public InputStream getDataInputStream() {
        return new ByteArrayInputStream(this.getData());
    }

    @JsonIgnore
    public OutputStream getDataOutputStream() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(this.getDataInputStream());
        return result;
    }

    public void writeDataToFile(File file) throws IOException {
        FileUtils.writeByteArrayToFile((File)file, (byte[])this.getData());
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public Revision data(byte[] data) {
        this.setData(data);
        return this;
    }

    public void setData(InputStream stream) throws IOException {
        this.data = IOUtils.toByteArray((InputStream)stream);
        stream.close();
    }

    public Revision data(InputStream stream) throws IOException {
        this.setData(stream);
        return this;
    }

    public void setData(File file) throws IOException {
        this.setData(Files.toByteArray((File)file));
    }

    public Revision data(File file) throws IOException {
        this.setData(file);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.addedBy, this.addedTime, this.data);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Revision) {
            Revision other = (Revision)obj;
            return new EqualsBuilder().append((Object)this.addedBy, (Object)other.addedBy).append((Object)this.addedTime, (Object)other.addedTime).append(this.data, other.data).isEquals();
        }
        return false;
    }
}

