/*
 * Decompiled with CFR 0.152.
 */
package de.galan.dmsexchange.meta;

import de.galan.dmsexchange.meta.Validatable;
import de.galan.dmsexchange.meta.ValidationResult;
import de.galan.dmsexchange.util.EmailValidation;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class User
implements Validatable {
    private String email;

    public User(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public String toString() {
        return this.getEmail();
    }

    @Override
    public void validate(ValidationResult result) {
        if (!EmailValidation.isValidEmailAddress(this.getEmail())) {
            result.add("Invalid email for user '" + this.getEmail() + "'");
        }
    }

    public int hashCode() {
        return Objects.hash(this.email);
    }

    public boolean equals(Object obj) {
        if (obj instanceof User) {
            User other = (User)obj;
            return new EqualsBuilder().append((Object)this.email, (Object)other.email).isEquals();
        }
        return false;
    }
}

