/*
 * Decompiled with CFR 0.152.
 */
package de.galan.dmsexchange.util;

import de.galan.commons.logging.Logr;
import java.io.File;
import java.util.UUID;
import org.apache.logging.log4j.Logger;

public class FileGenerationUtil {
    private static final Logger LOG = Logr.get();

    public static File prepareFile(File file) {
        File result = file;
        if (file == null) {
            throw new IllegalArgumentException("Invalid file (null)");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Invalid file (file can not be a directory)");
        }
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        } else if (file.isFile()) {
            LOG.info("File {} will be overwritten", (Object)file.getAbsolutePath());
        }
        return result;
    }

    public static File generateUniqueFilename(File directory) {
        if (directory == null || directory.isFile()) {
            throw new IllegalArgumentException("Invalid directory ('" + directory + "')");
        }
        if (directory.exists() && directory.isDirectory()) {
            directory.mkdirs();
        }
        return new File(directory, UUID.randomUUID().toString() + ".tgz");
    }
}

