/*
 * Decompiled with CFR 0.152.
 */
package de.galan.verjson.core;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.galan.verjson.core.ProxyStep;
import de.galan.verjson.core.ProxyStepComparator;
import de.galan.verjson.core.StepSequencer;
import de.galan.verjson.step.IncrementVersionStep;
import de.galan.verjson.step.NoopStep;
import de.galan.verjson.step.Step;
import de.galan.verjson.step.validation.Validation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultStepSequencer
implements StepSequencer {
    @Override
    public Map<Long, ProxyStep> sequence(ListMultimap<Long, Step> steps) {
        List<ProxyStep> proxies = this.createProxies(steps);
        Collections.sort(proxies, new ProxyStepComparator());
        List<ProxyStep> proxiesIncrements = this.fillIncrements(proxies);
        this.assignSuccessors(proxiesIncrements);
        Map<Long, ProxyStep> proxiesAttached = this.attachVersions(proxiesIncrements);
        return proxiesAttached;
    }

    protected Map<Long, ProxyStep> attachVersions(List<ProxyStep> proxies) {
        HashMap result = Maps.newHashMap();
        Long lastVersion = 0L;
        for (ProxyStep proxy : proxies) {
            if (proxy.getSourceVersion() <= lastVersion) continue;
            lastVersion = lastVersion + 1L;
            result.put(lastVersion, proxy);
        }
        return result;
    }

    protected void assignSuccessors(List<ProxyStep> proxies) {
        ProxyStep precessor = null;
        for (ProxyStep step : Lists.reverse(proxies)) {
            if (precessor != null) {
                step.setSuccessor(precessor);
            }
            precessor = step;
        }
    }

    protected List<ProxyStep> createProxies(ListMultimap<Long, Step> steps) {
        ArrayList list = Lists.newArrayList();
        for (Long sourceVersion : steps.keySet()) {
            for (Step step : steps.get((Object)sourceVersion)) {
                list.add(new ProxyStep(sourceVersion, step));
            }
        }
        return list;
    }

    protected List<ProxyStep> fillIncrements(List<ProxyStep> proxies) {
        ArrayList result = Lists.newArrayList();
        Long lastSourceVersion = 1L;
        if (!proxies.isEmpty()) {
            boolean increment = false;
            for (ProxyStep proxy : proxies) {
                while (lastSourceVersion < proxy.getSourceVersion()) {
                    ProxyStep incProxy = new ProxyStep(lastSourceVersion, new IncrementVersionStep());
                    result.add(incProxy);
                    Long l = lastSourceVersion;
                    Long l2 = lastSourceVersion = Long.valueOf(lastSourceVersion + 1L);
                }
                increment = !Validation.class.isAssignableFrom(proxy.getStep().getClass());
                result.add(proxy);
            }
            if (increment) {
                Long l = lastSourceVersion;
                Long l3 = lastSourceVersion = Long.valueOf(lastSourceVersion + 1L);
                result.add(new ProxyStep(l, new IncrementVersionStep()));
                result.add(new ProxyStep(lastSourceVersion, new NoopStep()));
            }
        } else {
            result.add(new ProxyStep(lastSourceVersion, new NoopStep()));
        }
        return result;
    }
}

