/*
 * Decompiled with CFR 0.152.
 */
package de.galan.verjson.core;

import de.galan.verjson.util.ReadException;
import org.apache.commons.lang3.StringUtils;

public class NamespaceMismatchException
extends ReadException {
    private String namespaceDefined;
    private String namespaceGiven;

    public NamespaceMismatchException(String namespaceDefined, String namespaceGiven) {
        super(NamespaceMismatchException.generateMessage(namespaceDefined, namespaceGiven));
        this.namespaceDefined = namespaceDefined;
        this.namespaceGiven = namespaceGiven;
    }

    protected static String generateMessage(String namespaceDefined, String namespaceGiven) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Verjson only supports ");
        if (StringUtils.isBlank((CharSequence)namespaceDefined)) {
            buffer.append("empty namespace");
        } else {
            buffer.append("namespace '" + namespaceDefined + "'");
        }
        buffer.append(", element has ");
        if (StringUtils.isBlank((CharSequence)namespaceGiven)) {
            buffer.append("no namespace");
        } else {
            buffer.append("namespace '" + namespaceGiven + "'");
        }
        return buffer.toString();
    }

    public String getNamespaceDefined() {
        return this.namespaceDefined;
    }

    public String getNamespaceGiven() {
        return this.namespaceGiven;
    }
}

