/*
 * Decompiled with CFR 0.152.
 */
package de.galan.verjson.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.Lists;
import de.galan.commons.logging.Logr;
import de.galan.commons.util.Pair;
import de.galan.verjson.core.Versions;
import de.galan.verjson.serializer.DateDeserializer;
import de.galan.verjson.serializer.DateSerializer;
import de.galan.verjson.serializer.ZonedDateTimeDeserializer;
import de.galan.verjson.serializer.ZonedDateTimeSerializer;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.logging.log4j.Logger;

public class ObjectMapperFactory {
    private static final Logger LOG = Logr.get();

    public ObjectMapper create(Versions versions) {
        ObjectMapper result = new ObjectMapper();
        result.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        result.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        SimpleModule module = new SimpleModule("VerjsonModule");
        this.registerSerializer(result, module, versions);
        result.registerModule((Module)module);
        for (Class parentClass : versions.getRegisteredSubclasses().keySet()) {
            Class<?> mixin = ObjectMapperFactory.generateMixIn(parentClass, versions.getRegisteredSubclasses().get((Object)parentClass));
            result.addMixInAnnotations(parentClass, mixin);
        }
        return result;
    }

    protected void registerSerializer(ObjectMapper result, SimpleModule module, Versions versions) {
        module.addSerializer((JsonSerializer)new DateSerializer());
        module.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        module.addSerializer((JsonSerializer)new ZonedDateTimeSerializer());
        module.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeDeserializer());
        for (JsonSerializer<?> jsonSerializer : versions.getSerializer()) {
            module.addSerializer(jsonSerializer);
        }
        for (JsonDeserializer jsonDeserializer : versions.getDeserializer()) {
            Method method = null;
            try {
                method = jsonDeserializer.getClass().getMethod("deserialize", JsonParser.class, DeserializationContext.class);
                module.addDeserializer(method.getReturnType(), jsonDeserializer);
            }
            catch (NoSuchMethodException | NullPointerException | SecurityException ex) {
                String methodName = method == null ? "null" : method.getName();
                String returnTypeName = method == null || method.getReturnType() == null ? "null" : method.getReturnType().toString();
                LOG.error("Unable to register deserializer for Class<" + returnTypeName + ">." + methodName + "(..)", (Throwable)ex);
            }
        }
    }

    protected static Class<?> generateMixIn(Class<?> parent, Set<Pair<Class<?>, String>> childs) {
        ClassPool pool = ClassPool.getDefault();
        String className = parent.getPackage().getName() + ".Gen" + parent.getSimpleName() + "MixIn";
        CtClass ctClass = pool.getOrNull(className);
        Class result = null;
        if (ctClass == null) {
            ctClass = pool.makeClass(className);
            ClassFile cf = ctClass.getClassFile();
            cf.setMajorVersion(51);
            cf.setMinorVersion(0);
            ConstPool cp = cf.getConstPool();
            Annotation annotationInfo = new Annotation(JsonTypeInfo.class.getName(), cp);
            EnumMemberValue enumId = new EnumMemberValue(cp);
            enumId.setType(JsonTypeInfo.Id.class.getName());
            enumId.setValue(JsonTypeInfo.Id.NAME.toString());
            annotationInfo.addMemberValue("use", (MemberValue)enumId);
            EnumMemberValue enumAs = new EnumMemberValue(cp);
            enumAs.setType(JsonTypeInfo.As.class.getName());
            enumAs.setValue(JsonTypeInfo.As.PROPERTY.toString());
            annotationInfo.addMemberValue("include", (MemberValue)enumAs);
            annotationInfo.addMemberValue("property", (MemberValue)new StringMemberValue("$type", cp));
            AnnotationsAttribute attr = new AnnotationsAttribute(cp, "RuntimeVisibleAnnotations");
            attr.addAnnotation(annotationInfo);
            ClassMemberValue cmvNone = new ClassMemberValue(JsonTypeInfo.None.class.getName(), cp);
            annotationInfo.addMemberValue("defaultImpl", (MemberValue)cmvNone);
            ArrayList amvs = Lists.newArrayList();
            for (Pair<Class<?>, String> child : childs) {
                Annotation annotationType = new Annotation(JsonSubTypes.Type.class.getName(), cp);
                annotationType.addMemberValue("value", (MemberValue)new ClassMemberValue(((Class)child.getKey()).getName(), cp));
                annotationType.addMemberValue("name", (MemberValue)new StringMemberValue((String)child.getValue(), cp));
                AnnotationMemberValue amv = new AnnotationMemberValue(cp);
                amv.setValue(annotationType);
                amvs.add(amv);
            }
            Annotation annotationSub = new Annotation(JsonSubTypes.class.getName(), cp);
            ArrayMemberValue arraymv = new ArrayMemberValue(cp);
            MemberValue[] valueSubs = amvs.toArray(new MemberValue[0]);
            arraymv.setValue(valueSubs);
            annotationSub.addMemberValue("value", (MemberValue)arraymv);
            attr.addAnnotation(annotationSub);
            cf.addAttribute((AttributeInfo)attr);
            try {
                result = ctClass.toClass();
            }
            catch (CannotCompileException ex) {
                throw new RuntimeException("Failed generating MixIn for registered Subclasses (" + className + ")", ex);
            }
        }
        try {
            result = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Failed loading generated MixIn (" + className + ")", ex);
        }
        return result;
    }
}

