/*
 * Decompiled with CFR 0.152.
 */
package de.galan.verjson.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import de.galan.commons.logging.Logr;
import de.galan.verjson.step.ProcessStepException;
import de.galan.verjson.step.Step;
import org.apache.logging.log4j.Logger;

public class ProxyStep
implements Step {
    private static final Logger LOG = Logr.get();
    Long sourceVersion;
    Step step;
    Step successor;

    public ProxyStep(Long sourceVersion, Step step) {
        Preconditions.checkNotNull((Object)sourceVersion, (Object)"SourceVersion could not be null");
        Preconditions.checkNotNull((Object)step, (Object)"Step could not be null");
        this.sourceVersion = sourceVersion;
        this.step = step;
    }

    @Override
    public void process(JsonNode node) throws ProcessStepException {
        LOG.debug("Processing {}/{}", new Object[]{this.getSourceVersion(), this.getStep().getClass().getSimpleName()});
        this.getStep().process(node);
        if (this.successor != null) {
            this.successor.process(node);
        }
    }

    public Long getSourceVersion() {
        return this.sourceVersion;
    }

    protected Step getStep() {
        return this.step;
    }

    public void setSuccessor(ProxyStep successor) {
        this.successor = successor;
    }

    public String toString() {
        return "ProxyStep " + this.getSourceVersion() + "/" + this.getStep().getClass().getSimpleName();
    }
}

