/*
 * Decompiled with CFR 0.152.
 */
package de.galan.verjson.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import de.galan.commons.time.Instants;
import de.galan.verjson.core.DefaultStepSequencer;
import de.galan.verjson.core.IOReadException;
import de.galan.verjson.core.NamespaceMismatchException;
import de.galan.verjson.core.ObjectMapperFactory;
import de.galan.verjson.core.StepSequencer;
import de.galan.verjson.core.VersionNotSupportedException;
import de.galan.verjson.core.Versions;
import de.galan.verjson.step.ProcessStepException;
import de.galan.verjson.step.Step;
import de.galan.verjson.util.MetaWrapper;
import de.galan.verjson.util.ReadException;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class Verjson<T> {
    String namespace;
    Class<T> valueClass;
    Map<Long, ? extends Step> steps;
    ObjectMapper mapper;
    long highestSourceVersion;
    boolean includeTimestamp;

    public static <T> Verjson<T> create(Class<T> valueClass, Versions versions) {
        return new Verjson<T>(valueClass, versions);
    }

    public Verjson(Class<T> valueClass, Versions versions) {
        this.valueClass = (Class)Preconditions.checkNotNull(valueClass, (Object)"valueClass can not be null");
        Versions vs = versions != null ? versions : new Versions();
        this.namespace = vs.getNamespace();
        this.configure(vs);
    }

    protected void configure(Versions versions) {
        versions.configure();
        this.includeTimestamp = versions.isIncludeTimestamp();
        this.mapper = new ObjectMapperFactory().create(versions);
        this.steps = this.createStepSequencer().sequence(versions.getSteps());
        this.highestSourceVersion = this.determineHighestSourceVersion();
    }

    protected long determineHighestSourceVersion() {
        Preconditions.checkNotNull(this.steps, (Object)"Steps can not be null, at least one NoopStep has to exist");
        Set<Long> keys = this.steps.keySet();
        Preconditions.checkElementIndex((int)0, (int)keys.toArray().length, (String)"Steps can not be empty, at least one NoopStep has to exist");
        return Collections.max(keys);
    }

    protected StepSequencer createStepSequencer() {
        return new DefaultStepSequencer();
    }

    protected String getNamespace() {
        return this.namespace;
    }

    protected ObjectMapper getMapper() {
        return this.mapper;
    }

    public String write(T obj) throws JsonProcessingException {
        Date ts = this.includeTimestamp ? Date.from(Instants.now()) : null;
        MetaWrapper wrapper = new MetaWrapper(this.getHighestSourceVersion(), this.getNamespace(), obj, ts);
        return this.mapper.writeValueAsString((Object)wrapper);
    }

    public String writePlain(T obj) throws JsonProcessingException {
        return this.mapper.writeValueAsString(obj);
    }

    public JsonNode readTree(String json) throws IOException {
        return this.getMapper().readTree(json);
    }

    protected JsonNode wrapPlainNode(JsonNode node, long version) {
        ObjectNode wrapper = new ObjectNode(JsonNodeFactory.instance);
        wrapper.put("$v", version);
        wrapper.put("$d", node);
        return wrapper;
    }

    public T readPlain(JsonNode node, long version) throws VersionNotSupportedException, NamespaceMismatchException, ProcessStepException, IOReadException {
        return this.read(this.wrapPlainNode(node, version));
    }

    public T read(String json) throws VersionNotSupportedException, NamespaceMismatchException, ProcessStepException, IOReadException {
        T result = null;
        try {
            result = this.read(this.readTree(json));
        }
        catch (IOException ex) {
            throw new IOReadException("Reading json failed: " + ex.getMessage(), ex);
        }
        return result;
    }

    public T read(JsonNode node) throws VersionNotSupportedException, NamespaceMismatchException, ProcessStepException, IOReadException {
        Object result = null;
        try {
            this.verifyNamespace(node);
            Long jsonVersion = this.verifyVersion(node);
            this.steps.get(jsonVersion).process(node);
            JsonNode data = MetaWrapper.getData(node);
            result = this.getMapper().treeToValue((TreeNode)data, this.getValueClass());
        }
        catch (ReadException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new IOReadException("Reading json failed: " + ex.getMessage(), ex);
        }
        return (T)result;
    }

    protected Long verifyVersion(JsonNode node) throws VersionNotSupportedException {
        Long sourceVersion = MetaWrapper.getVersion(node);
        if (sourceVersion > this.getHighestSourceVersion()) {
            throw new VersionNotSupportedException(this.getHighestSourceVersion(), sourceVersion, this.getValueClass());
        }
        return sourceVersion;
    }

    protected String verifyNamespace(JsonNode node) throws NamespaceMismatchException {
        String ns = MetaWrapper.getNamespace(node);
        if (!StringUtils.equals((CharSequence)ns, (CharSequence)this.getNamespace())) {
            throw new NamespaceMismatchException(this.getNamespace(), ns);
        }
        return ns;
    }

    protected Class<T> getValueClass() {
        return this.valueClass;
    }

    protected long getHighestSourceVersion() {
        return this.highestSourceVersion;
    }
}

