/*
 * Decompiled with CFR 0.152.
 */
package de.galan.verjson.core;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import de.galan.commons.util.Pair;
import de.galan.verjson.step.Step;
import java.util.Collection;
import java.util.Map;

public class Versions {
    private ListMultimap<Long, Step> steps;
    private String namespace;
    private Map<Class<?>, JsonSerializer<?>> serializers;
    private Map<Class<?>, JsonDeserializer<?>> deserializers;
    private SetMultimap<Class<?>, Pair<Class<?>, String>> polys;
    private boolean includeTimestamp;

    public Versions() {
        this(null);
    }

    public Versions(String namespace) {
        this.setNamespace(namespace);
        this.steps = ArrayListMultimap.create();
        this.serializers = Maps.newHashMap();
        this.deserializers = Maps.newHashMap();
        this.polys = HashMultimap.create();
        this.includeTimestamp = true;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void configure() {
    }

    public ListMultimap<Long, Step> getSteps() {
        return this.steps;
    }

    public Versions add(Long sourceVersion, Step step) {
        if (step != null) {
            this.getSteps().put((Object)sourceVersion, (Object)step);
        }
        return this;
    }

    public <T> void registerSubclass(Class<T> parentClass, Class<? extends T> childClass, String typeName) {
        this.getRegisteredSubclasses().put(parentClass, (Object)new Pair(childClass, (Object)typeName));
    }

    public SetMultimap<Class<?>, Pair<Class<?>, String>> getRegisteredSubclasses() {
        return this.polys;
    }

    public <T> Versions registerSerializer(JsonSerializer<T> serializer) {
        if (serializer != null) {
            this.serializers.put(serializer.getClass(), serializer);
        }
        return this;
    }

    public <T> Versions registerDeserializer(JsonDeserializer<T> deserializer) {
        if (deserializer != null) {
            this.deserializers.put(deserializer.getClass(), deserializer);
        }
        return this;
    }

    public Collection<JsonSerializer<?>> getSerializer() {
        return this.serializers.values();
    }

    public Collection<JsonDeserializer<?>> getDeserializer() {
        return this.deserializers.values();
    }

    public boolean isIncludeTimestamp() {
        return this.includeTimestamp;
    }

    public void setIncludeTimestamp(boolean includeTimestamp) {
        this.includeTimestamp = includeTimestamp;
    }
}

