/*
 * Decompiled with CFR 0.152.
 */
package de.galan.verjson.step.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.Lists;
import de.galan.verjson.step.ProcessStepException;
import de.galan.verjson.step.Step;
import de.galan.verjson.step.validation.InvalidJsonException;
import de.galan.verjson.step.validation.InvalidSchemaException;
import de.galan.verjson.util.MetaWrapper;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class Validation
implements Step {
    protected static final String LS = StandardSystemProperty.LINE_SEPARATOR.value();
    String description;
    JsonSchema schema;
    static JsonSchemaFactory factory;

    public Validation(String schema) {
        this(schema, null);
    }

    public Validation(String schema, String description) {
        this.description = description;
        this.schema = this.create(schema);
    }

    public String getDescription() {
        return this.description;
    }

    protected String getDescriptionAppendable() {
        return StringUtils.isBlank((CharSequence)this.getDescription()) ? "" : " (" + this.getDescription() + ")";
    }

    protected static synchronized JsonSchemaFactory getFactory() {
        if (factory == null) {
            factory = JsonSchemaFactory.byDefault();
        }
        return factory;
    }

    protected JsonSchemaFactory getJsonSchemaFactory() {
        return Validation.getFactory();
    }

    @Override
    public void process(JsonNode node) throws ProcessStepException {
        this.validate(MetaWrapper.getData(node));
    }

    protected JsonSchema getSchema() {
        return this.schema;
    }

    public void validate(JsonNode node) throws InvalidJsonException {
        ProcessingReport report = null;
        try {
            report = this.getSchema().validate(node);
        }
        catch (Throwable ex) {
            throw new InvalidJsonException("Could not validate JSON against schema" + this.getDescriptionAppendable(), ex);
        }
        if (!report.isSuccess()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Could not validate JSON against schema");
            builder.append(this.getDescriptionAppendable());
            builder.append(":");
            builder.append(LS);
            ArrayList messages = Lists.newArrayList((Iterable)report);
            for (int i = 0; i < messages.size(); ++i) {
                builder.append("- ");
                builder.append(((ProcessingMessage)messages.get(i)).getMessage());
                builder.append(i == messages.size() - 1 ? "" : LS);
            }
            throw new InvalidJsonException(builder.toString());
        }
    }

    public JsonSchema create(String schemaString) {
        JsonSchema jsonSchema = null;
        try {
            JsonNode schemaNode = JsonLoader.fromString((String)schemaString);
            if (!this.getJsonSchemaFactory().getSyntaxValidator().schemaIsValid(schemaNode)) {
                throw new InvalidSchemaException("JSON Schema is invalid" + this.getDescriptionAppendable());
            }
            jsonSchema = this.getJsonSchemaFactory().getJsonSchema(schemaNode);
        }
        catch (ProcessingException | IOException | NullPointerException ex) {
            throw new InvalidSchemaException("JSON Schema could not be loaded" + this.getDescriptionAppendable(), ex);
        }
        return jsonSchema;
    }
}

