/*
 * Decompiled with CFR 0.152.
 */
package de.galan.verjson.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import de.galan.commons.time.Instants;
import de.galan.verjson.util.Transformations;
import java.time.Instant;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class MetaWrapper {
    public static final String ID_VERSION = "$v";
    public static final String ID_NAMESPACE = "$ns";
    public static final String ID_DATA = "$d";
    public static final String ID_TIMESTAMP = "$ts";
    @JsonProperty(value="$v")
    private long version;
    @JsonProperty(value="$ns")
    private String namespace;
    @JsonProperty(value="$ts")
    private Date timestamp;
    @JsonProperty(value="$d")
    private Object data;

    public MetaWrapper(long version, String namespace, Object data, Date timestamp) {
        this.version = version;
        this.namespace = namespace;
        this.data = data;
        this.timestamp = timestamp;
    }

    public static JsonNode getData(JsonNode node) {
        return Transformations.getObj(Transformations.obj(node), ID_DATA);
    }

    public static String getNamespace(JsonNode node) {
        JsonNode nodeNs = Transformations.obj(node).get(ID_NAMESPACE);
        return nodeNs != null ? nodeNs.asText() : null;
    }

    public static Long getVersion(JsonNode node) {
        return Transformations.obj(node).get(ID_VERSION).asLong();
    }

    public static void setVersion(JsonNode node, Long version) {
        Transformations.obj(node).put(ID_VERSION, version);
    }

    public static Date getTimestamp(JsonNode node) {
        String text = Transformations.obj(node).get(ID_TIMESTAMP).asText();
        return StringUtils.isNotBlank((CharSequence)text) ? Instants.from((Instant)Instants.instantUtc((String)text)).toDate() : null;
    }
}

