/*
 * Decompiled with CFR 0.152.
 */
package de.galan.verjson.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;

public final class Transformations {
    public static ObjectNode obj(JsonNode node) {
        return node != null ? (ObjectNode)node : null;
    }

    public static ObjectNode getObj(ObjectNode obj, String fieldName) {
        return obj != null ? Transformations.obj(obj.get(fieldName)) : null;
    }

    public static ObjectNode getObjAndRemove(ObjectNode obj, String fieldName) {
        ObjectNode result = null;
        if (obj != null) {
            result = Transformations.obj(Transformations.remove(obj, fieldName));
        }
        return result;
    }

    public static ArrayNode createArray(JsonNode ... nodes) {
        return Transformations.createArray(false, nodes);
    }

    public static ArrayNode createArray(boolean fallbackToEmptyArray, JsonNode ... nodes) {
        ArrayNode array = null;
        for (JsonNode element : nodes) {
            if (element == null) continue;
            if (array == null) {
                array = new ArrayNode(JsonNodeFactory.instance);
            }
            array.add(element);
        }
        if (array == null && fallbackToEmptyArray) {
            array = new ArrayNode(JsonNodeFactory.instance);
        }
        return array;
    }

    public static ArrayNode array(JsonNode node) {
        return node != null ? (ArrayNode)node : null;
    }

    public static ArrayNode getArray(ObjectNode obj, String fieldName) {
        return obj == null ? null : Transformations.array(obj.get(fieldName));
    }

    public static ArrayNode getArrayAndRemove(ObjectNode obj, String fieldName) {
        ArrayNode result = null;
        if (obj != null) {
            result = Transformations.array(Transformations.remove(obj, fieldName));
        }
        return result;
    }

    public static JsonNode remove(ObjectNode obj, String fieldName) {
        JsonNode result = null;
        if (obj != null) {
            result = obj.remove(fieldName);
        }
        return result;
    }

    public static void rename(ObjectNode obj, String oldFieldName, String newFieldName) {
        JsonNode node;
        if (obj != null && StringUtils.isNotBlank((CharSequence)oldFieldName) && StringUtils.isNotBlank((CharSequence)newFieldName) && (node = Transformations.remove(obj, oldFieldName)) != null) {
            obj.put(newFieldName, node);
        }
    }
}

