/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.couchdb;

import com.squareup.moshi.Moshi;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.Okio;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDBClient
implements GroovyObject {
    private OkHttpClient client;
    private Moshi moshi;
    private String couchdbHost;
    private int couchdbPort;
    private String couchdbUsername;
    private String couchdbPassword;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public CouchDBClient() {
        int n;
        String string;
        MetaClass metaClass;
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callConstructor(OkHttpClient.class);
        this.client = (OkHttpClient)ScriptBytecodeAdapter.castToType((Object)object, OkHttpClient.class);
        Object object2 = callSiteArray[1].call(callSiteArray[2].callConstructor(Moshi.Builder.class));
        this.moshi = (Moshi)ScriptBytecodeAdapter.castToType((Object)object2, Moshi.class);
        this.couchdbHost = string = "127.0.0.1";
        this.couchdbPort = n = 5984;
    }

    public Object healthy() {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        Object builder = callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort}, new String[]{"http://", ":", ""})));
        Object request = callSiteArray[6].call(builder);
        Object response = callSiteArray[7].call(callSiteArray[8].call((Object)this.client, request));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callGetProperty(response))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[10].call(response), (Object)404)) {
                callSiteArray[11].call(callSiteArray[12].call(response));
                return false;
            }
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call((Object)log)) ? callSiteArray[14].call((Object)log, (Object)"error {}", callSiteArray[15].call(response)) : null;
            callSiteArray[16].call(callSiteArray[17].call(response));
            throw (Throwable)callSiteArray[18].callConstructor(IllegalStateException.class, (Object)"could not check for database existence");
        }
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].call((Object)log)) ? callSiteArray[20].call((Object)log, callSiteArray[21].call(callSiteArray[22].call(response))) : null;
        return true;
    }

    public <R> R query(String db, String viewName, String key, boolean includeDocs) {
        Reference includeDocs2 = new Reference((Object)includeDocs);
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        String encodedKey = ShortTypeHandling.castToString((Object)callSiteArray[23].call(callSiteArray[24].call((Object)this.moshi, String.class), (Object)key));
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call(callSiteArray[26].call(callSiteArray[27].callConstructor(Request.Builder.class), callSiteArray[28].call(callSiteArray[29].call(callSiteArray[30].call(callSiteArray[31].call(callSiteArray[32].call((Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort}, new String[]{"http://", ":", ""}), (Object)new GStringImpl(new Object[]{callSiteArray[33].call((Object)db)}, new String[]{"/", ""})), (Object)new GStringImpl(new Object[]{callSiteArray[34].call((Object)db)}, new String[]{"/_design/", ""})), (Object)new GStringImpl(new Object[]{viewName}, new String[]{"/_view/", ""})), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""})), (Object)new GStringImpl(new Object[]{encodedKey}, new String[]{"&key=", ""})))), Request.class);
        Object response = callSiteArray[35].call(callSiteArray[36].call((Object)this.client, (Object)request));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[37].callGetProperty(response))) {
            callSiteArray[38].call((Object)log, (Object)"request failed: {}", (Object)request);
            throw (Throwable)callSiteArray[39].callConstructor(IOException.class, callSiteArray[40].call(callSiteArray[41].call(response)));
        }
        Object result = callSiteArray[42].callCurrent((GroovyObject)this, callSiteArray[43].call(callSiteArray[44].call(response)));
        public final class _query_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includeDocs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _query_closure1(Object _outerInstance, Object _thisObject, Reference includeDocs) {
                Reference reference;
                CallSite[] callSiteArray = _query_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.includeDocs = reference = includeDocs;
            }

            public Object doCall(Object row) {
                CallSite[] callSiteArray = _query_closure1.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get()) ? callSiteArray[0].callGetProperty(row) : row;
            }

            @Generated
            public boolean getIncludeDocs() {
                CallSite[] callSiteArray = _query_closure1.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _query_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doc";
                return new CallSiteArray(_query_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _query_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (R)callSiteArray[45].call(callSiteArray[46].callGetProperty(result), (Object)new _query_closure1(this, this, includeDocs2));
    }

    public <R> R query(String db, String viewName, Collection<String> keys, boolean includeDocs) {
        Reference includeDocs2 = new Reference((Object)includeDocs);
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        String encodedKeys = ShortTypeHandling.castToString((Object)callSiteArray[47].call(callSiteArray[48].call((Object)this.moshi, Collection.class), keys));
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].call(callSiteArray[50].call(callSiteArray[51].callConstructor(Request.Builder.class), callSiteArray[52].call(callSiteArray[53].call(callSiteArray[54].call(callSiteArray[55].call(callSiteArray[56].call((Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort}, new String[]{"http://", ":", ""}), (Object)new GStringImpl(new Object[]{callSiteArray[57].call((Object)db)}, new String[]{"/", ""})), (Object)new GStringImpl(new Object[]{callSiteArray[58].call((Object)db)}, new String[]{"/_design/", ""})), (Object)new GStringImpl(new Object[]{viewName}, new String[]{"/_view/", ""})), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""})), (Object)new GStringImpl(new Object[]{encodedKeys}, new String[]{"&keys=", ""})))), Request.class);
        Object response = callSiteArray[59].call(callSiteArray[60].call((Object)this.client, (Object)request));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[61].callGetProperty(response))) {
            callSiteArray[62].call((Object)log, (Object)"request failed: {}", (Object)request);
            throw (Throwable)callSiteArray[63].callConstructor(IOException.class, callSiteArray[64].call(callSiteArray[65].call(response)));
        }
        Object result = callSiteArray[66].callCurrent((GroovyObject)this, callSiteArray[67].call(callSiteArray[68].call(response)));
        public final class _query_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includeDocs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _query_closure2(Object _outerInstance, Object _thisObject, Reference includeDocs) {
                Reference reference;
                CallSite[] callSiteArray = _query_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.includeDocs = reference = includeDocs;
            }

            public Object doCall(Object row) {
                CallSite[] callSiteArray = _query_closure2.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get()) ? callSiteArray[0].callGetProperty(row) : row;
            }

            @Generated
            public boolean getIncludeDocs() {
                CallSite[] callSiteArray = _query_closure2.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _query_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doc";
                return new CallSiteArray(_query_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _query_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (R)callSiteArray[69].call(callSiteArray[70].callGetProperty(result), (Object)new _query_closure2(this, this, includeDocs2));
    }

    public Object getAllDocs(String db, boolean includeDocs, boolean includeDesignDoc) {
        Object object;
        Reference includeDocs2 = new Reference((Object)includeDocs);
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        Object builder = callSiteArray[71].call(callSiteArray[72].call(callSiteArray[73].callConstructor(Request.Builder.class), callSiteArray[74].call(callSiteArray[75].call((Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort, callSiteArray[76].call((Object)db)}, new String[]{"http://", ":", "/", ""}), (Object)"/_all_docs"), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""}))));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object2;
            builder = object2 = callSiteArray[77].call(builder, (Object)"Authorization", callSiteArray[78].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
        }
        Object request = callSiteArray[79].call(builder);
        Object response = callSiteArray[80].call(callSiteArray[81].call((Object)this.client, request));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[82].callGetProperty(response))) {
            Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[83].call((Object)log)) ? callSiteArray[84].call((Object)log, (Object)"error getting all docs: {}/{}", callSiteArray[85].call(response), callSiteArray[86].call(response)) : null;
            throw (Throwable)callSiteArray[87].callConstructor(IllegalStateException.class, (Object)"could not get all docs with");
        }
        Object allDocs = callSiteArray[88].callCurrent((GroovyObject)this, callSiteArray[89].call(callSiteArray[90].call(response)));
        public final class _getAllDocs_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includeDocs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getAllDocs_closure3(Object _outerInstance, Object _thisObject, Reference includeDocs) {
                Reference reference;
                CallSite[] callSiteArray = _getAllDocs_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.includeDocs = reference = includeDocs;
            }

            public Object doCall(Object row) {
                CallSite[] callSiteArray = _getAllDocs_closure3.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get()) ? callSiteArray[0].callGetProperty(row) : row;
            }

            @Generated
            public boolean getIncludeDocs() {
                CallSite[] callSiteArray = _getAllDocs_closure3.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAllDocs_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doc";
                return new CallSiteArray(_getAllDocs_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getAllDocs_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        allDocs = object = callSiteArray[91].call(callSiteArray[92].callGetProperty(allDocs), (Object)new _getAllDocs_closure3(this, this, includeDocs2));
        if (!includeDesignDoc) {
            Object object4;
            public final class _getAllDocs_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getAllDocs_closure4(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _getAllDocs_closure4.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getAllDocs_closure4.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callSafe(callSiteArray[1].callGetProperty(it), (Object)"_design/")) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callSafe(callSiteArray[3].callGetProperty(it), (Object)"_design/"));
                    }
                    return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callSafe(callSiteArray[5].callGetProperty(it), (Object)"_design/")) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callSafe(callSiteArray[7].callGetProperty(it), (Object)"_design/"));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _getAllDocs_closure4.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAllDocs_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "startsWith";
                    stringArray[1] = "_id";
                    stringArray[2] = "startsWith";
                    stringArray[3] = "id";
                    stringArray[4] = "startsWith";
                    stringArray[5] = "_id";
                    stringArray[6] = "startsWith";
                    stringArray[7] = "id";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _getAllDocs_closure4.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getAllDocs_closure4.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getAllDocs_closure4.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            allDocs = object4 = callSiteArray[93].call(allDocs, (Object)new _getAllDocs_closure4(this, this));
        }
        return allDocs;
    }

    public Object create(String db, Object document) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)document, null)) {
            throw (Throwable)callSiteArray[94].callConstructor(IllegalArgumentException.class, (Object)"document may not be null");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[95].call(document, (Object)"_rev"))) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[96].call((Object)log)) ? callSiteArray[97].call((Object)log, (Object)"document must be new, but has id({}), rev({})", callSiteArray[98].call(document, (Object)"_id"), callSiteArray[99].call(document, (Object)"_rev")) : null;
            throw (Throwable)callSiteArray[100].callConstructor(IllegalArgumentException.class, (Object)"document must be new");
        }
        callSiteArray[101].callCurrent((GroovyObject)this, document);
        Object documentAsJson = callSiteArray[102].call(callSiteArray[103].call((Object)this.moshi, Map.class), document);
        Object body = callSiteArray[104].call(RequestBody.class, documentAsJson, callSiteArray[105].callStatic(MediaType.class, (Object)"application/json"));
        Object builder = callSiteArray[106].callConstructor(Request.Builder.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[107].call(document, (Object)"_id"))) {
            Object object;
            String docId = ShortTypeHandling.castToString((Object)callSiteArray[108].call(document, (Object)"_id"));
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object2 = callSiteArray[109].callStatic(CouchDBClient.class, (Object)docId);
                docId = ShortTypeHandling.castToString((Object)object2);
            } else {
                Object object3 = CouchDBClient.sanitizeDocId(docId);
                docId = ShortTypeHandling.castToString((Object)object3);
            }
            builder = object = callSiteArray[110].call(callSiteArray[111].call(builder, (Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort, callSiteArray[112].call((Object)db), docId}, new String[]{"http://", ":", "/", "/", ""})), body);
        } else {
            Object object;
            builder = object = callSiteArray[113].call(callSiteArray[114].call(builder, (Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort, callSiteArray[115].call((Object)db)}, new String[]{"http://", ":", "/", ""})), body);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object;
            builder = object = callSiteArray[116].call(builder, (Object)"Authorization", callSiteArray[117].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
        }
        Object request = callSiteArray[118].call(builder);
        Object response = callSiteArray[119].call(callSiteArray[120].call((Object)this.client, request));
        Object result = callSiteArray[121].callCurrent((GroovyObject)this, callSiteArray[122].call(callSiteArray[123].call(response)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[124].callGetProperty(result))) {
            callSiteArray[125].call((Object)log, (Object)"error {}", result);
            throw (Throwable)callSiteArray[126].callConstructor(IllegalStateException.class, (Object)"error creating document");
        }
        Object createdDocument = callSiteArray[127].call(callSiteArray[128].call((Object)this.moshi, Object.class), documentAsJson);
        Object object = callSiteArray[129].callGetProperty(result);
        callSiteArray[130].call(createdDocument, (Object)"_id", object);
        Object object4 = callSiteArray[131].callGetProperty(result);
        callSiteArray[132].call(createdDocument, (Object)"_rev", object4);
        return createdDocument;
    }

    public Object update(String db, Object document) {
        Object object;
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)document, null)) {
            throw (Throwable)callSiteArray[133].callConstructor(IllegalArgumentException.class, (Object)"document may not be null");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[134].call(document, (Object)"_id"))) {
            throw (Throwable)callSiteArray[135].callConstructor(IllegalArgumentException.class, (Object)"document id missing");
        }
        callSiteArray[136].callCurrent((GroovyObject)this, document);
        Object documentAsJson = callSiteArray[137].call(callSiteArray[138].call((Object)this.moshi, Map.class), document);
        Object body = callSiteArray[139].call(RequestBody.class, documentAsJson, callSiteArray[140].callStatic(MediaType.class, (Object)"application/json"));
        Object builder = callSiteArray[141].callConstructor(Request.Builder.class);
        String docId = ShortTypeHandling.castToString((Object)callSiteArray[142].call(document, (Object)"_id"));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[143].callStatic(CouchDBClient.class, (Object)docId);
            docId = ShortTypeHandling.castToString((Object)object2);
        } else {
            Object object3 = CouchDBClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object3);
        }
        builder = object = callSiteArray[144].call(callSiteArray[145].call(builder, (Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort, callSiteArray[146].call((Object)db), docId}, new String[]{"http://", ":", "/", "/", ""})), body);
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object4;
            builder = object4 = callSiteArray[147].call(builder, (Object)"Authorization", callSiteArray[148].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
        }
        Object request = callSiteArray[149].call(builder);
        Object response = callSiteArray[150].call(callSiteArray[151].call((Object)this.client, request));
        Object result = callSiteArray[152].callCurrent((GroovyObject)this, callSiteArray[153].call(callSiteArray[154].call(response)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[155].callGetProperty(result))) {
            callSiteArray[156].call((Object)log, (Object)"error {}", result);
            throw (Throwable)callSiteArray[157].callConstructor(IllegalStateException.class, (Object)"error updating document");
        }
        Object updatedDocument = callSiteArray[158].call(callSiteArray[159].call((Object)this.moshi, Object.class), documentAsJson);
        Object object5 = callSiteArray[160].callGetProperty(result);
        callSiteArray[161].call(updatedDocument, (Object)"_rev", object5);
        return updatedDocument;
    }

    public Object updateBulk(String db, List documents) {
        Object object;
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)documents, null)) {
            throw (Throwable)callSiteArray[162].callConstructor(IllegalArgumentException.class, (Object)"documents may not be null");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[163].callGetProperty((Object)documents))) {
            throw (Throwable)callSiteArray[164].callConstructor(IllegalArgumentException.class, (Object)"documents is empty");
        }
        public final class _updateBulk_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateBulk_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _updateBulk_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object document) {
                CallSite[] callSiteArray = _updateBulk_closure5.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(document, (Object)"_id"))) {
                    return callSiteArray[1].callCurrent((GroovyObject)this, document);
                }
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(document))) {
                    return callSiteArray[3].callCurrent((GroovyObject)this, document);
                }
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateBulk_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "beforeUpdate";
                stringArray[2] = "dateCreated";
                stringArray[3] = "beforeCreate";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _updateBulk_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateBulk_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateBulk_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[165].call((Object)documents, (Object)new _updateBulk_closure5(this, this));
        Map updateDoc = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"docs", documents});
        Object documentAsJson = callSiteArray[166].call(callSiteArray[167].call((Object)this.moshi, Object.class), (Object)updateDoc);
        Object body = callSiteArray[168].call(RequestBody.class, documentAsJson, callSiteArray[169].callStatic(MediaType.class, (Object)"application/json"));
        Object builder = callSiteArray[170].callConstructor(Request.Builder.class);
        builder = object = callSiteArray[171].call(callSiteArray[172].call(builder, (Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort, callSiteArray[173].call((Object)db)}, new String[]{"http://", ":", "/", "/_bulk_docs"})), body);
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object2;
            builder = object2 = callSiteArray[174].call(builder, (Object)"Authorization", callSiteArray[175].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
        }
        Object request = callSiteArray[176].call(builder);
        Object response = callSiteArray[177].call(callSiteArray[178].call((Object)this.client, request));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[179].callGetProperty(response))) {
            Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[180].call((Object)log)) ? callSiteArray[181].call((Object)log, (Object)"error {}", callSiteArray[182].call(response)) : null;
            throw (Throwable)callSiteArray[183].callConstructor(IllegalStateException.class, (Object)"bulk update failed");
        }
        Object result = callSiteArray[184].callCurrent((GroovyObject)this, callSiteArray[185].call(callSiteArray[186].call(response)));
        public final class _updateBulk_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateBulk_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _updateBulk_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object updated, Object original) {
                CallSite[] callSiteArray = _updateBulk_closure6.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(updated))) {
                    Object object = callSiteArray[1].callGetProperty(updated);
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)original, (String)"_id");
                    Object object2 = callSiteArray[2].callGetProperty(updated);
                    ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)original, (String)"_rev");
                    return original;
                }
                callSiteArray[3].call(ScriptBytecodeAdapter.getField(_updateBulk_closure6.class, CouchDBClient.class, (String)"log"), (Object)"error {}", updated);
                return null;
            }

            @Generated
            public Object call(Object updated, Object original) {
                CallSite[] callSiteArray = _updateBulk_closure6.$getCallSiteArray();
                return callSiteArray[4].callCurrent((GroovyObject)this, updated, original);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateBulk_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "ok";
                stringArray[1] = "id";
                stringArray[2] = "rev";
                stringArray[3] = "error";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _updateBulk_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateBulk_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateBulk_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[187].call(callSiteArray[188].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{result, documents})), (Object)new _updateBulk_closure6(this, this));
        return result;
    }

    public Object containsDb(String db) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        Object builder = callSiteArray[189].call(callSiteArray[190].call(callSiteArray[191].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort, callSiteArray[192].call((Object)db)}, new String[]{"http://", ":", "/", ""})));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object;
            builder = object = callSiteArray[193].call(builder, (Object)"Authorization", callSiteArray[194].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
        }
        Object request = callSiteArray[195].call(builder);
        Object response = callSiteArray[196].call(callSiteArray[197].call((Object)this.client, request));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[198].callGetProperty(response))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[199].call(response), (Object)404)) {
                return false;
            }
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[200].call((Object)log)) ? callSiteArray[201].call((Object)log, (Object)"error {}", callSiteArray[202].call(response)) : null;
            throw (Throwable)callSiteArray[203].callConstructor(IllegalStateException.class, (Object)"could not check for database existence");
        }
        return true;
    }

    public Object createDb(String db) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        Object builder = callSiteArray[204].call(callSiteArray[205].call(callSiteArray[206].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort, callSiteArray[207].call((Object)db)}, new String[]{"http://", ":", "/", ""})), callSiteArray[208].call(RequestBody.class, (Object)"", callSiteArray[209].callStatic(MediaType.class, (Object)"application/json")));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object;
            builder = object = callSiteArray[210].call(builder, (Object)"Authorization", callSiteArray[211].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
        }
        Object request = callSiteArray[212].call(builder);
        Object response = callSiteArray[213].call(callSiteArray[214].call((Object)this.client, request));
        Object result = callSiteArray[215].callCurrent((GroovyObject)this, callSiteArray[216].call(callSiteArray[217].call(response)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[218].callGetProperty(result))) {
            callSiteArray[219].call((Object)log, (Object)"error {}", result);
            throw (Throwable)callSiteArray[220].callConstructor(IllegalStateException.class, (Object)"error creating database");
        }
        return result;
    }

    public Object deleteDb(String db) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        Object builder = callSiteArray[221].call(callSiteArray[222].call(callSiteArray[223].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort, callSiteArray[224].call((Object)db)}, new String[]{"http://", ":", "/", ""})));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object;
            builder = object = callSiteArray[225].call(builder, (Object)"Authorization", callSiteArray[226].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
        }
        Object request = callSiteArray[227].call(builder);
        Object response = callSiteArray[228].call(callSiteArray[229].call((Object)this.client, request));
        Object result = callSiteArray[230].callCurrent((GroovyObject)this, callSiteArray[231].call(callSiteArray[232].call(response)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[233].callGetProperty(result))) {
            callSiteArray[234].call((Object)log, (Object)"error {}", result);
            throw (Throwable)callSiteArray[235].callConstructor(IllegalStateException.class, (Object)"error deleting database");
        }
        return result;
    }

    public Object createFindAllDocsView(String db) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        String findAll = "function(doc) { emit(null, doc._id) }";
        return callSiteArray[236].callCurrent((GroovyObject)this, (Object)db, (Object)"all", (Object)findAll, null);
    }

    public Object createFindByPropertyView(String db, String propertyName) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        String findByProperty = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{propertyName, propertyName}, new String[]{"function(doc) { if (doc['", "']) { emit(doc['", "'], doc._id) } }"}));
        return callSiteArray[237].callCurrent((GroovyObject)this, (Object)db, (Object)new GStringImpl(new Object[]{propertyName}, new String[]{"by_", ""}), (Object)findByProperty, null);
    }

    public Object createView(String db, String viewName, String mapFunction, String reduceFunction) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        Map view = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)mapFunction)) {
            String string = mapFunction;
            callSiteArray[238].call((Object)view, (Object)"map", (Object)string);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)reduceFunction)) {
            String string = reduceFunction;
            callSiteArray[239].call((Object)view, (Object)"reduce", (Object)string);
        }
        String designDocId = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[240].call((Object)db)}, new String[]{"_design/", ""}));
        Map newDesignDoc = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"_id", designDocId, "language", "javascript", "views", ScriptBytecodeAdapter.createMap((Object[])new Object[]{viewName, view})});
        Object designDocExists = null;
        designDocExists = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[241].callCurrent((GroovyObject)this, (Object)db, (Object)designDocId)) : (object = this.contains(db, designDocId));
        if (DefaultTypeTransformation.booleanUnbox((Object)designDocExists)) {
            Object object3;
            Object object4;
            Object currentDesignDoc = null;
            currentDesignDoc = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object4 = callSiteArray[242].callCurrent((GroovyObject)this, (Object)db, (Object)designDocId)) : (object3 = this.get(db, designDocId));
            Object mergedDesignDoc = callSiteArray[243].callStatic(CouchDBClient.class, currentDesignDoc, (Object)newDesignDoc);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)mergedDesignDoc, (Object)currentDesignDoc)) {
                callSiteArray[244].callCurrent((GroovyObject)this, (Object)db, mergedDesignDoc);
            }
            return currentDesignDoc;
        }
        return callSiteArray[245].callCurrent((GroovyObject)this, (Object)db, (Object)newDesignDoc);
    }

    public Object contains(String db, String docId) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[246].callStatic(CouchDBClient.class, (Object)docId);
            docId = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = CouchDBClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
        }
        Object builder = callSiteArray[247].call(callSiteArray[248].call(callSiteArray[249].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort, callSiteArray[250].call((Object)db), docId}, new String[]{"http://", ":", "/", "/", ""})));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object;
            builder = object = callSiteArray[251].call(builder, (Object)"Authorization", callSiteArray[252].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
        }
        Object request = callSiteArray[253].call(builder);
        Object response = callSiteArray[254].call(callSiteArray[255].call((Object)this.client, request));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[256].callGetProperty(response))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[257].call(response), (Object)404)) {
                return false;
            }
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[258].call((Object)log)) ? callSiteArray[259].call((Object)log, (Object)"error {}", callSiteArray[260].call(response)) : null;
            throw (Throwable)callSiteArray[261].callConstructor(IllegalStateException.class, (Object)"could not check for doc existence");
        }
        return true;
    }

    public Object get(String db, String docId) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[262].callStatic(CouchDBClient.class, (Object)docId);
            docId = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = CouchDBClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
        }
        Object builder = callSiteArray[263].call(callSiteArray[264].call(callSiteArray[265].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort, callSiteArray[266].call((Object)db), docId}, new String[]{"http://", ":", "/", "/", ""})));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object;
            builder = object = callSiteArray[267].call(builder, (Object)"Authorization", callSiteArray[268].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
        }
        Object request = callSiteArray[269].call(builder);
        Object response = callSiteArray[270].call(callSiteArray[271].call((Object)this.client, request));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[272].callGetProperty(response))) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[273].call((Object)log)) ? callSiteArray[274].call((Object)log, (Object)"error getting document({}): {}/{}", (Object)docId, callSiteArray[275].call(response), callSiteArray[276].call(response)) : null;
            throw (Throwable)callSiteArray[277].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{docId}, new String[]{"could not get doc with id '", "'"}));
        }
        return callSiteArray[278].callCurrent((GroovyObject)this, callSiteArray[279].call(callSiteArray[280].call(response)));
    }

    public Object delete(String db, String docId, String rev) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[281].callStatic(CouchDBClient.class, (Object)docId);
            docId = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = CouchDBClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
        }
        Object builder = callSiteArray[282].call(callSiteArray[283].call(callSiteArray[284].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.couchdbHost, this.couchdbPort, callSiteArray[285].call((Object)db), docId, rev}, new String[]{"http://", ":", "/", "/", "?rev=", ""})));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object;
            builder = object = callSiteArray[286].call(builder, (Object)"Authorization", callSiteArray[287].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
        }
        Object request = callSiteArray[288].call(builder);
        Object response = callSiteArray[289].call(callSiteArray[290].call((Object)this.client, request));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[291].callGetProperty(response))) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[292].call((Object)log)) ? callSiteArray[293].call((Object)log, ArrayUtil.createArray((Object)"error deleting doc{ _id:{}, _rev:{} }: {}/{}", (Object)docId, (Object)rev, (Object)callSiteArray[294].call(response), (Object)callSiteArray[295].call(response))) : null;
            throw (Throwable)callSiteArray[296].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{docId, rev}, new String[]{"could not delete doc with id/rev '", "'/'", "'"}));
        }
        Object result = callSiteArray[297].callCurrent((GroovyObject)this, callSiteArray[298].call(callSiteArray[299].call(response)));
        return result;
    }

    public static Object merge(Object currentDoc, Object changedDoc) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        Object mergedDoc = callSiteArray[300].call(currentDoc, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        Object object = callSiteArray[302].callGetProperty(currentDoc);
        Object object2 = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object object3 = callSiteArray[303].callGetProperty(changedDoc);
        Object object4 = callSiteArray[301].call(object2, DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)mergedDoc, (String)"views");
        return mergedDoc;
    }

    public Object consume(InputStream stream) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        Object result = callSiteArray[304].call(callSiteArray[305].call((Object)this.moshi, Object.class), callSiteArray[306].call(Okio.class, callSiteArray[307].call(Okio.class, (Object)stream)));
        callSiteArray[308].call(Util.class, (Object)stream);
        return result;
    }

    public static Object sanitizeDocId(String docId) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[309].call((Object)docId, (Object)"_"))) {
            Object object = callSiteArray[310].call(URLEncoder.class, (Object)docId, callSiteArray[311].call(callSiteArray[312].callGetProperty(StandardCharsets.class)));
            docId = ShortTypeHandling.castToString((Object)object);
        }
        return docId;
    }

    public Object beforeCreate(Object document) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[313].callGetProperty(document))) {
            Object object = callSiteArray[314].call(callSiteArray[315].call(LocalDate.class));
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)document, (String)"dateCreated");
            return object;
        }
        return null;
    }

    public Object beforeUpdate(Object document) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        Object object = callSiteArray[316].call(callSiteArray[317].call(LocalDate.class));
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)document, (String)"dateUpdated");
        return object;
    }

    @Generated
    public <R> R query(String db, String viewName, String key) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.query(db, viewName, key, true);
        }
        return this.query(db, viewName, key, true);
    }

    @Generated
    public <R> R query(String db, String viewName, Collection<String> keys) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        return this.query(db, viewName, keys, true);
    }

    @Generated
    public Object getAllDocs(String db, boolean includeDocs) {
        Reference includeDocs2 = new Reference((Object)includeDocs);
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getAllDocs(db, DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get()), false);
        }
        return this.getAllDocs(db, DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get()), false);
    }

    @Generated
    public Object getAllDocs(String db) {
        CallSite[] callSiteArray = CouchDBClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getAllDocs(db, true, false);
        }
        return this.getAllDocs(db, true, false);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CouchDBClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = CouchDBClient.$getCallSiteArray()[318].call(LoggerFactory.class, (Object)"de.gesellix.couchdb.CouchDBClient");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public OkHttpClient getClient() {
        return this.client;
    }

    @Generated
    public void setClient(OkHttpClient okHttpClient) {
        this.client = okHttpClient;
    }

    @Generated
    public Moshi getMoshi() {
        return this.moshi;
    }

    @Generated
    public void setMoshi(Moshi moshi) {
        this.moshi = moshi;
    }

    @Generated
    public String getCouchdbHost() {
        return this.couchdbHost;
    }

    @Generated
    public void setCouchdbHost(String string) {
        this.couchdbHost = string;
    }

    @Generated
    public int getCouchdbPort() {
        return this.couchdbPort;
    }

    @Generated
    public void setCouchdbPort(int n) {
        this.couchdbPort = n;
    }

    @Generated
    public String getCouchdbUsername() {
        return this.couchdbUsername;
    }

    @Generated
    public void setCouchdbUsername(String string) {
        this.couchdbUsername = string;
    }

    @Generated
    public String getCouchdbPassword() {
        return this.couchdbPassword;
    }

    @Generated
    public void setCouchdbPassword(String string) {
        this.couchdbPassword = string;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "build";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "get";
        stringArray[4] = "url";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "build";
        stringArray[7] = "execute";
        stringArray[8] = "newCall";
        stringArray[9] = "successful";
        stringArray[10] = "code";
        stringArray[11] = "close";
        stringArray[12] = "body";
        stringArray[13] = "isErrorEnabled";
        stringArray[14] = "error";
        stringArray[15] = "message";
        stringArray[16] = "close";
        stringArray[17] = "body";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "isInfoEnabled";
        stringArray[20] = "info";
        stringArray[21] = "string";
        stringArray[22] = "body";
        stringArray[23] = "toJson";
        stringArray[24] = "adapter";
        stringArray[25] = "build";
        stringArray[26] = "url";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "plus";
        stringArray[29] = "plus";
        stringArray[30] = "plus";
        stringArray[31] = "plus";
        stringArray[32] = "plus";
        stringArray[33] = "toLowerCase";
        stringArray[34] = "capitalize";
        stringArray[35] = "execute";
        stringArray[36] = "newCall";
        stringArray[37] = "successful";
        stringArray[38] = "error";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "string";
        stringArray[41] = "body";
        stringArray[42] = "consume";
        stringArray[43] = "byteStream";
        stringArray[44] = "body";
        stringArray[45] = "collect";
        stringArray[46] = "rows";
        stringArray[47] = "toJson";
        stringArray[48] = "adapter";
        stringArray[49] = "build";
        stringArray[50] = "url";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "plus";
        stringArray[53] = "plus";
        stringArray[54] = "plus";
        stringArray[55] = "plus";
        stringArray[56] = "plus";
        stringArray[57] = "toLowerCase";
        stringArray[58] = "capitalize";
        stringArray[59] = "execute";
        stringArray[60] = "newCall";
        stringArray[61] = "successful";
        stringArray[62] = "error";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "string";
        stringArray[65] = "body";
        stringArray[66] = "consume";
        stringArray[67] = "byteStream";
        stringArray[68] = "body";
        stringArray[69] = "collect";
        stringArray[70] = "rows";
        stringArray[71] = "get";
        stringArray[72] = "url";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "plus";
        stringArray[75] = "plus";
        stringArray[76] = "toLowerCase";
        stringArray[77] = "header";
        stringArray[78] = "basic";
        stringArray[79] = "build";
        stringArray[80] = "execute";
        stringArray[81] = "newCall";
        stringArray[82] = "successful";
        stringArray[83] = "isErrorEnabled";
        stringArray[84] = "error";
        stringArray[85] = "code";
        stringArray[86] = "message";
        stringArray[87] = "<$constructor$>";
        stringArray[88] = "consume";
        stringArray[89] = "byteStream";
        stringArray[90] = "body";
        stringArray[91] = "collect";
        stringArray[92] = "rows";
        stringArray[93] = "grep";
        stringArray[94] = "<$constructor$>";
        stringArray[95] = "getAt";
        stringArray[96] = "isErrorEnabled";
        stringArray[97] = "error";
        stringArray[98] = "getAt";
        stringArray[99] = "getAt";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "beforeCreate";
        stringArray[102] = "toJson";
        stringArray[103] = "adapter";
        stringArray[104] = "create";
        stringArray[105] = "parse";
        stringArray[106] = "<$constructor$>";
        stringArray[107] = "getAt";
        stringArray[108] = "getAt";
        stringArray[109] = "sanitizeDocId";
        stringArray[110] = "put";
        stringArray[111] = "url";
        stringArray[112] = "toLowerCase";
        stringArray[113] = "post";
        stringArray[114] = "url";
        stringArray[115] = "toLowerCase";
        stringArray[116] = "header";
        stringArray[117] = "basic";
        stringArray[118] = "build";
        stringArray[119] = "execute";
        stringArray[120] = "newCall";
        stringArray[121] = "consume";
        stringArray[122] = "byteStream";
        stringArray[123] = "body";
        stringArray[124] = "ok";
        stringArray[125] = "error";
        stringArray[126] = "<$constructor$>";
        stringArray[127] = "fromJson";
        stringArray[128] = "adapter";
        stringArray[129] = "id";
        stringArray[130] = "putAt";
        stringArray[131] = "rev";
        stringArray[132] = "putAt";
        stringArray[133] = "<$constructor$>";
        stringArray[134] = "getAt";
        stringArray[135] = "<$constructor$>";
        stringArray[136] = "beforeUpdate";
        stringArray[137] = "toJson";
        stringArray[138] = "adapter";
        stringArray[139] = "create";
        stringArray[140] = "parse";
        stringArray[141] = "<$constructor$>";
        stringArray[142] = "getAt";
        stringArray[143] = "sanitizeDocId";
        stringArray[144] = "put";
        stringArray[145] = "url";
        stringArray[146] = "toLowerCase";
        stringArray[147] = "header";
        stringArray[148] = "basic";
        stringArray[149] = "build";
        stringArray[150] = "execute";
        stringArray[151] = "newCall";
        stringArray[152] = "consume";
        stringArray[153] = "byteStream";
        stringArray[154] = "body";
        stringArray[155] = "ok";
        stringArray[156] = "error";
        stringArray[157] = "<$constructor$>";
        stringArray[158] = "fromJson";
        stringArray[159] = "adapter";
        stringArray[160] = "rev";
        stringArray[161] = "putAt";
        stringArray[162] = "<$constructor$>";
        stringArray[163] = "empty";
        stringArray[164] = "<$constructor$>";
        stringArray[165] = "each";
        stringArray[166] = "toJson";
        stringArray[167] = "adapter";
        stringArray[168] = "create";
        stringArray[169] = "parse";
        stringArray[170] = "<$constructor$>";
        stringArray[171] = "post";
        stringArray[172] = "url";
        stringArray[173] = "toLowerCase";
        stringArray[174] = "header";
        stringArray[175] = "basic";
        stringArray[176] = "build";
        stringArray[177] = "execute";
        stringArray[178] = "newCall";
        stringArray[179] = "successful";
        stringArray[180] = "isErrorEnabled";
        stringArray[181] = "error";
        stringArray[182] = "message";
        stringArray[183] = "<$constructor$>";
        stringArray[184] = "consume";
        stringArray[185] = "byteStream";
        stringArray[186] = "body";
        stringArray[187] = "each";
        stringArray[188] = "transpose";
        stringArray[189] = "head";
        stringArray[190] = "url";
        stringArray[191] = "<$constructor$>";
        stringArray[192] = "toLowerCase";
        stringArray[193] = "header";
        stringArray[194] = "basic";
        stringArray[195] = "build";
        stringArray[196] = "execute";
        stringArray[197] = "newCall";
        stringArray[198] = "successful";
        stringArray[199] = "code";
        stringArray[200] = "isErrorEnabled";
        stringArray[201] = "error";
        stringArray[202] = "message";
        stringArray[203] = "<$constructor$>";
        stringArray[204] = "put";
        stringArray[205] = "url";
        stringArray[206] = "<$constructor$>";
        stringArray[207] = "toLowerCase";
        stringArray[208] = "create";
        stringArray[209] = "parse";
        stringArray[210] = "header";
        stringArray[211] = "basic";
        stringArray[212] = "build";
        stringArray[213] = "execute";
        stringArray[214] = "newCall";
        stringArray[215] = "consume";
        stringArray[216] = "byteStream";
        stringArray[217] = "body";
        stringArray[218] = "ok";
        stringArray[219] = "error";
        stringArray[220] = "<$constructor$>";
        stringArray[221] = "delete";
        stringArray[222] = "url";
        stringArray[223] = "<$constructor$>";
        stringArray[224] = "toLowerCase";
        stringArray[225] = "header";
        stringArray[226] = "basic";
        stringArray[227] = "build";
        stringArray[228] = "execute";
        stringArray[229] = "newCall";
        stringArray[230] = "consume";
        stringArray[231] = "byteStream";
        stringArray[232] = "body";
        stringArray[233] = "ok";
        stringArray[234] = "error";
        stringArray[235] = "<$constructor$>";
        stringArray[236] = "createView";
        stringArray[237] = "createView";
        stringArray[238] = "putAt";
        stringArray[239] = "putAt";
        stringArray[240] = "capitalize";
        stringArray[241] = "contains";
        stringArray[242] = "get";
        stringArray[243] = "merge";
        stringArray[244] = "update";
        stringArray[245] = "update";
        stringArray[246] = "sanitizeDocId";
        stringArray[247] = "head";
        stringArray[248] = "url";
        stringArray[249] = "<$constructor$>";
        stringArray[250] = "toLowerCase";
        stringArray[251] = "header";
        stringArray[252] = "basic";
        stringArray[253] = "build";
        stringArray[254] = "execute";
        stringArray[255] = "newCall";
        stringArray[256] = "successful";
        stringArray[257] = "code";
        stringArray[258] = "isErrorEnabled";
        stringArray[259] = "error";
        stringArray[260] = "message";
        stringArray[261] = "<$constructor$>";
        stringArray[262] = "sanitizeDocId";
        stringArray[263] = "get";
        stringArray[264] = "url";
        stringArray[265] = "<$constructor$>";
        stringArray[266] = "toLowerCase";
        stringArray[267] = "header";
        stringArray[268] = "basic";
        stringArray[269] = "build";
        stringArray[270] = "execute";
        stringArray[271] = "newCall";
        stringArray[272] = "successful";
        stringArray[273] = "isErrorEnabled";
        stringArray[274] = "error";
        stringArray[275] = "code";
        stringArray[276] = "message";
        stringArray[277] = "<$constructor$>";
        stringArray[278] = "consume";
        stringArray[279] = "byteStream";
        stringArray[280] = "body";
        stringArray[281] = "sanitizeDocId";
        stringArray[282] = "delete";
        stringArray[283] = "url";
        stringArray[284] = "<$constructor$>";
        stringArray[285] = "toLowerCase";
        stringArray[286] = "header";
        stringArray[287] = "basic";
        stringArray[288] = "build";
        stringArray[289] = "execute";
        stringArray[290] = "newCall";
        stringArray[291] = "successful";
        stringArray[292] = "isErrorEnabled";
        stringArray[293] = "error";
        stringArray[294] = "code";
        stringArray[295] = "message";
        stringArray[296] = "<$constructor$>";
        stringArray[297] = "consume";
        stringArray[298] = "byteStream";
        stringArray[299] = "body";
        stringArray[300] = "plus";
        stringArray[301] = "plus";
        stringArray[302] = "views";
        stringArray[303] = "views";
        stringArray[304] = "fromJson";
        stringArray[305] = "adapter";
        stringArray[306] = "buffer";
        stringArray[307] = "source";
        stringArray[308] = "closeQuietly";
        stringArray[309] = "startsWith";
        stringArray[310] = "encode";
        stringArray[311] = "toString";
        stringArray[312] = "UTF_8";
        stringArray[313] = "dateCreated";
        stringArray[314] = "toString";
        stringArray[315] = "now";
        stringArray[316] = "toString";
        stringArray[317] = "now";
        stringArray[318] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[319];
        CouchDBClient.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(CouchDBClient.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = CouchDBClient.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

