/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.couchdb;

import com.squareup.moshi.Moshi;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.Okio;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDbClient
implements GroovyObject {
    private static final Logger log;
    private OkHttpClient client;
    private Moshi moshi;
    private boolean tlsEnabled;
    private String couchdbHost;
    private int couchdbPort;
    private String baseUrl;
    private String couchdbUsername;
    private String couchdbPassword;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public CouchDbClient() {
        int n;
        String string;
        boolean bl;
        MetaClass metaClass;
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callConstructor(OkHttpClient.class);
        this.client = (OkHttpClient)ScriptBytecodeAdapter.castToType((Object)object, OkHttpClient.class);
        Object object2 = callSiteArray[1].call(callSiteArray[2].callConstructor(Moshi.Builder.class));
        this.moshi = (Moshi)ScriptBytecodeAdapter.castToType((Object)object2, Moshi.class);
        this.tlsEnabled = bl = false;
        this.couchdbHost = string = "127.0.0.1";
        this.couchdbPort = n = 5984;
    }

    public void updateBaseUrl() {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        GStringImpl gStringImpl = new GStringImpl(new Object[]{this.tlsEnabled ? "https" : "http", this.couchdbHost, this.couchdbPort}, new String[]{"", "://", ":", ""});
        this.baseUrl = ShortTypeHandling.castToString((Object)gStringImpl);
    }

    public String getBaseUrl() {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.baseUrl, null)) {
                callSiteArray[3].callCurrent((GroovyObject)this);
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)this.baseUrl, null)) {
            this.updateBaseUrl();
        }
        return this.baseUrl;
    }

    public void setTlsEnabled(boolean tlsEnabled) {
        boolean bl;
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        this.tlsEnabled = bl = tlsEnabled;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[4].callCurrent((GroovyObject)this);
        } else {
            this.updateBaseUrl();
        }
    }

    public void setCouchdbHost(String couchdbHost) {
        String string;
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        this.couchdbHost = string = couchdbHost;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[5].callCurrent((GroovyObject)this);
        } else {
            this.updateBaseUrl();
        }
    }

    public void setCouchdbPort(int couchdbPort) {
        int n;
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        this.couchdbPort = n = couchdbPort;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[6].callCurrent((GroovyObject)this);
        } else {
            this.updateBaseUrl();
        }
    }

    public boolean healthy() {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].callConstructor(Request.Builder.class), callSiteArray[10].callCurrent((GroovyObject)this)));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].callConstructor(Request.Builder.class), (Object)this.getBaseUrl()));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].call(callSiteArray[16].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callGetProperty((Object)response))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[18].call((Object)response), (Object)404)) {
                callSiteArray[19].call(callSiteArray[20].call((Object)response));
                return false;
            }
            callSiteArray[21].call((Object)log, (Object)"error {}", callSiteArray[22].call((Object)response));
            callSiteArray[23].call(callSiteArray[24].call((Object)response));
            throw (Throwable)callSiteArray[25].callConstructor(IllegalStateException.class, (Object)"could not check for database existence");
        }
        callSiteArray[26].call((Object)log, callSiteArray[27].call(callSiteArray[28].call((Object)response)));
        return true;
    }

    public <R> R query(String db, String viewName, String key, boolean includeDocs) {
        Reference includeDocs2 = new Reference((Object)includeDocs);
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        String encodedKey = ShortTypeHandling.castToString((Object)callSiteArray[29].call(callSiteArray[30].call((Object)this.moshi, String.class), (Object)key));
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[31].call(callSiteArray[32].call(callSiteArray[33].callConstructor(Request.Builder.class), callSiteArray[34].call(callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].call(callSiteArray[39].callCurrent((GroovyObject)this), (Object)new GStringImpl(new Object[]{callSiteArray[40].call((Object)db)}, new String[]{"/", ""})), (Object)new GStringImpl(new Object[]{callSiteArray[41].call((Object)db)}, new String[]{"/_design/", ""})), (Object)new GStringImpl(new Object[]{viewName}, new String[]{"/_view/", ""})), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""})), (Object)new GStringImpl(new Object[]{encodedKey}, new String[]{"&key=", ""}))));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].callConstructor(Request.Builder.class), callSiteArray[45].call(callSiteArray[46].call(callSiteArray[47].call(callSiteArray[48].call(callSiteArray[49].call((Object)this.getBaseUrl(), (Object)new GStringImpl(new Object[]{callSiteArray[50].call((Object)db)}, new String[]{"/", ""})), (Object)new GStringImpl(new Object[]{callSiteArray[51].call((Object)db)}, new String[]{"/_design/", ""})), (Object)new GStringImpl(new Object[]{viewName}, new String[]{"/_view/", ""})), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""})), (Object)new GStringImpl(new Object[]{encodedKey}, new String[]{"&key=", ""}))));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[52].call((Object)builder, (Object)"Authorization", callSiteArray[53].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call(callSiteArray[56].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[57].callGetProperty((Object)response))) {
            callSiteArray[58].call((Object)log, (Object)"request failed: {}", (Object)request);
            throw (Throwable)callSiteArray[59].callConstructor(IOException.class, callSiteArray[60].call(callSiteArray[61].call((Object)response)));
        }
        Object result = callSiteArray[62].callCurrent((GroovyObject)this, callSiteArray[63].call(callSiteArray[64].call((Object)response)));
        public final class _query_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includeDocs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _query_closure1(Object _outerInstance, Object _thisObject, Reference includeDocs) {
                Reference reference;
                CallSite[] callSiteArray = _query_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.includeDocs = reference = includeDocs;
            }

            public Object doCall(Object row) {
                CallSite[] callSiteArray = _query_closure1.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get()) ? callSiteArray[0].callGetProperty(row) : row;
            }

            @Generated
            public boolean getIncludeDocs() {
                CallSite[] callSiteArray = _query_closure1.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _query_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doc";
                return new CallSiteArray(_query_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _query_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (R)callSiteArray[65].call(callSiteArray[66].callGetProperty(result), (Object)new _query_closure1(this, this, includeDocs2));
    }

    public <R> R query(String db, String viewName, Collection<String> keys, boolean includeDocs) {
        Reference includeDocs2 = new Reference((Object)includeDocs);
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        String encodedKeys = ShortTypeHandling.castToString((Object)callSiteArray[67].call(callSiteArray[68].call((Object)this.moshi, Collection.class), keys));
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[69].call(callSiteArray[70].call(callSiteArray[71].callConstructor(Request.Builder.class), callSiteArray[72].call(callSiteArray[73].call(callSiteArray[74].call(callSiteArray[75].call(callSiteArray[76].call(callSiteArray[77].callCurrent((GroovyObject)this), (Object)new GStringImpl(new Object[]{callSiteArray[78].call((Object)db)}, new String[]{"/", ""})), (Object)new GStringImpl(new Object[]{callSiteArray[79].call((Object)db)}, new String[]{"/_design/", ""})), (Object)new GStringImpl(new Object[]{viewName}, new String[]{"/_view/", ""})), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""})), (Object)new GStringImpl(new Object[]{encodedKeys}, new String[]{"&keys=", ""}))));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[80].call(callSiteArray[81].call(callSiteArray[82].callConstructor(Request.Builder.class), callSiteArray[83].call(callSiteArray[84].call(callSiteArray[85].call(callSiteArray[86].call(callSiteArray[87].call((Object)this.getBaseUrl(), (Object)new GStringImpl(new Object[]{callSiteArray[88].call((Object)db)}, new String[]{"/", ""})), (Object)new GStringImpl(new Object[]{callSiteArray[89].call((Object)db)}, new String[]{"/_design/", ""})), (Object)new GStringImpl(new Object[]{viewName}, new String[]{"/_view/", ""})), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""})), (Object)new GStringImpl(new Object[]{encodedKeys}, new String[]{"&keys=", ""}))));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[90].call((Object)builder, (Object)"Authorization", callSiteArray[91].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[92].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].call(callSiteArray[94].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[95].callGetProperty((Object)response))) {
            callSiteArray[96].call((Object)log, (Object)"request failed: {}", (Object)request);
            throw (Throwable)callSiteArray[97].callConstructor(IOException.class, callSiteArray[98].call(callSiteArray[99].call((Object)response)));
        }
        Object result = callSiteArray[100].callCurrent((GroovyObject)this, callSiteArray[101].call(callSiteArray[102].call((Object)response)));
        public final class _query_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includeDocs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _query_closure2(Object _outerInstance, Object _thisObject, Reference includeDocs) {
                Reference reference;
                CallSite[] callSiteArray = _query_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.includeDocs = reference = includeDocs;
            }

            public Object doCall(Object row) {
                CallSite[] callSiteArray = _query_closure2.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get()) ? callSiteArray[0].callGetProperty(row) : row;
            }

            @Generated
            public boolean getIncludeDocs() {
                CallSite[] callSiteArray = _query_closure2.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _query_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doc";
                return new CallSiteArray(_query_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _query_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (R)callSiteArray[103].call(callSiteArray[104].callGetProperty(result), (Object)new _query_closure2(this, this, includeDocs2));
    }

    public Object getAllDocs(String db, boolean includeDocs, boolean includeDesignDoc) {
        Object object;
        Reference includeDocs2 = new Reference((Object)includeDocs);
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].callConstructor(Request.Builder.class), callSiteArray[108].call(callSiteArray[109].call((Object)new GStringImpl(new Object[]{callSiteArray[110].callCurrent((GroovyObject)this), callSiteArray[111].call((Object)db)}, new String[]{"", "/", ""}), (Object)"/_all_docs"), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""}))));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object2, Request.Builder.class);
        } else {
            Object object3 = callSiteArray[112].call(callSiteArray[113].call(callSiteArray[114].callConstructor(Request.Builder.class), callSiteArray[115].call(callSiteArray[116].call((Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[117].call((Object)db)}, new String[]{"", "/", ""}), (Object)"/_all_docs"), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""}))));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object3, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object4 = callSiteArray[118].call((Object)builder, (Object)"Authorization", callSiteArray[119].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object4, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[120].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[121].call(callSiteArray[122].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[123].callGetProperty((Object)response))) {
            callSiteArray[124].call((Object)log, (Object)"error getting all docs: {}/{}", callSiteArray[125].call((Object)response), callSiteArray[126].call((Object)response));
            throw (Throwable)callSiteArray[127].callConstructor(IllegalStateException.class, (Object)"could not get all docs with");
        }
        Object allDocs = callSiteArray[128].callCurrent((GroovyObject)this, callSiteArray[129].call(callSiteArray[130].call((Object)response)));
        public final class _getAllDocs_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includeDocs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getAllDocs_closure3(Object _outerInstance, Object _thisObject, Reference includeDocs) {
                Reference reference;
                CallSite[] callSiteArray = _getAllDocs_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.includeDocs = reference = includeDocs;
            }

            public Object doCall(Object row) {
                CallSite[] callSiteArray = _getAllDocs_closure3.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get()) ? callSiteArray[0].callGetProperty(row) : row;
            }

            @Generated
            public boolean getIncludeDocs() {
                CallSite[] callSiteArray = _getAllDocs_closure3.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAllDocs_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doc";
                return new CallSiteArray(_getAllDocs_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getAllDocs_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        allDocs = object = callSiteArray[131].call(callSiteArray[132].callGetProperty(allDocs), (Object)new _getAllDocs_closure3(this, this, includeDocs2));
        if (!includeDesignDoc) {
            Object object5;
            public final class _getAllDocs_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getAllDocs_closure4(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _getAllDocs_closure4.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getAllDocs_closure4.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callSafe(callSiteArray[1].callGetProperty(it), (Object)"_design/")) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callSafe(callSiteArray[3].callGetProperty(it), (Object)"_design/"));
                    }
                    return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callSafe(callSiteArray[5].callGetProperty(it), (Object)"_design/")) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callSafe(callSiteArray[7].callGetProperty(it), (Object)"_design/"));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _getAllDocs_closure4.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAllDocs_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "startsWith";
                    stringArray[1] = "_id";
                    stringArray[2] = "startsWith";
                    stringArray[3] = "id";
                    stringArray[4] = "startsWith";
                    stringArray[5] = "_id";
                    stringArray[6] = "startsWith";
                    stringArray[7] = "id";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _getAllDocs_closure4.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getAllDocs_closure4.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getAllDocs_closure4.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            allDocs = object5 = callSiteArray[133].call(allDocs, (Object)new _getAllDocs_closure4(this, this));
        }
        return allDocs;
    }

    public Object create(String db, Map document) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)document, null)) {
            throw (Throwable)callSiteArray[134].callConstructor(IllegalArgumentException.class, (Object)"document may not be null");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[135].call((Object)document, (Object)"_rev"))) {
            callSiteArray[136].call((Object)log, (Object)"document must be new, but has id({}), rev({})", callSiteArray[137].call((Object)document, (Object)"_id"), callSiteArray[138].call((Object)document, (Object)"_rev"));
            throw (Throwable)callSiteArray[139].callConstructor(IllegalArgumentException.class, (Object)"document must be new");
        }
        callSiteArray[140].callCurrent((GroovyObject)this, (Object)document);
        String documentAsJson = ShortTypeHandling.castToString((Object)callSiteArray[141].call(callSiteArray[142].call((Object)this.moshi, Map.class), (Object)document));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[143].call(RequestBody.class, (Object)documentAsJson, callSiteArray[144].callStatic(MediaType.class, (Object)"application/json")), RequestBody.class);
        Request.Builder builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[145].callConstructor(Request.Builder.class), Request.Builder.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[146].call((Object)document, (Object)"_id"))) {
                String docId = ShortTypeHandling.castToString((Object)callSiteArray[147].call((Object)document, (Object)"_id"));
                Object object = callSiteArray[148].callStatic(CouchDbClient.class, (Object)docId);
                docId = ShortTypeHandling.castToString((Object)object);
                Object object2 = callSiteArray[149].call(callSiteArray[150].call((Object)builder, (Object)new GStringImpl(new Object[]{callSiteArray[151].callCurrent((GroovyObject)this), callSiteArray[152].call((Object)db), docId}, new String[]{"", "/", "/", ""})), (Object)body);
                builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object2, Request.Builder.class);
            } else {
                Object object = callSiteArray[153].call(callSiteArray[154].call((Object)builder, (Object)new GStringImpl(new Object[]{callSiteArray[155].callCurrent((GroovyObject)this), callSiteArray[156].call((Object)db)}, new String[]{"", "/", ""})), (Object)body);
                builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[157].call((Object)document, (Object)"_id"))) {
            String docId = ShortTypeHandling.castToString((Object)callSiteArray[158].call((Object)document, (Object)"_id"));
            Object object = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
            Object object3 = callSiteArray[159].call(callSiteArray[160].call((Object)builder, (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[161].call((Object)db), docId}, new String[]{"", "/", "/", ""})), (Object)body);
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object3, Request.Builder.class);
        } else {
            Object object = callSiteArray[162].call(callSiteArray[163].call((Object)builder, (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[164].call((Object)db)}, new String[]{"", "/", ""})), (Object)body);
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[165].call((Object)builder, (Object)"Authorization", callSiteArray[166].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[167].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[168].call(callSiteArray[169].call((Object)this.client, (Object)request)), Response.class);
        Map result = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[170].callCurrent((GroovyObject)this, callSiteArray[171].call(callSiteArray[172].call((Object)response))), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[173].callGetProperty((Object)result))) {
            callSiteArray[174].call((Object)log, (Object)"error {}", (Object)result);
            throw (Throwable)callSiteArray[175].callConstructor(IllegalStateException.class, (Object)"error creating document");
        }
        Map createdDocument = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[176].call(callSiteArray[177].call((Object)this.moshi, Map.class), (Object)documentAsJson), Map.class);
        Object object = callSiteArray[178].callGetProperty((Object)result);
        callSiteArray[179].call((Object)createdDocument, (Object)"_id", object);
        Object object4 = callSiteArray[180].callGetProperty((Object)result);
        callSiteArray[181].call((Object)createdDocument, (Object)"_rev", object4);
        return createdDocument;
    }

    public Object update(String db, Map document) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)document, null)) {
            throw (Throwable)callSiteArray[182].callConstructor(IllegalArgumentException.class, (Object)"document may not be null");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[183].call((Object)document, (Object)"_id"))) {
            throw (Throwable)callSiteArray[184].callConstructor(IllegalArgumentException.class, (Object)"document id missing");
        }
        callSiteArray[185].callCurrent((GroovyObject)this, (Object)document);
        String documentAsJson = ShortTypeHandling.castToString((Object)callSiteArray[186].call(callSiteArray[187].call((Object)this.moshi, Map.class), (Object)document));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[188].call(RequestBody.class, (Object)documentAsJson, callSiteArray[189].callStatic(MediaType.class, (Object)"application/json")), RequestBody.class);
        Object builder = callSiteArray[190].callConstructor(Request.Builder.class);
        String docId = ShortTypeHandling.castToString((Object)callSiteArray[191].call((Object)document, (Object)"_id"));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object3 = callSiteArray[192].callStatic(CouchDbClient.class, (Object)docId);
            docId = ShortTypeHandling.castToString((Object)object3);
        } else {
            Object object4 = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object4);
        }
        builder = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[193].call(callSiteArray[194].call(builder, (Object)new GStringImpl(new Object[]{callSiteArray[195].callCurrent((GroovyObject)this), callSiteArray[196].call((Object)db), docId}, new String[]{"", "/", "/", ""})), (Object)body)) : (object = callSiteArray[197].call(callSiteArray[198].call(builder, (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[199].call((Object)db), docId}, new String[]{"", "/", "/", ""})), (Object)body));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object5;
            builder = object5 = callSiteArray[200].call(builder, (Object)"Authorization", callSiteArray[201].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[202].call(builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[203].call(callSiteArray[204].call((Object)this.client, (Object)request)), Response.class);
        Map result = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[205].callCurrent((GroovyObject)this, callSiteArray[206].call(callSiteArray[207].call((Object)response))), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[208].callGetProperty((Object)result))) {
            callSiteArray[209].call((Object)log, (Object)"error {}", (Object)result);
            throw (Throwable)callSiteArray[210].callConstructor(IllegalStateException.class, (Object)"error updating document");
        }
        Map updatedDocument = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[211].call(callSiteArray[212].call((Object)this.moshi, Map.class), (Object)documentAsJson), Map.class);
        Object object6 = callSiteArray[213].callGetProperty((Object)result);
        callSiteArray[214].call((Object)updatedDocument, (Object)"_rev", object6);
        return updatedDocument;
    }

    public List<Map> updateBulk(String db, List<Map> documents) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual(documents, null)) {
            throw (Throwable)callSiteArray[215].callConstructor(IllegalArgumentException.class, (Object)"documents may not be null");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[216].callGetProperty(documents))) {
            throw (Throwable)callSiteArray[217].callConstructor(IllegalArgumentException.class, (Object)"documents is empty");
        }
        public final class _updateBulk_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateBulk_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _updateBulk_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object document) {
                CallSite[] callSiteArray = _updateBulk_closure5.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(document, (Object)"_id"))) {
                    return callSiteArray[1].callCurrent((GroovyObject)this, document);
                }
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(document))) {
                    return callSiteArray[3].callCurrent((GroovyObject)this, document);
                }
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateBulk_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "beforeUpdate";
                stringArray[2] = "dateCreated";
                stringArray[3] = "beforeCreate";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _updateBulk_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateBulk_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateBulk_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[218].call(documents, (Object)new _updateBulk_closure5(this, this));
        Map updateDoc = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"docs", documents});
        String documentAsJson = ShortTypeHandling.castToString((Object)callSiteArray[219].call(callSiteArray[220].call((Object)this.moshi, Map.class), (Object)updateDoc));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[221].call(RequestBody.class, (Object)documentAsJson, callSiteArray[222].callStatic(MediaType.class, (Object)"application/json")), RequestBody.class);
        Request.Builder builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[223].callConstructor(Request.Builder.class), Request.Builder.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[224].call(callSiteArray[225].call((Object)builder, (Object)new GStringImpl(new Object[]{callSiteArray[226].callCurrent((GroovyObject)this), callSiteArray[227].call((Object)db)}, new String[]{"", "/", "/_bulk_docs"})), (Object)body);
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[228].call(callSiteArray[229].call((Object)builder, (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[230].call((Object)db)}, new String[]{"", "/", "/_bulk_docs"})), (Object)body);
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[231].call((Object)builder, (Object)"Authorization", callSiteArray[232].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[233].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[234].call(callSiteArray[235].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[236].callGetProperty((Object)response))) {
            callSiteArray[237].call((Object)log, (Object)"error {}", callSiteArray[238].call((Object)response));
            throw (Throwable)callSiteArray[239].callConstructor(IllegalStateException.class, (Object)"bulk update failed");
        }
        List result = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[240].callCurrent((GroovyObject)this, callSiteArray[241].call(callSiteArray[242].call((Object)response))), List.class);
        public final class _updateBulk_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateBulk_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _updateBulk_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object updated, Object original) {
                CallSite[] callSiteArray = _updateBulk_closure6.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(updated))) {
                    Object object = callSiteArray[1].callGetProperty(updated);
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)original, (String)"_id");
                    Object object2 = callSiteArray[2].callGetProperty(updated);
                    ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)original, (String)"_rev");
                    return original;
                }
                callSiteArray[3].call(ScriptBytecodeAdapter.getField(_updateBulk_closure6.class, CouchDbClient.class, (String)"log"), (Object)"error {}", updated);
                return null;
            }

            @Generated
            public Object call(Object updated, Object original) {
                CallSite[] callSiteArray = _updateBulk_closure6.$getCallSiteArray();
                return callSiteArray[4].callCurrent((GroovyObject)this, updated, original);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateBulk_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "ok";
                stringArray[1] = "id";
                stringArray[2] = "rev";
                stringArray[3] = "error";
                stringArray[4] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _updateBulk_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateBulk_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateBulk_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[243].call(callSiteArray[244].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{result, documents})), (Object)new _updateBulk_closure6(this, this));
        return result;
    }

    public boolean containsDb(String db) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[245].call(callSiteArray[246].call(callSiteArray[247].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[248].callCurrent((GroovyObject)this), callSiteArray[249].call((Object)db)}, new String[]{"", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[250].call(callSiteArray[251].call(callSiteArray[252].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[253].call((Object)db)}, new String[]{"", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[254].call((Object)builder, (Object)"Authorization", callSiteArray[255].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[256].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[257].call(callSiteArray[258].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[259].callGetProperty((Object)response))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[260].call((Object)response), (Object)404)) {
                return false;
            }
            callSiteArray[261].call((Object)log, (Object)"error {}", callSiteArray[262].call((Object)response));
            throw (Throwable)callSiteArray[263].callConstructor(IllegalStateException.class, (Object)"could not check for database existence");
        }
        return true;
    }

    public Object createDb(String db) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[264].call(callSiteArray[265].call(callSiteArray[266].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[267].callCurrent((GroovyObject)this), callSiteArray[268].call((Object)db)}, new String[]{"", "/", ""})), callSiteArray[269].call(RequestBody.class, (Object)"", callSiteArray[270].callStatic(MediaType.class, (Object)"application/json")));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[271].call(callSiteArray[272].call(callSiteArray[273].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[274].call((Object)db)}, new String[]{"", "/", ""})), callSiteArray[275].call(RequestBody.class, (Object)"", callSiteArray[276].callStatic(MediaType.class, (Object)"application/json")));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[277].call((Object)builder, (Object)"Authorization", callSiteArray[278].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[279].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[280].call(callSiteArray[281].call((Object)this.client, (Object)request)), Response.class);
        Map result = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[282].callCurrent((GroovyObject)this, callSiteArray[283].call(callSiteArray[284].call((Object)response))), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[285].callGetProperty((Object)result))) {
            callSiteArray[286].call((Object)log, (Object)"error {}", (Object)result);
            throw (Throwable)callSiteArray[287].callConstructor(IllegalStateException.class, (Object)"error creating database");
        }
        return result;
    }

    public Object deleteDb(String db) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[288].call(callSiteArray[289].call(callSiteArray[290].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[291].callCurrent((GroovyObject)this), callSiteArray[292].call((Object)db)}, new String[]{"", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[293].call(callSiteArray[294].call(callSiteArray[295].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[296].call((Object)db)}, new String[]{"", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[297].call((Object)builder, (Object)"Authorization", callSiteArray[298].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[299].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[300].call(callSiteArray[301].call((Object)this.client, (Object)request)), Response.class);
        Map result = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[302].callCurrent((GroovyObject)this, callSiteArray[303].call(callSiteArray[304].call((Object)response))), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[305].callGetProperty((Object)result))) {
            callSiteArray[306].call((Object)log, (Object)"error {}", (Object)result);
            throw (Throwable)callSiteArray[307].callConstructor(IllegalStateException.class, (Object)"error deleting database");
        }
        return result;
    }

    public Map createFindAllDocsView(String db) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        String findAll = "function(doc) { emit(null, doc._id) }";
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[308].callCurrent((GroovyObject)this, (Object)db, (Object)"all", (Object)findAll, null), Map.class);
    }

    public Map createFindByPropertyView(String db, String propertyName) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        String findByProperty = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{propertyName, propertyName}, new String[]{"function(doc) { if (doc['", "']) { emit(doc['", "'], doc._id) } }"}));
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[309].callCurrent((GroovyObject)this, (Object)db, (Object)new GStringImpl(new Object[]{propertyName}, new String[]{"by_", ""}), (Object)findByProperty, null), Map.class);
    }

    public Map createView(String db, String viewName, String mapFunction, String reduceFunction) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Map view = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)mapFunction)) {
            String string = mapFunction;
            callSiteArray[310].call((Object)view, (Object)"map", (Object)string);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)reduceFunction)) {
            String string = reduceFunction;
            callSiteArray[311].call((Object)view, (Object)"reduce", (Object)string);
        }
        String designDocId = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[312].call((Object)db)}, new String[]{"_design/", ""}));
        Map newDesignDoc = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"_id", designDocId, "language", "javascript", "views", ScriptBytecodeAdapter.createMap((Object[])new Object[]{viewName, view})});
        int designDocExists = 0;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[313].callCurrent((GroovyObject)this, (Object)db, (Object)designDocId);
            designDocExists = DefaultTypeTransformation.booleanUnbox((Object)object) ? 1 : 0;
        } else {
            boolean bl = this.contains(db, designDocId);
            designDocExists = bl ? 1 : 0;
        }
        if (designDocExists != 0) {
            Map currentDesignDoc = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[314].callCurrent((GroovyObject)this, (Object)db, (Object)designDocId);
                currentDesignDoc = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
            } else {
                Object r = this.get(db, designDocId);
                currentDesignDoc = (Map)ScriptBytecodeAdapter.castToType(r, Map.class);
            }
            Map mergedDesignDoc = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[315].callStatic(CouchDbClient.class, (Object)currentDesignDoc, (Object)newDesignDoc), Map.class);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)mergedDesignDoc, (Object)currentDesignDoc)) {
                callSiteArray[316].callCurrent((GroovyObject)this, (Object)db, (Object)mergedDesignDoc);
            }
            return currentDesignDoc;
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[317].callCurrent((GroovyObject)this, (Object)db, (Object)newDesignDoc), Map.class);
    }

    public boolean contains(String db, String docId) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[318].callStatic(CouchDbClient.class, (Object)docId);
            docId = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
        }
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[319].call(callSiteArray[320].call(callSiteArray[321].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[322].callCurrent((GroovyObject)this), callSiteArray[323].call((Object)db), docId}, new String[]{"", "/", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[324].call(callSiteArray[325].call(callSiteArray[326].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[327].call((Object)db), docId}, new String[]{"", "/", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[328].call((Object)builder, (Object)"Authorization", callSiteArray[329].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[330].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[331].call(callSiteArray[332].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[333].callGetProperty((Object)response))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[334].call((Object)response), (Object)404)) {
                return false;
            }
            callSiteArray[335].call((Object)log, (Object)"error {}", callSiteArray[336].call((Object)response));
            throw (Throwable)callSiteArray[337].callConstructor(IllegalStateException.class, (Object)"could not check for doc existence");
        }
        return true;
    }

    public <R> R get(String db, String docId) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[338].callStatic(CouchDbClient.class, (Object)docId);
            docId = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
        }
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[339].call(callSiteArray[340].call(callSiteArray[341].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[342].callCurrent((GroovyObject)this), callSiteArray[343].call((Object)db), docId}, new String[]{"", "/", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[344].call(callSiteArray[345].call(callSiteArray[346].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[347].call((Object)db), docId}, new String[]{"", "/", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[348].call((Object)builder, (Object)"Authorization", callSiteArray[349].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[350].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[351].call(callSiteArray[352].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[353].callGetProperty((Object)response))) {
            callSiteArray[354].call((Object)log, (Object)"error getting document({}): {}/{}", (Object)docId, callSiteArray[355].call((Object)response), callSiteArray[356].call((Object)response));
            throw (Throwable)callSiteArray[357].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{docId}, new String[]{"could not get doc with id '", "'"}));
        }
        Object doc = callSiteArray[358].callCurrent((GroovyObject)this, callSiteArray[359].call(callSiteArray[360].call((Object)response)));
        return (R)doc;
    }

    public Map delete(String db, String docId, String rev) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[361].callStatic(CouchDbClient.class, (Object)docId);
            docId = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
        }
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[362].call(callSiteArray[363].call(callSiteArray[364].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[365].callCurrent((GroovyObject)this), callSiteArray[366].call((Object)db), docId, rev}, new String[]{"", "/", "/", "?rev=", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[367].call(callSiteArray[368].call(callSiteArray[369].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[370].call((Object)db), docId, rev}, new String[]{"", "/", "/", "?rev=", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[371].call((Object)builder, (Object)"Authorization", callSiteArray[372].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[373].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[374].call(callSiteArray[375].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[376].callGetProperty((Object)response))) {
            callSiteArray[377].call((Object)log, ArrayUtil.createArray((Object)"error deleting doc{ _id:{}, _rev:{} }: {}/{}", (Object)docId, (Object)rev, (Object)callSiteArray[378].call((Object)response), (Object)callSiteArray[379].call((Object)response)));
            throw (Throwable)callSiteArray[380].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{docId, rev}, new String[]{"could not delete doc with id/rev '", "'/'", "'"}));
        }
        Map result = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[381].callCurrent((GroovyObject)this, callSiteArray[382].call(callSiteArray[383].call((Object)response))), Map.class);
        return result;
    }

    public static Map merge(Map currentDoc, Map changedDoc) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Object mergedDoc = callSiteArray[384].call((Object)currentDoc, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        Object object = callSiteArray[386].callGetProperty((Object)currentDoc);
        Object object2 = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object object3 = callSiteArray[387].callGetProperty((Object)changedDoc);
        Object object4 = callSiteArray[385].call(object2, DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)mergedDoc, (String)"views");
        return (Map)ScriptBytecodeAdapter.castToType((Object)mergedDoc, Map.class);
    }

    public <R> R consume(InputStream stream) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Object result = callSiteArray[388].call(callSiteArray[389].call((Object)this.moshi, Object.class), callSiteArray[390].call(Okio.class, callSiteArray[391].call(Okio.class, (Object)stream)));
        callSiteArray[392].call(Util.class, (Object)stream);
        return (R)result;
    }

    public static Object sanitizeDocId(String docId) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[393].call((Object)docId, (Object)"_"))) {
            Object object = callSiteArray[394].call(URLEncoder.class, (Object)docId, callSiteArray[395].call(callSiteArray[396].callGetProperty(StandardCharsets.class)));
            docId = ShortTypeHandling.castToString((Object)object);
        }
        return docId;
    }

    public void beforeCreate(Map document) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[397].callGetProperty((Object)document))) {
            Object object = callSiteArray[398].call(callSiteArray[399].call(LocalDate.class));
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)document, (String)"dateCreated");
        }
    }

    public void beforeUpdate(Map document) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Object object = callSiteArray[400].call(callSiteArray[401].call(LocalDate.class));
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)document, (String)"dateUpdated");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CouchDbClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public <R> R query(String db, String viewName, String key) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.query(db, viewName, key, true);
        }
        return this.query(db, viewName, key, true);
    }

    @Generated
    public <R> R query(String db, String viewName, Collection<String> keys) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        return this.query(db, viewName, keys, true);
    }

    @Generated
    public Object getAllDocs(String db, boolean includeDocs) {
        Reference includeDocs2 = new Reference((Object)includeDocs);
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getAllDocs(db, DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get()), false);
        }
        return this.getAllDocs(db, DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get()), false);
    }

    @Generated
    public Object getAllDocs(String db) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getAllDocs(db, true, false);
        }
        return this.getAllDocs(db, true, false);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = CouchDbClient.$getCallSiteArray()[402].call(LoggerFactory.class, CouchDbClient.$getCallSiteArray()[403].callStatic(CouchDbClient.class));
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public OkHttpClient getClient() {
        return this.client;
    }

    @Generated
    public void setClient(OkHttpClient okHttpClient) {
        this.client = okHttpClient;
    }

    @Generated
    public Moshi getMoshi() {
        return this.moshi;
    }

    @Generated
    public void setMoshi(Moshi moshi) {
        this.moshi = moshi;
    }

    @Generated
    public boolean getTlsEnabled() {
        return this.tlsEnabled;
    }

    @Generated
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Generated
    public String getCouchdbHost() {
        return this.couchdbHost;
    }

    @Generated
    public int getCouchdbPort() {
        return this.couchdbPort;
    }

    @Generated
    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    @Generated
    public String getCouchdbUsername() {
        return this.couchdbUsername;
    }

    @Generated
    public void setCouchdbUsername(String string) {
        this.couchdbUsername = string;
    }

    @Generated
    public String getCouchdbPassword() {
        return this.couchdbPassword;
    }

    @Generated
    public void setCouchdbPassword(String string) {
        this.couchdbPassword = string;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "build";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "updateBaseUrl";
        stringArray[4] = "updateBaseUrl";
        stringArray[5] = "updateBaseUrl";
        stringArray[6] = "updateBaseUrl";
        stringArray[7] = "get";
        stringArray[8] = "url";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "getBaseUrl";
        stringArray[11] = "get";
        stringArray[12] = "url";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "build";
        stringArray[15] = "execute";
        stringArray[16] = "newCall";
        stringArray[17] = "successful";
        stringArray[18] = "code";
        stringArray[19] = "close";
        stringArray[20] = "body";
        stringArray[21] = "error";
        stringArray[22] = "message";
        stringArray[23] = "close";
        stringArray[24] = "body";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "info";
        stringArray[27] = "string";
        stringArray[28] = "body";
        stringArray[29] = "toJson";
        stringArray[30] = "adapter";
        stringArray[31] = "get";
        stringArray[32] = "url";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "plus";
        stringArray[35] = "plus";
        stringArray[36] = "plus";
        stringArray[37] = "plus";
        stringArray[38] = "plus";
        stringArray[39] = "getBaseUrl";
        stringArray[40] = "toLowerCase";
        stringArray[41] = "capitalize";
        stringArray[42] = "get";
        stringArray[43] = "url";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "plus";
        stringArray[46] = "plus";
        stringArray[47] = "plus";
        stringArray[48] = "plus";
        stringArray[49] = "plus";
        stringArray[50] = "toLowerCase";
        stringArray[51] = "capitalize";
        stringArray[52] = "header";
        stringArray[53] = "basic";
        stringArray[54] = "build";
        stringArray[55] = "execute";
        stringArray[56] = "newCall";
        stringArray[57] = "successful";
        stringArray[58] = "error";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "string";
        stringArray[61] = "body";
        stringArray[62] = "consume";
        stringArray[63] = "byteStream";
        stringArray[64] = "body";
        stringArray[65] = "collect";
        stringArray[66] = "rows";
        stringArray[67] = "toJson";
        stringArray[68] = "adapter";
        stringArray[69] = "get";
        stringArray[70] = "url";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "plus";
        stringArray[73] = "plus";
        stringArray[74] = "plus";
        stringArray[75] = "plus";
        stringArray[76] = "plus";
        stringArray[77] = "getBaseUrl";
        stringArray[78] = "toLowerCase";
        stringArray[79] = "capitalize";
        stringArray[80] = "get";
        stringArray[81] = "url";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "plus";
        stringArray[84] = "plus";
        stringArray[85] = "plus";
        stringArray[86] = "plus";
        stringArray[87] = "plus";
        stringArray[88] = "toLowerCase";
        stringArray[89] = "capitalize";
        stringArray[90] = "header";
        stringArray[91] = "basic";
        stringArray[92] = "build";
        stringArray[93] = "execute";
        stringArray[94] = "newCall";
        stringArray[95] = "successful";
        stringArray[96] = "error";
        stringArray[97] = "<$constructor$>";
        stringArray[98] = "string";
        stringArray[99] = "body";
        stringArray[100] = "consume";
        stringArray[101] = "byteStream";
        stringArray[102] = "body";
        stringArray[103] = "collect";
        stringArray[104] = "rows";
        stringArray[105] = "get";
        stringArray[106] = "url";
        stringArray[107] = "<$constructor$>";
        stringArray[108] = "plus";
        stringArray[109] = "plus";
        stringArray[110] = "getBaseUrl";
        stringArray[111] = "toLowerCase";
        stringArray[112] = "get";
        stringArray[113] = "url";
        stringArray[114] = "<$constructor$>";
        stringArray[115] = "plus";
        stringArray[116] = "plus";
        stringArray[117] = "toLowerCase";
        stringArray[118] = "header";
        stringArray[119] = "basic";
        stringArray[120] = "build";
        stringArray[121] = "execute";
        stringArray[122] = "newCall";
        stringArray[123] = "successful";
        stringArray[124] = "error";
        stringArray[125] = "code";
        stringArray[126] = "message";
        stringArray[127] = "<$constructor$>";
        stringArray[128] = "consume";
        stringArray[129] = "byteStream";
        stringArray[130] = "body";
        stringArray[131] = "collect";
        stringArray[132] = "rows";
        stringArray[133] = "grep";
        stringArray[134] = "<$constructor$>";
        stringArray[135] = "getAt";
        stringArray[136] = "error";
        stringArray[137] = "getAt";
        stringArray[138] = "getAt";
        stringArray[139] = "<$constructor$>";
        stringArray[140] = "beforeCreate";
        stringArray[141] = "toJson";
        stringArray[142] = "adapter";
        stringArray[143] = "create";
        stringArray[144] = "parse";
        stringArray[145] = "<$constructor$>";
        stringArray[146] = "getAt";
        stringArray[147] = "getAt";
        stringArray[148] = "sanitizeDocId";
        stringArray[149] = "put";
        stringArray[150] = "url";
        stringArray[151] = "getBaseUrl";
        stringArray[152] = "toLowerCase";
        stringArray[153] = "post";
        stringArray[154] = "url";
        stringArray[155] = "getBaseUrl";
        stringArray[156] = "toLowerCase";
        stringArray[157] = "getAt";
        stringArray[158] = "getAt";
        stringArray[159] = "put";
        stringArray[160] = "url";
        stringArray[161] = "toLowerCase";
        stringArray[162] = "post";
        stringArray[163] = "url";
        stringArray[164] = "toLowerCase";
        stringArray[165] = "header";
        stringArray[166] = "basic";
        stringArray[167] = "build";
        stringArray[168] = "execute";
        stringArray[169] = "newCall";
        stringArray[170] = "consume";
        stringArray[171] = "byteStream";
        stringArray[172] = "body";
        stringArray[173] = "ok";
        stringArray[174] = "error";
        stringArray[175] = "<$constructor$>";
        stringArray[176] = "fromJson";
        stringArray[177] = "adapter";
        stringArray[178] = "id";
        stringArray[179] = "putAt";
        stringArray[180] = "rev";
        stringArray[181] = "putAt";
        stringArray[182] = "<$constructor$>";
        stringArray[183] = "getAt";
        stringArray[184] = "<$constructor$>";
        stringArray[185] = "beforeUpdate";
        stringArray[186] = "toJson";
        stringArray[187] = "adapter";
        stringArray[188] = "create";
        stringArray[189] = "parse";
        stringArray[190] = "<$constructor$>";
        stringArray[191] = "getAt";
        stringArray[192] = "sanitizeDocId";
        stringArray[193] = "put";
        stringArray[194] = "url";
        stringArray[195] = "getBaseUrl";
        stringArray[196] = "toLowerCase";
        stringArray[197] = "put";
        stringArray[198] = "url";
        stringArray[199] = "toLowerCase";
        stringArray[200] = "header";
        stringArray[201] = "basic";
        stringArray[202] = "build";
        stringArray[203] = "execute";
        stringArray[204] = "newCall";
        stringArray[205] = "consume";
        stringArray[206] = "byteStream";
        stringArray[207] = "body";
        stringArray[208] = "ok";
        stringArray[209] = "error";
        stringArray[210] = "<$constructor$>";
        stringArray[211] = "fromJson";
        stringArray[212] = "adapter";
        stringArray[213] = "rev";
        stringArray[214] = "putAt";
        stringArray[215] = "<$constructor$>";
        stringArray[216] = "empty";
        stringArray[217] = "<$constructor$>";
        stringArray[218] = "each";
        stringArray[219] = "toJson";
        stringArray[220] = "adapter";
        stringArray[221] = "create";
        stringArray[222] = "parse";
        stringArray[223] = "<$constructor$>";
        stringArray[224] = "post";
        stringArray[225] = "url";
        stringArray[226] = "getBaseUrl";
        stringArray[227] = "toLowerCase";
        stringArray[228] = "post";
        stringArray[229] = "url";
        stringArray[230] = "toLowerCase";
        stringArray[231] = "header";
        stringArray[232] = "basic";
        stringArray[233] = "build";
        stringArray[234] = "execute";
        stringArray[235] = "newCall";
        stringArray[236] = "successful";
        stringArray[237] = "error";
        stringArray[238] = "message";
        stringArray[239] = "<$constructor$>";
        stringArray[240] = "consume";
        stringArray[241] = "byteStream";
        stringArray[242] = "body";
        stringArray[243] = "each";
        stringArray[244] = "transpose";
        stringArray[245] = "head";
        stringArray[246] = "url";
        stringArray[247] = "<$constructor$>";
        stringArray[248] = "getBaseUrl";
        stringArray[249] = "toLowerCase";
        stringArray[250] = "head";
        stringArray[251] = "url";
        stringArray[252] = "<$constructor$>";
        stringArray[253] = "toLowerCase";
        stringArray[254] = "header";
        stringArray[255] = "basic";
        stringArray[256] = "build";
        stringArray[257] = "execute";
        stringArray[258] = "newCall";
        stringArray[259] = "successful";
        stringArray[260] = "code";
        stringArray[261] = "error";
        stringArray[262] = "message";
        stringArray[263] = "<$constructor$>";
        stringArray[264] = "put";
        stringArray[265] = "url";
        stringArray[266] = "<$constructor$>";
        stringArray[267] = "getBaseUrl";
        stringArray[268] = "toLowerCase";
        stringArray[269] = "create";
        stringArray[270] = "parse";
        stringArray[271] = "put";
        stringArray[272] = "url";
        stringArray[273] = "<$constructor$>";
        stringArray[274] = "toLowerCase";
        stringArray[275] = "create";
        stringArray[276] = "parse";
        stringArray[277] = "header";
        stringArray[278] = "basic";
        stringArray[279] = "build";
        stringArray[280] = "execute";
        stringArray[281] = "newCall";
        stringArray[282] = "consume";
        stringArray[283] = "byteStream";
        stringArray[284] = "body";
        stringArray[285] = "ok";
        stringArray[286] = "error";
        stringArray[287] = "<$constructor$>";
        stringArray[288] = "delete";
        stringArray[289] = "url";
        stringArray[290] = "<$constructor$>";
        stringArray[291] = "getBaseUrl";
        stringArray[292] = "toLowerCase";
        stringArray[293] = "delete";
        stringArray[294] = "url";
        stringArray[295] = "<$constructor$>";
        stringArray[296] = "toLowerCase";
        stringArray[297] = "header";
        stringArray[298] = "basic";
        stringArray[299] = "build";
        stringArray[300] = "execute";
        stringArray[301] = "newCall";
        stringArray[302] = "consume";
        stringArray[303] = "byteStream";
        stringArray[304] = "body";
        stringArray[305] = "ok";
        stringArray[306] = "error";
        stringArray[307] = "<$constructor$>";
        stringArray[308] = "createView";
        stringArray[309] = "createView";
        stringArray[310] = "putAt";
        stringArray[311] = "putAt";
        stringArray[312] = "capitalize";
        stringArray[313] = "contains";
        stringArray[314] = "get";
        stringArray[315] = "merge";
        stringArray[316] = "update";
        stringArray[317] = "update";
        stringArray[318] = "sanitizeDocId";
        stringArray[319] = "head";
        stringArray[320] = "url";
        stringArray[321] = "<$constructor$>";
        stringArray[322] = "getBaseUrl";
        stringArray[323] = "toLowerCase";
        stringArray[324] = "head";
        stringArray[325] = "url";
        stringArray[326] = "<$constructor$>";
        stringArray[327] = "toLowerCase";
        stringArray[328] = "header";
        stringArray[329] = "basic";
        stringArray[330] = "build";
        stringArray[331] = "execute";
        stringArray[332] = "newCall";
        stringArray[333] = "successful";
        stringArray[334] = "code";
        stringArray[335] = "error";
        stringArray[336] = "message";
        stringArray[337] = "<$constructor$>";
        stringArray[338] = "sanitizeDocId";
        stringArray[339] = "get";
        stringArray[340] = "url";
        stringArray[341] = "<$constructor$>";
        stringArray[342] = "getBaseUrl";
        stringArray[343] = "toLowerCase";
        stringArray[344] = "get";
        stringArray[345] = "url";
        stringArray[346] = "<$constructor$>";
        stringArray[347] = "toLowerCase";
        stringArray[348] = "header";
        stringArray[349] = "basic";
        stringArray[350] = "build";
        stringArray[351] = "execute";
        stringArray[352] = "newCall";
        stringArray[353] = "successful";
        stringArray[354] = "error";
        stringArray[355] = "code";
        stringArray[356] = "message";
        stringArray[357] = "<$constructor$>";
        stringArray[358] = "consume";
        stringArray[359] = "byteStream";
        stringArray[360] = "body";
        stringArray[361] = "sanitizeDocId";
        stringArray[362] = "delete";
        stringArray[363] = "url";
        stringArray[364] = "<$constructor$>";
        stringArray[365] = "getBaseUrl";
        stringArray[366] = "toLowerCase";
        stringArray[367] = "delete";
        stringArray[368] = "url";
        stringArray[369] = "<$constructor$>";
        stringArray[370] = "toLowerCase";
        stringArray[371] = "header";
        stringArray[372] = "basic";
        stringArray[373] = "build";
        stringArray[374] = "execute";
        stringArray[375] = "newCall";
        stringArray[376] = "successful";
        stringArray[377] = "error";
        stringArray[378] = "code";
        stringArray[379] = "message";
        stringArray[380] = "<$constructor$>";
        stringArray[381] = "consume";
        stringArray[382] = "byteStream";
        stringArray[383] = "body";
        stringArray[384] = "plus";
        stringArray[385] = "plus";
        stringArray[386] = "views";
        stringArray[387] = "views";
        stringArray[388] = "fromJson";
        stringArray[389] = "adapter";
        stringArray[390] = "buffer";
        stringArray[391] = "source";
        stringArray[392] = "closeQuietly";
        stringArray[393] = "startsWith";
        stringArray[394] = "encode";
        stringArray[395] = "toString";
        stringArray[396] = "UTF_8";
        stringArray[397] = "dateCreated";
        stringArray[398] = "toString";
        stringArray[399] = "now";
        stringArray[400] = "toString";
        stringArray[401] = "now";
        stringArray[402] = "getLogger";
        stringArray[403] = "getClass";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[404];
        CouchDbClient.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(CouchDbClient.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = CouchDbClient.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

