/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.couchdb;

import com.squareup.moshi.Moshi;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.ref.SoftReference;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.Okio;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDbClient
implements GroovyObject {
    private static final Logger log;
    private OkHttpClient client;
    private Moshi moshi;
    private boolean tlsEnabled;
    private String couchdbHost;
    private int couchdbPort;
    private String baseUrl;
    private String couchdbUsername;
    private String couchdbPassword;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public CouchDbClient() {
        int n;
        String string;
        boolean bl;
        MetaClass metaClass;
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callConstructor(OkHttpClient.class);
        this.client = (OkHttpClient)ScriptBytecodeAdapter.castToType((Object)object, OkHttpClient.class);
        Object object2 = callSiteArray[1].call(callSiteArray[2].callConstructor(Moshi.Builder.class));
        this.moshi = (Moshi)ScriptBytecodeAdapter.castToType((Object)object2, Moshi.class);
        this.tlsEnabled = bl = false;
        this.couchdbHost = string = "127.0.0.1";
        this.couchdbPort = n = 5984;
    }

    public void updateBaseUrl() {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        GStringImpl gStringImpl = new GStringImpl(new Object[]{this.tlsEnabled ? "https" : "http", this.couchdbHost, this.couchdbPort}, new String[]{"", "://", ":", ""});
        this.baseUrl = ShortTypeHandling.castToString((Object)gStringImpl);
    }

    public String getBaseUrl() {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)this.baseUrl, null)) {
                callSiteArray[3].callCurrent((GroovyObject)this);
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)this.baseUrl, null)) {
            this.updateBaseUrl();
        }
        return this.baseUrl;
    }

    public void setTlsEnabled(boolean tlsEnabled) {
        boolean bl;
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        this.tlsEnabled = bl = tlsEnabled;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[4].callCurrent((GroovyObject)this);
        } else {
            this.updateBaseUrl();
        }
    }

    public void setCouchdbHost(String couchdbHost) {
        String string;
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        this.couchdbHost = string = couchdbHost;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[5].callCurrent((GroovyObject)this);
        } else {
            this.updateBaseUrl();
        }
    }

    public void setCouchdbPort(int couchdbPort) {
        int n;
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        this.couchdbPort = n = couchdbPort;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[6].callCurrent((GroovyObject)this);
        } else {
            this.updateBaseUrl();
        }
    }

    public boolean healthy() {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].callConstructor(Request.Builder.class), callSiteArray[10].callCurrent((GroovyObject)this)));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].callConstructor(Request.Builder.class), (Object)this.getBaseUrl()));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].call(callSiteArray[16].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callGetProperty((Object)response))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[18].call((Object)response), (Object)404)) {
                callSiteArray[19].call(callSiteArray[20].call((Object)response));
                return false;
            }
            callSiteArray[21].call((Object)log, (Object)"error {}", callSiteArray[22].call((Object)response));
            callSiteArray[23].call(callSiteArray[24].call((Object)response));
            throw (Throwable)callSiteArray[25].callConstructor(IllegalStateException.class, (Object)"could not check for database existence");
        }
        callSiteArray[26].call((Object)log, callSiteArray[27].call(callSiteArray[28].call((Object)response)));
        return true;
    }

    public <R> R query(String db, String viewName, String key, boolean includeDocs) {
        Reference includeDocs2 = new Reference((Object)includeDocs);
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        String encodedKey = ShortTypeHandling.castToString((Object)callSiteArray[29].call(callSiteArray[30].call((Object)this.moshi, String.class), (Object)key));
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[31].call(callSiteArray[32].call(callSiteArray[33].callConstructor(Request.Builder.class), callSiteArray[34].call(callSiteArray[35].call(callSiteArray[36].call(callSiteArray[37].call(callSiteArray[38].call(callSiteArray[39].callCurrent((GroovyObject)this), (Object)new GStringImpl(new Object[]{callSiteArray[40].call((Object)db)}, new String[]{"/", ""})), (Object)new GStringImpl(new Object[]{callSiteArray[41].call((Object)db)}, new String[]{"/_design/", ""})), (Object)new GStringImpl(new Object[]{viewName}, new String[]{"/_view/", ""})), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""})), (Object)new GStringImpl(new Object[]{encodedKey}, new String[]{"&key=", ""}))));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].callConstructor(Request.Builder.class), callSiteArray[45].call(callSiteArray[46].call(callSiteArray[47].call(callSiteArray[48].call(callSiteArray[49].call((Object)this.getBaseUrl(), (Object)new GStringImpl(new Object[]{callSiteArray[50].call((Object)db)}, new String[]{"/", ""})), (Object)new GStringImpl(new Object[]{callSiteArray[51].call((Object)db)}, new String[]{"/_design/", ""})), (Object)new GStringImpl(new Object[]{viewName}, new String[]{"/_view/", ""})), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""})), (Object)new GStringImpl(new Object[]{encodedKey}, new String[]{"&key=", ""}))));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[52].call((Object)builder, (Object)"Authorization", callSiteArray[53].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].call(callSiteArray[56].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[57].callGetProperty((Object)response))) {
            callSiteArray[58].call((Object)log, (Object)"request failed: {}", (Object)request);
            throw (Throwable)callSiteArray[59].callConstructor(IOException.class, callSiteArray[60].call(callSiteArray[61].call((Object)response)));
        }
        Object result = callSiteArray[62].callCurrent((GroovyObject)this, callSiteArray[63].call(callSiteArray[64].call((Object)response)));
        public final class _query_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includeDocs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _query_closure1(Object _outerInstance, Object _thisObject, Reference includeDocs) {
                Reference reference;
                CallSite[] callSiteArray = _query_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.includeDocs = reference = includeDocs;
            }

            public Object doCall(Object row) {
                CallSite[] callSiteArray = _query_closure1.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get()) ? callSiteArray[0].callGetProperty(row) : row;
            }

            @Generated
            public boolean getIncludeDocs() {
                CallSite[] callSiteArray = _query_closure1.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _query_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doc";
                return new CallSiteArray(_query_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _query_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (R)callSiteArray[65].call(callSiteArray[66].callGetProperty(result), (Object)new _query_closure1(this, this, includeDocs2));
    }

    public <R> R query(String db, String viewName, Collection<String> keys, boolean includeDocs) {
        Reference includeDocs2 = new Reference((Object)includeDocs);
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        String encodedKeys = ShortTypeHandling.castToString((Object)callSiteArray[67].call(callSiteArray[68].call((Object)this.moshi, Collection.class), keys));
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[69].call(callSiteArray[70].call(callSiteArray[71].callConstructor(Request.Builder.class), callSiteArray[72].call(callSiteArray[73].call(callSiteArray[74].call(callSiteArray[75].call(callSiteArray[76].call(callSiteArray[77].callCurrent((GroovyObject)this), (Object)new GStringImpl(new Object[]{callSiteArray[78].call((Object)db)}, new String[]{"/", ""})), (Object)new GStringImpl(new Object[]{callSiteArray[79].call((Object)db)}, new String[]{"/_design/", ""})), (Object)new GStringImpl(new Object[]{viewName}, new String[]{"/_view/", ""})), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""})), (Object)new GStringImpl(new Object[]{encodedKeys}, new String[]{"&keys=", ""}))));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[80].call(callSiteArray[81].call(callSiteArray[82].callConstructor(Request.Builder.class), callSiteArray[83].call(callSiteArray[84].call(callSiteArray[85].call(callSiteArray[86].call(callSiteArray[87].call((Object)this.getBaseUrl(), (Object)new GStringImpl(new Object[]{callSiteArray[88].call((Object)db)}, new String[]{"/", ""})), (Object)new GStringImpl(new Object[]{callSiteArray[89].call((Object)db)}, new String[]{"/_design/", ""})), (Object)new GStringImpl(new Object[]{viewName}, new String[]{"/_view/", ""})), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""})), (Object)new GStringImpl(new Object[]{encodedKeys}, new String[]{"&keys=", ""}))));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[90].call((Object)builder, (Object)"Authorization", callSiteArray[91].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[92].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].call(callSiteArray[94].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[95].callGetProperty((Object)response))) {
            callSiteArray[96].call((Object)log, (Object)"request failed: {}", (Object)request);
            throw (Throwable)callSiteArray[97].callConstructor(IOException.class, callSiteArray[98].call(callSiteArray[99].call((Object)response)));
        }
        Object result = callSiteArray[100].callCurrent((GroovyObject)this, callSiteArray[101].call(callSiteArray[102].call((Object)response)));
        public final class _query_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includeDocs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _query_closure2(Object _outerInstance, Object _thisObject, Reference includeDocs) {
                Reference reference;
                CallSite[] callSiteArray = _query_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.includeDocs = reference = includeDocs;
            }

            public Object doCall(Object row) {
                CallSite[] callSiteArray = _query_closure2.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get()) ? callSiteArray[0].callGetProperty(row) : row;
            }

            @Generated
            public boolean getIncludeDocs() {
                CallSite[] callSiteArray = _query_closure2.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _query_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doc";
                return new CallSiteArray(_query_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _query_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (R)callSiteArray[103].call(callSiteArray[104].callGetProperty(result), (Object)new _query_closure2(this, this, includeDocs2));
    }

    public Object getAllDocs(String db, boolean includeDocs, boolean includeDesignDoc) {
        Object object;
        Reference includeDocs2 = new Reference((Object)includeDocs);
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].callConstructor(Request.Builder.class), callSiteArray[108].call(callSiteArray[109].call((Object)new GStringImpl(new Object[]{callSiteArray[110].callCurrent((GroovyObject)this), callSiteArray[111].call((Object)db)}, new String[]{"", "/", ""}), (Object)"/_all_docs"), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""}))));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object2, Request.Builder.class);
        } else {
            Object object3 = callSiteArray[112].call(callSiteArray[113].call(callSiteArray[114].callConstructor(Request.Builder.class), callSiteArray[115].call(callSiteArray[116].call((Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[117].call((Object)db)}, new String[]{"", "/", ""}), (Object)"/_all_docs"), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""}))));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object3, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object4 = callSiteArray[118].call((Object)builder, (Object)"Authorization", callSiteArray[119].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object4, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[120].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[121].call(callSiteArray[122].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[123].callGetProperty((Object)response))) {
            callSiteArray[124].call((Object)log, (Object)"error getting all docs: {}/{}", callSiteArray[125].call((Object)response), callSiteArray[126].call((Object)response));
            throw (Throwable)callSiteArray[127].callConstructor(IllegalStateException.class, (Object)"could not get all docs with");
        }
        Object allDocs = callSiteArray[128].callCurrent((GroovyObject)this, callSiteArray[129].call(callSiteArray[130].call((Object)response)));
        public final class _getAllDocs_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includeDocs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getAllDocs_closure3(Object _outerInstance, Object _thisObject, Reference includeDocs) {
                Reference reference;
                CallSite[] callSiteArray = _getAllDocs_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.includeDocs = reference = includeDocs;
            }

            public Object doCall(Object row) {
                CallSite[] callSiteArray = _getAllDocs_closure3.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get()) ? callSiteArray[0].callGetProperty(row) : row;
            }

            @Generated
            public boolean getIncludeDocs() {
                CallSite[] callSiteArray = _getAllDocs_closure3.$getCallSiteArray();
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAllDocs_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doc";
                return new CallSiteArray(_getAllDocs_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getAllDocs_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        allDocs = object = callSiteArray[131].call(callSiteArray[132].callGetProperty(allDocs), (Object)new _getAllDocs_closure3(this, this, includeDocs2));
        if (!includeDesignDoc) {
            Object object5;
            public final class _getAllDocs_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _getAllDocs_closure4(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _getAllDocs_closure4.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getAllDocs_closure4.$getCallSiteArray();
                    if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                        return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callSafe(callSiteArray[1].callGetProperty(it), (Object)"_design/")) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callSafe(callSiteArray[3].callGetProperty(it), (Object)"_design/"));
                    }
                    return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].callSafe(callSiteArray[5].callGetProperty(it), (Object)"_design/")) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callSafe(callSiteArray[7].callGetProperty(it), (Object)"_design/"));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _getAllDocs_closure4.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAllDocs_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "startsWith";
                    stringArray[1] = "_id";
                    stringArray[2] = "startsWith";
                    stringArray[3] = "id";
                    stringArray[4] = "startsWith";
                    stringArray[5] = "_id";
                    stringArray[6] = "startsWith";
                    stringArray[7] = "id";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[8];
                    _getAllDocs_closure4.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getAllDocs_closure4.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getAllDocs_closure4.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            allDocs = object5 = callSiteArray[133].call(allDocs, (Object)new _getAllDocs_closure4(this, this));
        }
        return allDocs;
    }

    public Object create(String db, Map document) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)document, null)) {
            throw (Throwable)callSiteArray[134].callConstructor(IllegalArgumentException.class, (Object)"document may not be null");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[135].call((Object)document, (Object)"_rev"))) {
            callSiteArray[136].call((Object)log, (Object)"document must be new, but has id({}), rev({})", callSiteArray[137].call((Object)document, (Object)"_id"), callSiteArray[138].call((Object)document, (Object)"_rev"));
            throw (Throwable)callSiteArray[139].callConstructor(IllegalArgumentException.class, (Object)"document must be new");
        }
        callSiteArray[140].callCurrent((GroovyObject)this, (Object)document);
        String documentAsJson = ShortTypeHandling.castToString((Object)callSiteArray[141].call(callSiteArray[142].call((Object)this.moshi, Map.class), (Object)document));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[143].call(RequestBody.class, (Object)documentAsJson, callSiteArray[144].callStatic(MediaType.class, (Object)"application/json")), RequestBody.class);
        Request.Builder builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[145].callConstructor(Request.Builder.class), Request.Builder.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[146].call((Object)document, (Object)"_id"))) {
                String docId = ShortTypeHandling.castToString((Object)callSiteArray[147].call((Object)document, (Object)"_id"));
                Object object = CouchDbClient.sanitizeDocId(docId);
                docId = ShortTypeHandling.castToString((Object)object);
                Object object2 = callSiteArray[148].call(callSiteArray[149].call((Object)builder, (Object)new GStringImpl(new Object[]{callSiteArray[150].callCurrent((GroovyObject)this), callSiteArray[151].call((Object)db), docId}, new String[]{"", "/", "/", ""})), (Object)body);
                builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object2, Request.Builder.class);
            } else {
                Object object = callSiteArray[152].call(callSiteArray[153].call((Object)builder, (Object)new GStringImpl(new Object[]{callSiteArray[154].callCurrent((GroovyObject)this), callSiteArray[155].call((Object)db)}, new String[]{"", "/", ""})), (Object)body);
                builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[156].call((Object)document, (Object)"_id"))) {
            String docId = ShortTypeHandling.castToString((Object)callSiteArray[157].call((Object)document, (Object)"_id"));
            Object object = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
            Object object3 = callSiteArray[158].call(callSiteArray[159].call((Object)builder, (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[160].call((Object)db), docId}, new String[]{"", "/", "/", ""})), (Object)body);
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object3, Request.Builder.class);
        } else {
            Object object = callSiteArray[161].call(callSiteArray[162].call((Object)builder, (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[163].call((Object)db)}, new String[]{"", "/", ""})), (Object)body);
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[164].call((Object)builder, (Object)"Authorization", callSiteArray[165].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[166].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[167].call(callSiteArray[168].call((Object)this.client, (Object)request)), Response.class);
        Map result = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[169].callCurrent((GroovyObject)this, callSiteArray[170].call(callSiteArray[171].call((Object)response))), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[172].callGetProperty((Object)result))) {
            callSiteArray[173].call((Object)log, (Object)"error {}", (Object)result);
            throw (Throwable)callSiteArray[174].callConstructor(IllegalStateException.class, (Object)"error creating document");
        }
        Map createdDocument = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[175].call(callSiteArray[176].call((Object)this.moshi, Map.class), (Object)documentAsJson), Map.class);
        Object object = callSiteArray[177].callGetProperty((Object)result);
        callSiteArray[178].call((Object)createdDocument, (Object)"_id", object);
        Object object4 = callSiteArray[179].callGetProperty((Object)result);
        callSiteArray[180].call((Object)createdDocument, (Object)"_rev", object4);
        return createdDocument;
    }

    public Object update(String db, Map document) {
        Object object;
        Object object2;
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)document, null)) {
            throw (Throwable)callSiteArray[181].callConstructor(IllegalArgumentException.class, (Object)"document may not be null");
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[182].call((Object)document, (Object)"_id"))) {
            throw (Throwable)callSiteArray[183].callConstructor(IllegalArgumentException.class, (Object)"document id missing");
        }
        callSiteArray[184].callCurrent((GroovyObject)this, (Object)document);
        String documentAsJson = ShortTypeHandling.castToString((Object)callSiteArray[185].call(callSiteArray[186].call((Object)this.moshi, Map.class), (Object)document));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[187].call(RequestBody.class, (Object)documentAsJson, callSiteArray[188].callStatic(MediaType.class, (Object)"application/json")), RequestBody.class);
        Object builder = callSiteArray[189].callConstructor(Request.Builder.class);
        String docId = ShortTypeHandling.castToString((Object)callSiteArray[190].call((Object)document, (Object)"_id"));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object3 = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object3);
        } else {
            Object object4 = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object4);
        }
        builder = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[191].call(callSiteArray[192].call(builder, (Object)new GStringImpl(new Object[]{callSiteArray[193].callCurrent((GroovyObject)this), callSiteArray[194].call((Object)db), docId}, new String[]{"", "/", "/", ""})), (Object)body)) : (object = callSiteArray[195].call(callSiteArray[196].call(builder, (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[197].call((Object)db), docId}, new String[]{"", "/", "/", ""})), (Object)body));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object5;
            builder = object5 = callSiteArray[198].call(builder, (Object)"Authorization", callSiteArray[199].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[200].call(builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[201].call(callSiteArray[202].call((Object)this.client, (Object)request)), Response.class);
        Map result = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[203].callCurrent((GroovyObject)this, callSiteArray[204].call(callSiteArray[205].call((Object)response))), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[206].callGetProperty((Object)result))) {
            callSiteArray[207].call((Object)log, (Object)"error {}", (Object)result);
            throw (Throwable)callSiteArray[208].callConstructor(IllegalStateException.class, (Object)"error updating document");
        }
        Map updatedDocument = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[209].call(callSiteArray[210].call((Object)this.moshi, Map.class), (Object)documentAsJson), Map.class);
        Object object6 = callSiteArray[211].callGetProperty((Object)result);
        callSiteArray[212].call((Object)updatedDocument, (Object)"_rev", object6);
        return updatedDocument;
    }

    public List<Map> updateBulk(String db, List<Map> documents) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual(documents, null)) {
            throw (Throwable)callSiteArray[213].callConstructor(IllegalArgumentException.class, (Object)"documents may not be null");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[214].callGetProperty(documents))) {
            throw (Throwable)callSiteArray[215].callConstructor(IllegalArgumentException.class, (Object)"documents is empty");
        }
        public final class _updateBulk_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateBulk_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _updateBulk_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object document) {
                CallSite[] callSiteArray = _updateBulk_closure5.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(document, (Object)"_id"))) {
                    return callSiteArray[1].callCurrent((GroovyObject)this, document);
                }
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].callGetProperty(document))) {
                    return callSiteArray[3].callCurrent((GroovyObject)this, document);
                }
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateBulk_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "beforeUpdate";
                stringArray[2] = "dateCreated";
                stringArray[3] = "beforeCreate";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _updateBulk_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateBulk_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateBulk_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[216].call(documents, (Object)new _updateBulk_closure5(this, this));
        Map updateDoc = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"docs", documents});
        String documentAsJson = ShortTypeHandling.castToString((Object)callSiteArray[217].call(callSiteArray[218].call((Object)this.moshi, Map.class), (Object)updateDoc));
        RequestBody body = (RequestBody)ScriptBytecodeAdapter.castToType((Object)callSiteArray[219].call(RequestBody.class, (Object)documentAsJson, callSiteArray[220].callStatic(MediaType.class, (Object)"application/json")), RequestBody.class);
        Request.Builder builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[221].callConstructor(Request.Builder.class), Request.Builder.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[222].call(callSiteArray[223].call((Object)builder, (Object)new GStringImpl(new Object[]{callSiteArray[224].callCurrent((GroovyObject)this), callSiteArray[225].call((Object)db)}, new String[]{"", "/", "/_bulk_docs"})), (Object)body);
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[226].call(callSiteArray[227].call((Object)builder, (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[228].call((Object)db)}, new String[]{"", "/", "/_bulk_docs"})), (Object)body);
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[229].call((Object)builder, (Object)"Authorization", callSiteArray[230].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[231].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[232].call(callSiteArray[233].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[234].callGetProperty((Object)response))) {
            callSiteArray[235].call((Object)log, (Object)"error {}", callSiteArray[236].call((Object)response));
            throw (Throwable)callSiteArray[237].callConstructor(IllegalStateException.class, (Object)"bulk update failed");
        }
        List result = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[238].callCurrent((GroovyObject)this, callSiteArray[239].call(callSiteArray[240].call((Object)response))), List.class);
        public final class _updateBulk_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _updateBulk_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _updateBulk_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object updated, Object original) {
                CallSite[] callSiteArray = _updateBulk_closure6.$getCallSiteArray();
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].callGetProperty(updated))) {
                    Object object = callSiteArray[1].callGetProperty(updated);
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)original, (String)"_id");
                    Object object2 = callSiteArray[2].callGetProperty(updated);
                    ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)original, (String)"_rev");
                    return original;
                }
                callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)"error {}", updated);
                return null;
            }

            @Generated
            public Object call(Object updated, Object original) {
                CallSite[] callSiteArray = _updateBulk_closure6.$getCallSiteArray();
                return callSiteArray[5].callCurrent((GroovyObject)this, updated, original);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateBulk_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "ok";
                stringArray[1] = "id";
                stringArray[2] = "rev";
                stringArray[3] = "error";
                stringArray[4] = "log";
                stringArray[5] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _updateBulk_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_updateBulk_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _updateBulk_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[241].call(callSiteArray[242].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{result, documents})), (Object)new _updateBulk_closure6(this, this));
        return result;
    }

    public boolean containsDb(String db) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[243].call(callSiteArray[244].call(callSiteArray[245].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[246].callCurrent((GroovyObject)this), callSiteArray[247].call((Object)db)}, new String[]{"", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[248].call(callSiteArray[249].call(callSiteArray[250].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[251].call((Object)db)}, new String[]{"", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[252].call((Object)builder, (Object)"Authorization", callSiteArray[253].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[254].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[255].call(callSiteArray[256].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[257].callGetProperty((Object)response))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[258].call((Object)response), (Object)404)) {
                return false;
            }
            callSiteArray[259].call((Object)log, (Object)"error {}", callSiteArray[260].call((Object)response));
            throw (Throwable)callSiteArray[261].callConstructor(IllegalStateException.class, (Object)"could not check for database existence");
        }
        return true;
    }

    public Object createDb(String db) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[262].call(callSiteArray[263].call(callSiteArray[264].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[265].callCurrent((GroovyObject)this), callSiteArray[266].call((Object)db)}, new String[]{"", "/", ""})), callSiteArray[267].call(RequestBody.class, (Object)"", callSiteArray[268].callStatic(MediaType.class, (Object)"application/json")));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[269].call(callSiteArray[270].call(callSiteArray[271].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[272].call((Object)db)}, new String[]{"", "/", ""})), callSiteArray[273].call(RequestBody.class, (Object)"", callSiteArray[274].callStatic(MediaType.class, (Object)"application/json")));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[275].call((Object)builder, (Object)"Authorization", callSiteArray[276].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[277].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[278].call(callSiteArray[279].call((Object)this.client, (Object)request)), Response.class);
        Map result = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[280].callCurrent((GroovyObject)this, callSiteArray[281].call(callSiteArray[282].call((Object)response))), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[283].callGetProperty((Object)result))) {
            callSiteArray[284].call((Object)log, (Object)"error {}", (Object)result);
            throw (Throwable)callSiteArray[285].callConstructor(IllegalStateException.class, (Object)"error creating database");
        }
        return result;
    }

    public Object deleteDb(String db) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[286].call(callSiteArray[287].call(callSiteArray[288].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[289].callCurrent((GroovyObject)this), callSiteArray[290].call((Object)db)}, new String[]{"", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[291].call(callSiteArray[292].call(callSiteArray[293].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[294].call((Object)db)}, new String[]{"", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[295].call((Object)builder, (Object)"Authorization", callSiteArray[296].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[297].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[298].call(callSiteArray[299].call((Object)this.client, (Object)request)), Response.class);
        Map result = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[300].callCurrent((GroovyObject)this, callSiteArray[301].call(callSiteArray[302].call((Object)response))), Map.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[303].callGetProperty((Object)result))) {
            callSiteArray[304].call((Object)log, (Object)"error {}", (Object)result);
            throw (Throwable)callSiteArray[305].callConstructor(IllegalStateException.class, (Object)"error deleting database");
        }
        return result;
    }

    public Map createFindAllDocsView(String db) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        String findAll = "function(doc) { emit(null, doc._id) }";
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[306].callCurrent((GroovyObject)this, (Object)db, (Object)"all", (Object)findAll, null), Map.class);
    }

    public Map createFindByPropertyView(String db, String propertyName) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        String findByProperty = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{propertyName, propertyName}, new String[]{"function(doc) { if (doc['", "']) { emit(doc['", "'], doc._id) } }"}));
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[307].callCurrent((GroovyObject)this, (Object)db, (Object)new GStringImpl(new Object[]{propertyName}, new String[]{"by_", ""}), (Object)findByProperty, null), Map.class);
    }

    public Map createView(String db, String viewName, String mapFunction, String reduceFunction) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Map view = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)mapFunction)) {
            String string = mapFunction;
            callSiteArray[308].call((Object)view, (Object)"map", (Object)string);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)reduceFunction)) {
            String string = reduceFunction;
            callSiteArray[309].call((Object)view, (Object)"reduce", (Object)string);
        }
        String designDocId = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[310].call((Object)db)}, new String[]{"_design/", ""}));
        Map newDesignDoc = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"_id", designDocId, "language", "javascript", "views", ScriptBytecodeAdapter.createMap((Object[])new Object[]{viewName, view})});
        int designDocExists = 0;
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[311].callCurrent((GroovyObject)this, (Object)db, (Object)designDocId);
            designDocExists = DefaultTypeTransformation.booleanUnbox((Object)object) ? 1 : 0;
        } else {
            boolean bl = this.contains(db, designDocId);
            designDocExists = bl ? 1 : 0;
        }
        if (designDocExists != 0) {
            Map currentDesignDoc = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[312].callCurrent((GroovyObject)this, (Object)db, (Object)designDocId);
                currentDesignDoc = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
            } else {
                Object r = this.get(db, designDocId);
                currentDesignDoc = (Map)ScriptBytecodeAdapter.castToType(r, Map.class);
            }
            Map mergedDesignDoc = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[313].callStatic(CouchDbClient.class, (Object)currentDesignDoc, (Object)newDesignDoc), Map.class);
            if (ScriptBytecodeAdapter.compareNotEqual((Object)mergedDesignDoc, (Object)currentDesignDoc)) {
                callSiteArray[314].callCurrent((GroovyObject)this, (Object)db, (Object)mergedDesignDoc);
            }
            return currentDesignDoc;
        }
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[315].callCurrent((GroovyObject)this, (Object)db, (Object)newDesignDoc), Map.class);
    }

    public boolean contains(String db, String docId) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
        }
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[316].call(callSiteArray[317].call(callSiteArray[318].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[319].callCurrent((GroovyObject)this), callSiteArray[320].call((Object)db), docId}, new String[]{"", "/", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[321].call(callSiteArray[322].call(callSiteArray[323].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[324].call((Object)db), docId}, new String[]{"", "/", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[325].call((Object)builder, (Object)"Authorization", callSiteArray[326].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[327].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[328].call(callSiteArray[329].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[330].callGetProperty((Object)response))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[331].call((Object)response), (Object)404)) {
                return false;
            }
            callSiteArray[332].call((Object)log, (Object)"error {}", callSiteArray[333].call((Object)response));
            throw (Throwable)callSiteArray[334].callConstructor(IllegalStateException.class, (Object)"could not check for doc existence");
        }
        return true;
    }

    public <R> R get(String db, String docId) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
        }
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[335].call(callSiteArray[336].call(callSiteArray[337].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[338].callCurrent((GroovyObject)this), callSiteArray[339].call((Object)db), docId}, new String[]{"", "/", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[340].call(callSiteArray[341].call(callSiteArray[342].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[343].call((Object)db), docId}, new String[]{"", "/", "/", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[344].call((Object)builder, (Object)"Authorization", callSiteArray[345].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[346].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[347].call(callSiteArray[348].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[349].callGetProperty((Object)response))) {
            callSiteArray[350].call((Object)log, (Object)"error getting document({}): {}/{}", (Object)docId, callSiteArray[351].call((Object)response), callSiteArray[352].call((Object)response));
            throw (Throwable)callSiteArray[353].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{docId}, new String[]{"could not get doc with id '", "'"}));
        }
        Object doc = callSiteArray[354].callCurrent((GroovyObject)this, callSiteArray[355].call(callSiteArray[356].call((Object)response)));
        return (R)doc;
    }

    public Map delete(String db, String docId, String rev) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
        } else {
            Object object = CouchDbClient.sanitizeDocId(docId);
            docId = ShortTypeHandling.castToString((Object)object);
        }
        Request.Builder builder = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[357].call(callSiteArray[358].call(callSiteArray[359].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{callSiteArray[360].callCurrent((GroovyObject)this), callSiteArray[361].call((Object)db), docId, rev}, new String[]{"", "/", "/", "?rev=", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        } else {
            Object object = callSiteArray[362].call(callSiteArray[363].call(callSiteArray[364].callConstructor(Request.Builder.class), (Object)new GStringImpl(new Object[]{this.getBaseUrl(), callSiteArray[365].call((Object)db), docId, rev}, new String[]{"", "/", "/", "?rev=", ""})));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            Object object = callSiteArray[366].call((Object)builder, (Object)"Authorization", callSiteArray[367].call(Credentials.class, (Object)this.couchdbUsername, (Object)this.couchdbPassword));
            builder = (Request.Builder)ScriptBytecodeAdapter.castToType((Object)object, Request.Builder.class);
        }
        Request request = (Request)ScriptBytecodeAdapter.castToType((Object)callSiteArray[368].call((Object)builder), Request.class);
        Response response = (Response)ScriptBytecodeAdapter.castToType((Object)callSiteArray[369].call(callSiteArray[370].call((Object)this.client, (Object)request)), Response.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[371].callGetProperty((Object)response))) {
            callSiteArray[372].call((Object)log, ArrayUtil.createArray((Object)"error deleting doc{ _id:{}, _rev:{} }: {}/{}", (Object)docId, (Object)rev, (Object)callSiteArray[373].call((Object)response), (Object)callSiteArray[374].call((Object)response)));
            throw (Throwable)callSiteArray[375].callConstructor(IllegalStateException.class, (Object)new GStringImpl(new Object[]{docId, rev}, new String[]{"could not delete doc with id/rev '", "'/'", "'"}));
        }
        Map result = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[376].callCurrent((GroovyObject)this, callSiteArray[377].call(callSiteArray[378].call((Object)response))), Map.class);
        return result;
    }

    public static Map merge(Map currentDoc, Map changedDoc) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Object mergedDoc = callSiteArray[379].call((Object)currentDoc, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        Object object = callSiteArray[381].callGetProperty((Object)currentDoc);
        Object object2 = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Object object3 = callSiteArray[382].callGetProperty((Object)changedDoc);
        Object object4 = callSiteArray[380].call(object2, DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)mergedDoc, (String)"views");
        return (Map)ScriptBytecodeAdapter.castToType((Object)mergedDoc, Map.class);
    }

    public <R> R consume(InputStream stream) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Object result = callSiteArray[383].call(callSiteArray[384].call((Object)this.moshi, Object.class), callSiteArray[385].call(Okio.class, callSiteArray[386].call(Okio.class, (Object)stream)));
        callSiteArray[387].call(Util.class, (Object)stream);
        return (R)result;
    }

    public static Object sanitizeDocId(String docId) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[388].call((Object)docId, (Object)"_"))) {
            Object object = callSiteArray[389].call(URLEncoder.class, (Object)docId, callSiteArray[390].call(callSiteArray[391].callGetProperty(StandardCharsets.class)));
            docId = ShortTypeHandling.castToString((Object)object);
        }
        return docId;
    }

    public void beforeCreate(Map document) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[392].callGetProperty((Object)document))) {
            Object object = callSiteArray[393].call(callSiteArray[394].call(LocalDate.class));
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)document, (String)"dateCreated");
        }
    }

    public void beforeUpdate(Map document) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        Object object = callSiteArray[395].call(callSiteArray[396].call(LocalDate.class));
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)document, (String)"dateUpdated");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CouchDbClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public <R> R query(String db, String viewName, String key) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.query(db, viewName, key, true);
        }
        return this.query(db, viewName, key, true);
    }

    @Generated
    public <R> R query(String db, String viewName, Collection<String> keys) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        return this.query(db, viewName, keys, true);
    }

    @Generated
    public Object getAllDocs(String db, boolean includeDocs) {
        Reference includeDocs2 = new Reference((Object)includeDocs);
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getAllDocs(db, DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get()), false);
        }
        return this.getAllDocs(db, DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get()), false);
    }

    @Generated
    public Object getAllDocs(String db) {
        CallSite[] callSiteArray = CouchDbClient.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return this.getAllDocs(db, true, false);
        }
        return this.getAllDocs(db, true, false);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = CouchDbClient.$getCallSiteArray()[397].call(LoggerFactory.class, CouchDbClient.$getCallSiteArray()[398].callStatic(CouchDbClient.class));
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public OkHttpClient getClient() {
        return this.client;
    }

    @Generated
    public void setClient(OkHttpClient okHttpClient) {
        this.client = okHttpClient;
    }

    @Generated
    public Moshi getMoshi() {
        return this.moshi;
    }

    @Generated
    public void setMoshi(Moshi moshi) {
        this.moshi = moshi;
    }

    @Generated
    public boolean getTlsEnabled() {
        return this.tlsEnabled;
    }

    @Generated
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Generated
    public String getCouchdbHost() {
        return this.couchdbHost;
    }

    @Generated
    public int getCouchdbPort() {
        return this.couchdbPort;
    }

    @Generated
    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    @Generated
    public String getCouchdbUsername() {
        return this.couchdbUsername;
    }

    @Generated
    public void setCouchdbUsername(String string) {
        this.couchdbUsername = string;
    }

    @Generated
    public String getCouchdbPassword() {
        return this.couchdbPassword;
    }

    @Generated
    public void setCouchdbPassword(String string) {
        this.couchdbPassword = string;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "build";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "updateBaseUrl";
        stringArray[4] = "updateBaseUrl";
        stringArray[5] = "updateBaseUrl";
        stringArray[6] = "updateBaseUrl";
        stringArray[7] = "get";
        stringArray[8] = "url";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "getBaseUrl";
        stringArray[11] = "get";
        stringArray[12] = "url";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "build";
        stringArray[15] = "execute";
        stringArray[16] = "newCall";
        stringArray[17] = "successful";
        stringArray[18] = "code";
        stringArray[19] = "close";
        stringArray[20] = "body";
        stringArray[21] = "error";
        stringArray[22] = "message";
        stringArray[23] = "close";
        stringArray[24] = "body";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "info";
        stringArray[27] = "string";
        stringArray[28] = "body";
        stringArray[29] = "toJson";
        stringArray[30] = "adapter";
        stringArray[31] = "get";
        stringArray[32] = "url";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "plus";
        stringArray[35] = "plus";
        stringArray[36] = "plus";
        stringArray[37] = "plus";
        stringArray[38] = "plus";
        stringArray[39] = "getBaseUrl";
        stringArray[40] = "toLowerCase";
        stringArray[41] = "capitalize";
        stringArray[42] = "get";
        stringArray[43] = "url";
        stringArray[44] = "<$constructor$>";
        stringArray[45] = "plus";
        stringArray[46] = "plus";
        stringArray[47] = "plus";
        stringArray[48] = "plus";
        stringArray[49] = "plus";
        stringArray[50] = "toLowerCase";
        stringArray[51] = "capitalize";
        stringArray[52] = "header";
        stringArray[53] = "basic";
        stringArray[54] = "build";
        stringArray[55] = "execute";
        stringArray[56] = "newCall";
        stringArray[57] = "successful";
        stringArray[58] = "error";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "string";
        stringArray[61] = "body";
        stringArray[62] = "consume";
        stringArray[63] = "byteStream";
        stringArray[64] = "body";
        stringArray[65] = "collect";
        stringArray[66] = "rows";
        stringArray[67] = "toJson";
        stringArray[68] = "adapter";
        stringArray[69] = "get";
        stringArray[70] = "url";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "plus";
        stringArray[73] = "plus";
        stringArray[74] = "plus";
        stringArray[75] = "plus";
        stringArray[76] = "plus";
        stringArray[77] = "getBaseUrl";
        stringArray[78] = "toLowerCase";
        stringArray[79] = "capitalize";
        stringArray[80] = "get";
        stringArray[81] = "url";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "plus";
        stringArray[84] = "plus";
        stringArray[85] = "plus";
        stringArray[86] = "plus";
        stringArray[87] = "plus";
        stringArray[88] = "toLowerCase";
        stringArray[89] = "capitalize";
        stringArray[90] = "header";
        stringArray[91] = "basic";
        stringArray[92] = "build";
        stringArray[93] = "execute";
        stringArray[94] = "newCall";
        stringArray[95] = "successful";
        stringArray[96] = "error";
        stringArray[97] = "<$constructor$>";
        stringArray[98] = "string";
        stringArray[99] = "body";
        stringArray[100] = "consume";
        stringArray[101] = "byteStream";
        stringArray[102] = "body";
        stringArray[103] = "collect";
        stringArray[104] = "rows";
        stringArray[105] = "get";
        stringArray[106] = "url";
        stringArray[107] = "<$constructor$>";
        stringArray[108] = "plus";
        stringArray[109] = "plus";
        stringArray[110] = "getBaseUrl";
        stringArray[111] = "toLowerCase";
        stringArray[112] = "get";
        stringArray[113] = "url";
        stringArray[114] = "<$constructor$>";
        stringArray[115] = "plus";
        stringArray[116] = "plus";
        stringArray[117] = "toLowerCase";
        stringArray[118] = "header";
        stringArray[119] = "basic";
        stringArray[120] = "build";
        stringArray[121] = "execute";
        stringArray[122] = "newCall";
        stringArray[123] = "successful";
        stringArray[124] = "error";
        stringArray[125] = "code";
        stringArray[126] = "message";
        stringArray[127] = "<$constructor$>";
        stringArray[128] = "consume";
        stringArray[129] = "byteStream";
        stringArray[130] = "body";
        stringArray[131] = "collect";
        stringArray[132] = "rows";
        stringArray[133] = "grep";
        stringArray[134] = "<$constructor$>";
        stringArray[135] = "getAt";
        stringArray[136] = "error";
        stringArray[137] = "getAt";
        stringArray[138] = "getAt";
        stringArray[139] = "<$constructor$>";
        stringArray[140] = "beforeCreate";
        stringArray[141] = "toJson";
        stringArray[142] = "adapter";
        stringArray[143] = "create";
        stringArray[144] = "parse";
        stringArray[145] = "<$constructor$>";
        stringArray[146] = "getAt";
        stringArray[147] = "getAt";
        stringArray[148] = "put";
        stringArray[149] = "url";
        stringArray[150] = "getBaseUrl";
        stringArray[151] = "toLowerCase";
        stringArray[152] = "post";
        stringArray[153] = "url";
        stringArray[154] = "getBaseUrl";
        stringArray[155] = "toLowerCase";
        stringArray[156] = "getAt";
        stringArray[157] = "getAt";
        stringArray[158] = "put";
        stringArray[159] = "url";
        stringArray[160] = "toLowerCase";
        stringArray[161] = "post";
        stringArray[162] = "url";
        stringArray[163] = "toLowerCase";
        stringArray[164] = "header";
        stringArray[165] = "basic";
        stringArray[166] = "build";
        stringArray[167] = "execute";
        stringArray[168] = "newCall";
        stringArray[169] = "consume";
        stringArray[170] = "byteStream";
        stringArray[171] = "body";
        stringArray[172] = "ok";
        stringArray[173] = "error";
        stringArray[174] = "<$constructor$>";
        stringArray[175] = "fromJson";
        stringArray[176] = "adapter";
        stringArray[177] = "id";
        stringArray[178] = "putAt";
        stringArray[179] = "rev";
        stringArray[180] = "putAt";
        stringArray[181] = "<$constructor$>";
        stringArray[182] = "getAt";
        stringArray[183] = "<$constructor$>";
        stringArray[184] = "beforeUpdate";
        stringArray[185] = "toJson";
        stringArray[186] = "adapter";
        stringArray[187] = "create";
        stringArray[188] = "parse";
        stringArray[189] = "<$constructor$>";
        stringArray[190] = "getAt";
        stringArray[191] = "put";
        stringArray[192] = "url";
        stringArray[193] = "getBaseUrl";
        stringArray[194] = "toLowerCase";
        stringArray[195] = "put";
        stringArray[196] = "url";
        stringArray[197] = "toLowerCase";
        stringArray[198] = "header";
        stringArray[199] = "basic";
        stringArray[200] = "build";
        stringArray[201] = "execute";
        stringArray[202] = "newCall";
        stringArray[203] = "consume";
        stringArray[204] = "byteStream";
        stringArray[205] = "body";
        stringArray[206] = "ok";
        stringArray[207] = "error";
        stringArray[208] = "<$constructor$>";
        stringArray[209] = "fromJson";
        stringArray[210] = "adapter";
        stringArray[211] = "rev";
        stringArray[212] = "putAt";
        stringArray[213] = "<$constructor$>";
        stringArray[214] = "empty";
        stringArray[215] = "<$constructor$>";
        stringArray[216] = "each";
        stringArray[217] = "toJson";
        stringArray[218] = "adapter";
        stringArray[219] = "create";
        stringArray[220] = "parse";
        stringArray[221] = "<$constructor$>";
        stringArray[222] = "post";
        stringArray[223] = "url";
        stringArray[224] = "getBaseUrl";
        stringArray[225] = "toLowerCase";
        stringArray[226] = "post";
        stringArray[227] = "url";
        stringArray[228] = "toLowerCase";
        stringArray[229] = "header";
        stringArray[230] = "basic";
        stringArray[231] = "build";
        stringArray[232] = "execute";
        stringArray[233] = "newCall";
        stringArray[234] = "successful";
        stringArray[235] = "error";
        stringArray[236] = "message";
        stringArray[237] = "<$constructor$>";
        stringArray[238] = "consume";
        stringArray[239] = "byteStream";
        stringArray[240] = "body";
        stringArray[241] = "each";
        stringArray[242] = "transpose";
        stringArray[243] = "head";
        stringArray[244] = "url";
        stringArray[245] = "<$constructor$>";
        stringArray[246] = "getBaseUrl";
        stringArray[247] = "toLowerCase";
        stringArray[248] = "head";
        stringArray[249] = "url";
        stringArray[250] = "<$constructor$>";
        stringArray[251] = "toLowerCase";
        stringArray[252] = "header";
        stringArray[253] = "basic";
        stringArray[254] = "build";
        stringArray[255] = "execute";
        stringArray[256] = "newCall";
        stringArray[257] = "successful";
        stringArray[258] = "code";
        stringArray[259] = "error";
        stringArray[260] = "message";
        stringArray[261] = "<$constructor$>";
        stringArray[262] = "put";
        stringArray[263] = "url";
        stringArray[264] = "<$constructor$>";
        stringArray[265] = "getBaseUrl";
        stringArray[266] = "toLowerCase";
        stringArray[267] = "create";
        stringArray[268] = "parse";
        stringArray[269] = "put";
        stringArray[270] = "url";
        stringArray[271] = "<$constructor$>";
        stringArray[272] = "toLowerCase";
        stringArray[273] = "create";
        stringArray[274] = "parse";
        stringArray[275] = "header";
        stringArray[276] = "basic";
        stringArray[277] = "build";
        stringArray[278] = "execute";
        stringArray[279] = "newCall";
        stringArray[280] = "consume";
        stringArray[281] = "byteStream";
        stringArray[282] = "body";
        stringArray[283] = "ok";
        stringArray[284] = "error";
        stringArray[285] = "<$constructor$>";
        stringArray[286] = "delete";
        stringArray[287] = "url";
        stringArray[288] = "<$constructor$>";
        stringArray[289] = "getBaseUrl";
        stringArray[290] = "toLowerCase";
        stringArray[291] = "delete";
        stringArray[292] = "url";
        stringArray[293] = "<$constructor$>";
        stringArray[294] = "toLowerCase";
        stringArray[295] = "header";
        stringArray[296] = "basic";
        stringArray[297] = "build";
        stringArray[298] = "execute";
        stringArray[299] = "newCall";
        stringArray[300] = "consume";
        stringArray[301] = "byteStream";
        stringArray[302] = "body";
        stringArray[303] = "ok";
        stringArray[304] = "error";
        stringArray[305] = "<$constructor$>";
        stringArray[306] = "createView";
        stringArray[307] = "createView";
        stringArray[308] = "putAt";
        stringArray[309] = "putAt";
        stringArray[310] = "capitalize";
        stringArray[311] = "contains";
        stringArray[312] = "get";
        stringArray[313] = "merge";
        stringArray[314] = "update";
        stringArray[315] = "update";
        stringArray[316] = "head";
        stringArray[317] = "url";
        stringArray[318] = "<$constructor$>";
        stringArray[319] = "getBaseUrl";
        stringArray[320] = "toLowerCase";
        stringArray[321] = "head";
        stringArray[322] = "url";
        stringArray[323] = "<$constructor$>";
        stringArray[324] = "toLowerCase";
        stringArray[325] = "header";
        stringArray[326] = "basic";
        stringArray[327] = "build";
        stringArray[328] = "execute";
        stringArray[329] = "newCall";
        stringArray[330] = "successful";
        stringArray[331] = "code";
        stringArray[332] = "error";
        stringArray[333] = "message";
        stringArray[334] = "<$constructor$>";
        stringArray[335] = "get";
        stringArray[336] = "url";
        stringArray[337] = "<$constructor$>";
        stringArray[338] = "getBaseUrl";
        stringArray[339] = "toLowerCase";
        stringArray[340] = "get";
        stringArray[341] = "url";
        stringArray[342] = "<$constructor$>";
        stringArray[343] = "toLowerCase";
        stringArray[344] = "header";
        stringArray[345] = "basic";
        stringArray[346] = "build";
        stringArray[347] = "execute";
        stringArray[348] = "newCall";
        stringArray[349] = "successful";
        stringArray[350] = "error";
        stringArray[351] = "code";
        stringArray[352] = "message";
        stringArray[353] = "<$constructor$>";
        stringArray[354] = "consume";
        stringArray[355] = "byteStream";
        stringArray[356] = "body";
        stringArray[357] = "delete";
        stringArray[358] = "url";
        stringArray[359] = "<$constructor$>";
        stringArray[360] = "getBaseUrl";
        stringArray[361] = "toLowerCase";
        stringArray[362] = "delete";
        stringArray[363] = "url";
        stringArray[364] = "<$constructor$>";
        stringArray[365] = "toLowerCase";
        stringArray[366] = "header";
        stringArray[367] = "basic";
        stringArray[368] = "build";
        stringArray[369] = "execute";
        stringArray[370] = "newCall";
        stringArray[371] = "successful";
        stringArray[372] = "error";
        stringArray[373] = "code";
        stringArray[374] = "message";
        stringArray[375] = "<$constructor$>";
        stringArray[376] = "consume";
        stringArray[377] = "byteStream";
        stringArray[378] = "body";
        stringArray[379] = "plus";
        stringArray[380] = "plus";
        stringArray[381] = "views";
        stringArray[382] = "views";
        stringArray[383] = "fromJson";
        stringArray[384] = "adapter";
        stringArray[385] = "buffer";
        stringArray[386] = "source";
        stringArray[387] = "closeQuietly";
        stringArray[388] = "startsWith";
        stringArray[389] = "encode";
        stringArray[390] = "toString";
        stringArray[391] = "UTF_8";
        stringArray[392] = "dateCreated";
        stringArray[393] = "toString";
        stringArray[394] = "now";
        stringArray[395] = "toString";
        stringArray[396] = "now";
        stringArray[397] = "getLogger";
        stringArray[398] = "getClass";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[399];
        CouchDbClient.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(CouchDbClient.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = CouchDbClient.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

