/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.couchdb;

import de.gesellix.couchdb.Json;
import de.gesellix.couchdb.JsonMoshi;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDbClient
implements GroovyObject {
    private static final Logger log;
    private OkHttpClient client;
    private Json json;
    private boolean tlsEnabled;
    private String couchdbHost;
    private int couchdbPort;
    private String baseUrl;
    private String couchdbUsername;
    private String couchdbPassword;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public CouchDbClient() {
        this((Json)((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, JsonMoshi.class))));
    }

    public CouchDbClient(Json json) {
        int n;
        String string;
        boolean bl;
        Json json2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, OkHttpClient.class);
        this.client = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.json = json2 = json;
        this.tlsEnabled = bl = false;
        this.couchdbHost = string = "127.0.0.1";
        this.couchdbPort = n = 5984;
    }

    public void updateBaseUrl() {
        GStringImpl gStringImpl = new GStringImpl(new Object[]{this.tlsEnabled ? "https" : "http", this.couchdbHost, this.couchdbPort}, new String[]{"", "://", ":", ""});
        this.baseUrl = IndyInterface.bootstrap("cast", "()", 0, gStringImpl);
    }

    public String getBaseUrl() {
        if (ScriptBytecodeAdapter.compareEqual((Object)this.baseUrl, null)) {
            IndyInterface.bootstrap("invoke", "updateBaseUrl", 2, this);
        }
        return this.baseUrl;
    }

    public void setTlsEnabled(boolean tlsEnabled) {
        boolean bl;
        this.tlsEnabled = bl = tlsEnabled;
        IndyInterface.bootstrap("invoke", "updateBaseUrl", 2, this);
    }

    public void setCouchdbHost(String couchdbHost) {
        String string;
        this.couchdbHost = string = couchdbHost;
        IndyInterface.bootstrap("invoke", "updateBaseUrl", 2, this);
    }

    public void setCouchdbPort(int couchdbPort) {
        int n;
        this.couchdbPort = n = couchdbPort;
        IndyInterface.bootstrap("invoke", "updateBaseUrl", 2, this);
    }

    public boolean healthy() {
        CallSite builder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "url", 0, IndyInterface.bootstrap("init", "<init>", 0, Request.Builder.class), IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this))));
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("invoke", "newCall", 0, this.client, request)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "successful", 0, response)) == false) {
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "code", 0, response), (Object)404)) {
                IndyInterface.bootstrap("invoke", "close", 0, IndyInterface.bootstrap("invoke", "body", 0, response));
                return false;
            }
            IndyInterface.bootstrap("invoke", "error", 0, log, "error {}", IndyInterface.bootstrap("invoke", "message", 0, response));
            IndyInterface.bootstrap("invoke", "close", 0, IndyInterface.bootstrap("invoke", "body", 0, response));
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "could not check for database existence"));
        }
        IndyInterface.bootstrap("invoke", "info", 0, log, IndyInterface.bootstrap("invoke", "string", 0, IndyInterface.bootstrap("invoke", "body", 0, response)));
        return true;
    }

    public <R> R query(String db, String viewName, String key, boolean includeDocs) {
        Reference includeDocs2 = new Reference((Object)includeDocs);
        List query = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())) {
            IndyInterface.bootstrap("invoke", "add", 0, query, new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"include_docs=", ""}));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, key) != false) {
            CallSite encodedKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "encodeQueryValue", 0, this.json, key));
            IndyInterface.bootstrap("invoke", "add", 0, query, new GStringImpl(new Object[]{encodedKey}, new String[]{"key=", ""}));
        }
        CallSite queryAsString = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "join", 0, query, "&"));
        CallSite builder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "url", 0, IndyInterface.bootstrap("init", "<init>", 0, Request.Builder.class), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, db)}, new String[]{"/", ""})), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "capitalize", 0, db)}, new String[]{"/_design/", ""})), new GStringImpl(new Object[]{viewName}, new String[]{"/_view/", ""})), new GStringImpl(new Object[]{queryAsString}, new String[]{"?", ""})))));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "header", 0, builder, "Authorization", IndyInterface.bootstrap("invoke", "basic", 0, Credentials.class, this.couchdbUsername, this.couchdbPassword));
            builder = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("invoke", "newCall", 0, this.client, request)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "successful", 0, response)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, log, "request failed: {}", request);
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IOException.class, IndyInterface.bootstrap("invoke", "string", 0, IndyInterface.bootstrap("invoke", "body", 0, response))));
        }
        CallSite result = IndyInterface.bootstrap("invoke", "consume", 0, this.json, IndyInterface.bootstrap("invoke", "byteStream", 0, IndyInterface.bootstrap("invoke", "body", 0, response)), Map.class);
        public final class _query_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includeDocs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _query_closure1(Object _outerInstance, Object _thisObject, Reference includeDocs) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.includeDocs = reference = includeDocs;
            }

            public Object doCall(Object row) {
                return IndyInterface.bootstrap("cast", "()", 0, this.includeDocs.get()) != false ? IndyInterface.bootstrap("getProperty", "doc", 0, row) : row;
            }

            @Generated
            public boolean getIncludeDocs() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _query_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return (R)IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "rows", 0, result), new _query_closure1(this, this, includeDocs2));
    }

    public <R> R query(String db, String viewName, Collection<String> keys, boolean includeDocs, boolean group) {
        Reference includeDocs2 = new Reference((Object)includeDocs);
        List query = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())) {
            IndyInterface.bootstrap("invoke", "add", 0, query, new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"include_docs=", ""}));
        }
        if (group) {
            IndyInterface.bootstrap("invoke", "add", 0, query, new GStringImpl(new Object[]{group}, new String[]{"group=", ""}));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, keys) != false) {
            CallSite encodedKeys = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "encodeQueryValue", 0, this.json, keys));
            IndyInterface.bootstrap("invoke", "add", 0, query, new GStringImpl(new Object[]{encodedKeys}, new String[]{"keys=", ""}));
        }
        CallSite queryAsString = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "join", 0, query, "&"));
        CallSite builder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "url", 0, IndyInterface.bootstrap("init", "<init>", 0, Request.Builder.class), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, db)}, new String[]{"/", ""})), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "capitalize", 0, db)}, new String[]{"/_design/", ""})), new GStringImpl(new Object[]{viewName}, new String[]{"/_view/", ""})), new GStringImpl(new Object[]{queryAsString}, new String[]{"?", ""})))));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "header", 0, builder, "Authorization", IndyInterface.bootstrap("invoke", "basic", 0, Credentials.class, this.couchdbUsername, this.couchdbPassword));
            builder = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("invoke", "newCall", 0, this.client, request)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "successful", 0, response)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, log, "request failed: {}", request);
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IOException.class, IndyInterface.bootstrap("invoke", "string", 0, IndyInterface.bootstrap("invoke", "body", 0, response))));
        }
        CallSite result = IndyInterface.bootstrap("invoke", "consume", 0, this.json, IndyInterface.bootstrap("invoke", "byteStream", 0, IndyInterface.bootstrap("invoke", "body", 0, response)), Map.class);
        public final class _query_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includeDocs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _query_closure2(Object _outerInstance, Object _thisObject, Reference includeDocs) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.includeDocs = reference = includeDocs;
            }

            public Object doCall(Object row) {
                return IndyInterface.bootstrap("cast", "()", 0, this.includeDocs.get()) != false ? IndyInterface.bootstrap("getProperty", "doc", 0, row) : row;
            }

            @Generated
            public boolean getIncludeDocs() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _query_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return (R)IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "rows", 0, result), new _query_closure2(this, this, includeDocs2));
    }

    public Object getAllDocs(String db, boolean includeDocs, boolean includeDesignDoc) {
        CallSite callSite;
        Reference includeDocs2 = new Reference((Object)includeDocs);
        CallSite builder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "url", 0, IndyInterface.bootstrap("init", "<init>", 0, Request.Builder.class), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this), IndyInterface.bootstrap("invoke", "toLowerCase", 0, db)}, new String[]{"", "/", ""}), "/_all_docs"), new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get())}, new String[]{"?include_docs=", ""})))));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "header", 0, builder, "Authorization", IndyInterface.bootstrap("invoke", "basic", 0, Credentials.class, this.couchdbUsername, this.couchdbPassword));
            builder = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("invoke", "newCall", 0, this.client, request)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "successful", 0, response)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, log, "error getting all docs: {}/{}", IndyInterface.bootstrap("invoke", "code", 0, response), IndyInterface.bootstrap("invoke", "message", 0, response));
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "could not get all docs with"));
        }
        CallSite allDocs = IndyInterface.bootstrap("invoke", "consume", 0, this.json, IndyInterface.bootstrap("invoke", "byteStream", 0, IndyInterface.bootstrap("invoke", "body", 0, response)), Map.class);
        public final class _getAllDocs_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference includeDocs;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAllDocs_closure3(Object _outerInstance, Object _thisObject, Reference includeDocs) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.includeDocs = reference = includeDocs;
            }

            public Object doCall(Object row) {
                return IndyInterface.bootstrap("cast", "()", 0, this.includeDocs.get()) != false ? IndyInterface.bootstrap("getProperty", "doc", 0, row) : row;
            }

            @Generated
            public boolean getIncludeDocs() {
                return DefaultTypeTransformation.booleanUnbox((Object)this.includeDocs.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAllDocs_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        allDocs = callSite = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "rows", 0, allDocs), new _getAllDocs_closure3(this, this, includeDocs2));
        if (!includeDesignDoc) {
            CallSite callSite3;
            public final class _getAllDocs_closure4
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAllDocs_closure4(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 1, IndyInterface.bootstrap("getProperty", "_id", 0, it), "_design/")) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 1, IndyInterface.bootstrap("getProperty", "id", 0, it), "_design/")) == false;
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAllDocs_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            allDocs = callSite3 = IndyInterface.bootstrap("invoke", "grep", 0, allDocs, new _getAllDocs_closure4(this, this));
        }
        return allDocs;
    }

    public Object create(String db, Map document) {
        if (ScriptBytecodeAdapter.compareEqual((Object)document, null)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "document may not be null"));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, document, "_rev")) != false) {
            IndyInterface.bootstrap("invoke", "error", 0, log, "document must be new, but has id({}), rev({})", IndyInterface.bootstrap("invoke", "getAt", 0, document, "_id"), IndyInterface.bootstrap("invoke", "getAt", 0, document, "_rev"));
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "document must be new"));
        }
        IndyInterface.bootstrap("invoke", "beforeCreate", 2, this, document);
        CallSite documentAsJson = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "encodeDocument", 0, this.json, document));
        CallSite body = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "create", 0, RequestBody.class, documentAsJson, IndyInterface.bootstrap("invoke", "parse", 0, MediaType.class, "application/json")));
        CallSite builder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Request.Builder.class));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, document, "_id")) != false) {
            CallSite docId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, document, "_id"));
            CallSite callSite = IndyInterface.bootstrap("invoke", "sanitizeDocId", 0, CouchDbClient.class, docId);
            docId = IndyInterface.bootstrap("cast", "()", 0, callSite);
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("invoke", "url", 0, builder, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this), IndyInterface.bootstrap("invoke", "toLowerCase", 0, db), docId}, new String[]{"", "/", "/", ""})), body);
            builder = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        } else {
            CallSite callSite = IndyInterface.bootstrap("invoke", "post", 0, IndyInterface.bootstrap("invoke", "url", 0, builder, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this), IndyInterface.bootstrap("invoke", "toLowerCase", 0, db)}, new String[]{"", "/", ""})), body);
            builder = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "header", 0, builder, "Authorization", IndyInterface.bootstrap("invoke", "basic", 0, Credentials.class, this.couchdbUsername, this.couchdbPassword));
            builder = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("invoke", "newCall", 0, this.client, request)));
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "consume", 0, this.json, IndyInterface.bootstrap("invoke", "byteStream", 0, IndyInterface.bootstrap("invoke", "body", 0, response)), Map.class));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ok", 0, result)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, log, "error {}", result);
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "error creating document"));
        }
        CallSite createdDocument = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "decodeDocument", 0, this.json, documentAsJson, Map.class));
        CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 0, result);
        IndyInterface.bootstrap("invoke", "putAt", 0, createdDocument, "_id", callSite);
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "rev", 0, result);
        IndyInterface.bootstrap("invoke", "putAt", 0, createdDocument, "_rev", callSite3);
        return createdDocument;
    }

    public Object update(String db, Map document) {
        CallSite callSite;
        if (ScriptBytecodeAdapter.compareEqual((Object)document, null)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "document may not be null"));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, document, "_id")) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "document id missing"));
        }
        IndyInterface.bootstrap("invoke", "beforeUpdate", 2, this, document);
        CallSite documentAsJson = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "encodeDocument", 0, this.json, document));
        CallSite body = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "create", 0, RequestBody.class, documentAsJson, IndyInterface.bootstrap("invoke", "parse", 0, MediaType.class, "application/json")));
        CallSite builder = IndyInterface.bootstrap("init", "<init>", 0, Request.Builder.class);
        CallSite docId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, document, "_id"));
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "sanitizeDocId", 0, CouchDbClient.class, docId);
        docId = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        builder = callSite = IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("invoke", "url", 0, builder, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this), IndyInterface.bootstrap("invoke", "toLowerCase", 0, db), docId}, new String[]{"", "/", "/", ""})), body);
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            CallSite callSite3;
            builder = callSite3 = IndyInterface.bootstrap("invoke", "header", 0, builder, "Authorization", IndyInterface.bootstrap("invoke", "basic", 0, Credentials.class, this.couchdbUsername, this.couchdbPassword));
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("invoke", "newCall", 0, this.client, request)));
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "consume", 0, this.json, IndyInterface.bootstrap("invoke", "byteStream", 0, IndyInterface.bootstrap("invoke", "body", 0, response)), Map.class));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ok", 0, result)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, log, "error {}", result);
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "error updating document"));
        }
        CallSite updatedDocument = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "decodeDocument", 0, this.json, documentAsJson, Map.class));
        CallSite callSite4 = IndyInterface.bootstrap("getProperty", "rev", 0, result);
        IndyInterface.bootstrap("invoke", "putAt", 0, updatedDocument, "_rev", callSite4);
        return updatedDocument;
    }

    public List<Map> updateBulk(String db, List<Map> documents) {
        if (ScriptBytecodeAdapter.compareEqual(documents, null)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "documents may not be null"));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "empty", 0, documents)) != false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "documents is empty"));
        }
        public final class _updateBulk_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateBulk_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object document) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, document, "_id")) != false) {
                    return IndyInterface.bootstrap("invoke", "beforeUpdate", 2, this, document);
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "dateCreated", 0, document)) == false) {
                    return IndyInterface.bootstrap("invoke", "beforeCreate", 2, this, document);
                }
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateBulk_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, documents, new _updateBulk_closure5(this, this));
        Map updateDoc = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"docs", documents});
        CallSite documentAsJson = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "encodeDocument", 0, this.json, updateDoc));
        CallSite body = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "create", 0, RequestBody.class, documentAsJson, IndyInterface.bootstrap("invoke", "parse", 0, MediaType.class, "application/json")));
        CallSite builder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Request.Builder.class));
        CallSite callSite = IndyInterface.bootstrap("invoke", "post", 0, IndyInterface.bootstrap("invoke", "url", 0, builder, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this), IndyInterface.bootstrap("invoke", "toLowerCase", 0, db)}, new String[]{"", "/", "/_bulk_docs"})), body);
        builder = IndyInterface.bootstrap("cast", "()", 0, callSite);
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "header", 0, builder, "Authorization", IndyInterface.bootstrap("invoke", "basic", 0, Credentials.class, this.couchdbUsername, this.couchdbPassword));
            builder = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("invoke", "newCall", 0, this.client, request)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "successful", 0, response)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, log, "error {}", IndyInterface.bootstrap("invoke", "message", 0, response));
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "bulk update failed"));
        }
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "consume", 0, this.json, IndyInterface.bootstrap("invoke", "byteStream", 0, IndyInterface.bootstrap("invoke", "body", 0, response)), List.class));
        public final class _updateBulk_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateBulk_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object updated, Object original) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ok", 0, updated)) != false) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "id", 0, updated);
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)original, (String)"_id");
                    CallSite callSite2 = IndyInterface.bootstrap("getProperty", "rev", 0, updated);
                    ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)original, (String)"_rev");
                    return original;
                }
                IndyInterface.bootstrap("invoke", "error", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "error {}", updated);
                return null;
            }

            @Generated
            public Object call(Object updated, Object original) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, updated, original);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateBulk_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "transpose", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{result, documents})), new _updateBulk_closure6(this, this));
        return result;
    }

    public boolean containsDb(String db) {
        CallSite builder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "head", 0, IndyInterface.bootstrap("invoke", "url", 0, IndyInterface.bootstrap("init", "<init>", 0, Request.Builder.class), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this), IndyInterface.bootstrap("invoke", "toLowerCase", 0, db)}, new String[]{"", "/", ""}))));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "header", 0, builder, "Authorization", IndyInterface.bootstrap("invoke", "basic", 0, Credentials.class, this.couchdbUsername, this.couchdbPassword));
            builder = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("invoke", "newCall", 0, this.client, request)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "successful", 0, response)) == false) {
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "code", 0, response), (Object)404)) {
                return false;
            }
            IndyInterface.bootstrap("invoke", "error", 0, log, "error {}", IndyInterface.bootstrap("invoke", "message", 0, response));
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "could not check for database existence"));
        }
        return true;
    }

    public Object createDb(String db) {
        CallSite builder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("invoke", "url", 0, IndyInterface.bootstrap("init", "<init>", 0, Request.Builder.class), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this), IndyInterface.bootstrap("invoke", "toLowerCase", 0, db)}, new String[]{"", "/", ""})), IndyInterface.bootstrap("invoke", "create", 0, RequestBody.class, "", IndyInterface.bootstrap("invoke", "parse", 0, MediaType.class, "application/json"))));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "header", 0, builder, "Authorization", IndyInterface.bootstrap("invoke", "basic", 0, Credentials.class, this.couchdbUsername, this.couchdbPassword));
            builder = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("invoke", "newCall", 0, this.client, request)));
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "consume", 0, this.json, IndyInterface.bootstrap("invoke", "byteStream", 0, IndyInterface.bootstrap("invoke", "body", 0, response)), Map.class));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ok", 0, result)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, log, "error {}", result);
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "error creating database"));
        }
        return result;
    }

    public Object deleteDb(String db) {
        CallSite builder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "url", 0, IndyInterface.bootstrap("init", "<init>", 0, Request.Builder.class), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this), IndyInterface.bootstrap("invoke", "toLowerCase", 0, db)}, new String[]{"", "/", ""}))));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "header", 0, builder, "Authorization", IndyInterface.bootstrap("invoke", "basic", 0, Credentials.class, this.couchdbUsername, this.couchdbPassword));
            builder = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("invoke", "newCall", 0, this.client, request)));
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "consume", 0, this.json, IndyInterface.bootstrap("invoke", "byteStream", 0, IndyInterface.bootstrap("invoke", "body", 0, response)), Map.class));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ok", 0, result)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, log, "error {}", result);
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "error deleting database"));
        }
        return result;
    }

    public Map createFindAllDocsView(String db) {
        String findAll = "function(doc) { emit(null, doc._id) }";
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createView", 2, this, db, "all", findAll, null));
    }

    public Map createFindByPropertyView(String db, String propertyName) {
        CallSite findByProperty = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{propertyName, propertyName}, new String[]{"function(doc) { if (doc['", "']) { emit(doc['", "'], doc._id) } }"}));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createView", 2, this, db, new GStringImpl(new Object[]{propertyName}, new String[]{"by_", ""}), findByProperty, null));
    }

    public Map createView(String db, String viewName, String mapFunction, String reduceFunction) {
        Map view = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (IndyInterface.bootstrap("cast", "()", 0, mapFunction) != false) {
            String string = mapFunction;
            IndyInterface.bootstrap("invoke", "putAt", 0, view, "map", string);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, reduceFunction) != false) {
            String string = reduceFunction;
            IndyInterface.bootstrap("invoke", "putAt", 0, view, "reduce", string);
        }
        CallSite designDocId = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "capitalize", 0, db)}, new String[]{"_design/", ""}));
        Map newDesignDoc = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"_id", designDocId, "language", "javascript", "views", ScriptBytecodeAdapter.createMap((Object[])new Object[]{viewName, view})});
        boolean designDocExists = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 2, this, db, designDocId));
        if (designDocExists) {
            CallSite currentDesignDoc = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 2, this, db, designDocId));
            CallSite mergedDesignDoc = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "merge", 0, CouchDbClient.class, currentDesignDoc, newDesignDoc));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)mergedDesignDoc, (Object)currentDesignDoc)) {
                IndyInterface.bootstrap("invoke", "update", 2, this, db, mergedDesignDoc);
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 2, this, db, designDocId));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "update", 2, this, db, newDesignDoc));
    }

    public boolean contains(String db, String docId) {
        CallSite callSite = IndyInterface.bootstrap("invoke", "sanitizeDocId", 0, CouchDbClient.class, docId);
        docId = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite builder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "head", 0, IndyInterface.bootstrap("invoke", "url", 0, IndyInterface.bootstrap("init", "<init>", 0, Request.Builder.class), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this), IndyInterface.bootstrap("invoke", "toLowerCase", 0, db), docId}, new String[]{"", "/", "/", ""}))));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "header", 0, builder, "Authorization", IndyInterface.bootstrap("invoke", "basic", 0, Credentials.class, this.couchdbUsername, this.couchdbPassword));
            builder = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("invoke", "newCall", 0, this.client, request)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "successful", 0, response)) == false) {
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "code", 0, response), (Object)404)) {
                return false;
            }
            IndyInterface.bootstrap("invoke", "error", 0, log, "error {}", IndyInterface.bootstrap("invoke", "message", 0, response));
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "could not check for doc existence"));
        }
        return true;
    }

    public <R> R get(String db, String docId) {
        CallSite callSite = IndyInterface.bootstrap("invoke", "sanitizeDocId", 0, CouchDbClient.class, docId);
        docId = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite builder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "url", 0, IndyInterface.bootstrap("init", "<init>", 0, Request.Builder.class), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this), IndyInterface.bootstrap("invoke", "toLowerCase", 0, db), docId}, new String[]{"", "/", "/", ""}))));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "header", 0, builder, "Authorization", IndyInterface.bootstrap("invoke", "basic", 0, Credentials.class, this.couchdbUsername, this.couchdbPassword));
            builder = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("invoke", "newCall", 0, this.client, request)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "successful", 0, response)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, log, "error getting document({}): {}/{}", docId, IndyInterface.bootstrap("invoke", "code", 0, response), IndyInterface.bootstrap("invoke", "message", 0, response));
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{docId}, new String[]{"could not get doc with id '", "'"})));
        }
        CallSite doc = IndyInterface.bootstrap("invoke", "consume", 0, this.json, IndyInterface.bootstrap("invoke", "byteStream", 0, IndyInterface.bootstrap("invoke", "body", 0, response)), Map.class);
        return (R)doc;
    }

    public Map delete(String db, String docId, String rev) {
        CallSite callSite = IndyInterface.bootstrap("invoke", "sanitizeDocId", 0, CouchDbClient.class, docId);
        docId = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite builder = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "url", 0, IndyInterface.bootstrap("init", "<init>", 0, Request.Builder.class), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getBaseUrl", 2, this), IndyInterface.bootstrap("invoke", "toLowerCase", 0, db), docId, rev}, new String[]{"", "/", "/", "?rev=", ""}))));
        if (DefaultTypeTransformation.booleanUnbox((Object)this.couchdbUsername) && DefaultTypeTransformation.booleanUnbox((Object)this.couchdbPassword)) {
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "header", 0, builder, "Authorization", IndyInterface.bootstrap("invoke", "basic", 0, Credentials.class, this.couchdbUsername, this.couchdbPassword));
            builder = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        }
        CallSite request = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, builder));
        CallSite response = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, IndyInterface.bootstrap("invoke", "newCall", 0, this.client, request)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "successful", 0, response)) == false) {
            IndyInterface.bootstrap("invoke", "error", 0, log, "error deleting doc{ _id:{}, _rev:{} }: {}/{}", docId, rev, IndyInterface.bootstrap("invoke", "code", 0, response), IndyInterface.bootstrap("invoke", "message", 0, response));
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{docId, rev}, new String[]{"could not delete doc with id/rev '", "'/'", "'"})));
        }
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "consume", 0, this.json, IndyInterface.bootstrap("invoke", "byteStream", 0, IndyInterface.bootstrap("invoke", "body", 0, response)), Map.class));
        return result;
    }

    public static Map merge(Map currentDoc, Map changedDoc) {
        CallSite mergedDoc = IndyInterface.bootstrap("invoke", "plus", 0, currentDoc, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        CallSite callSite = IndyInterface.bootstrap("getProperty", "views", 0, currentDoc);
        Object object = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "views", 0, changedDoc);
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "plus", 0, object, IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)mergedDoc, (String)"views");
        return IndyInterface.bootstrap("cast", "()", 0, mergedDoc);
    }

    public static Object sanitizeDocId(String docId) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, docId, "_")) == false) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "encode", 0, URLEncoder.class, docId, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "UTF_8", 0, StandardCharsets.class)));
            docId = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        return docId;
    }

    public void beforeCreate(Map document) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "dateCreated", 0, document)) == false) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "now", 0, LocalDate.class));
            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)document, (String)"dateCreated");
        }
    }

    public void beforeUpdate(Map document) {
        CallSite callSite = IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "now", 0, LocalDate.class));
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)document, (String)"dateUpdated");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CouchDbClient.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public <R> R query(String db, String viewName, String key) {
        return this.query(db, viewName, key, true);
    }

    @Generated
    public <R> R query(String db, String viewName, Collection<String> keys, boolean includeDocs) {
        Reference includeDocs2 = new Reference((Object)includeDocs);
        return this.query(db, viewName, keys, DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get()), false);
    }

    @Generated
    public <R> R query(String db, String viewName, Collection<String> keys) {
        return this.query(db, viewName, keys, true, false);
    }

    @Generated
    public Object getAllDocs(String db, boolean includeDocs) {
        Reference includeDocs2 = new Reference((Object)includeDocs);
        return this.getAllDocs(db, DefaultTypeTransformation.booleanUnbox((Object)includeDocs2.get()), false);
    }

    @Generated
    public Object getAllDocs(String db) {
        return this.getAllDocs(db, true, false);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, IndyInterface.bootstrap("invoke", "getClass", 0, CouchDbClient.class));
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public OkHttpClient getClient() {
        return this.client;
    }

    @Generated
    public void setClient(OkHttpClient okHttpClient) {
        this.client = okHttpClient;
    }

    @Generated
    public Json getJson() {
        return this.json;
    }

    @Generated
    public void setJson(Json json) {
        this.json = json;
    }

    @Generated
    public boolean getTlsEnabled() {
        return this.tlsEnabled;
    }

    @Generated
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Generated
    public String getCouchdbHost() {
        return this.couchdbHost;
    }

    @Generated
    public int getCouchdbPort() {
        return this.couchdbPort;
    }

    @Generated
    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    @Generated
    public String getCouchdbUsername() {
        return this.couchdbUsername;
    }

    @Generated
    public void setCouchdbUsername(String string) {
        this.couchdbUsername = string;
    }

    @Generated
    public String getCouchdbPassword() {
        return this.couchdbPassword;
    }

    @Generated
    public void setCouchdbPassword(String string) {
        this.couchdbPassword = string;
    }
}

