/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.couchdb;

import de.gesellix.couchdb.ViewQueryResponse;
import de.gesellix.couchdb.ViewQueryResponseRow;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagedViewIterator<T>
implements Iterator<ViewQueryResponse<T>> {
    private static final Logger log = LoggerFactory.getLogger(PagedViewIterator.class);
    private final int pageSize;
    private final BiFunction<String, Integer, ViewQueryResponse<T>> pageProvider;
    String nextPageStartkeyDocId;
    ViewQueryResponse<T> lastResult;

    public PagedViewIterator(int pageSize, BiFunction<String, Integer, ViewQueryResponse<T>> pageProvider) {
        this.pageSize = pageSize;
        this.pageProvider = pageProvider;
        this.nextPageStartkeyDocId = null;
        this.lastResult = null;
    }

    @Override
    public boolean hasNext() {
        if (this.lastResult == null) {
            return true;
        }
        return this.nextPageStartkeyDocId != null;
    }

    @Override
    public ViewQueryResponse<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more pages available");
        }
        ViewQueryResponse<T> fetched = this.fetch();
        return fetched;
    }

    private ViewQueryResponse<T> fetch() {
        this.lastResult = this.pageProvider.apply(this.nextPageStartkeyDocId, this.pageSize + 1);
        if (this.lastResult == null || this.lastResult.getRows() == null) {
            throw new IllegalStateException("failed to fetch more rows. nextPageStartkeyDocId(" + this.nextPageStartkeyDocId + ")");
        }
        log.info("got result, totalRows({}), offset({}), rows({}), startkeyDocId({})", new Object[]{this.lastResult.getTotalRows(), this.lastResult.getOffset(), this.lastResult.getRows().size(), this.nextPageStartkeyDocId});
        if (this.lastResult.getRows().size() == 0 || this.lastResult.getRows().size() >= this.lastResult.getTotalRows() - this.lastResult.getOffset()) {
            this.updateNextPageStartkeyDocId(null);
        } else {
            ViewQueryResponseRow<T> trailingRow = this.lastResult.getRows().remove(this.lastResult.getRows().size() - 1);
            this.updateNextPageStartkeyDocId(trailingRow.getId());
        }
        return this.lastResult;
    }

    private void updateNextPageStartkeyDocId(String nextPageStartkeyDocId) {
        if (Objects.equals(this.nextPageStartkeyDocId, nextPageStartkeyDocId)) {
            int offset = this.lastResult == null || this.lastResult.getOffset() == null ? -1 : this.lastResult.getOffset();
            log.warn("startkeyDocId hasn't changed! previous({}) == next({}), lastResult.offset({})", new Object[]{this.nextPageStartkeyDocId, nextPageStartkeyDocId, offset});
            nextPageStartkeyDocId = null;
        }
        this.nextPageStartkeyDocId = nextPageStartkeyDocId;
    }
}

