/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.couchdb;

import de.gesellix.couchdb.model.NonReducedViewQueryResponse;
import de.gesellix.couchdb.model.RowReference;
import de.gesellix.couchdb.model.ViewQueryResponse;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagedViewIterator<KeyType, Row extends RowReference<KeyType>>
implements Iterator<ViewQueryResponse<KeyType, Row>> {
    private static final Logger log = LoggerFactory.getLogger(PagedViewIterator.class);
    private final int pageSize;
    private final BiFunction<RowReference<KeyType>, Integer, ViewQueryResponse<KeyType, Row>> pageProvider;
    RowReference<KeyType> nextPage;
    ViewQueryResponse<KeyType, Row> lastResult;

    public PagedViewIterator(int pageSize, BiFunction<RowReference<KeyType>, Integer, ViewQueryResponse<KeyType, Row>> pageProvider) {
        this.pageSize = pageSize;
        this.pageProvider = pageProvider;
        this.nextPage = null;
        this.lastResult = null;
    }

    @Override
    public boolean hasNext() {
        if (this.lastResult == null) {
            return true;
        }
        return this.nextPage != null;
    }

    @Override
    public ViewQueryResponse<KeyType, Row> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more pages available");
        }
        ViewQueryResponse<KeyType, Row> fetched = this.fetch();
        return fetched;
    }

    static String rowToString(RowReference<?> row) {
        if (row == null) {
            return "null";
        }
        return String.format("key=%s, docId=%s", row.getKey(), row.getDocId());
    }

    private ViewQueryResponse<KeyType, Row> fetch() {
        this.lastResult = this.pageProvider.apply(this.nextPage, this.pageSize + 1);
        if (this.lastResult == null || this.lastResult.getRows() == null) {
            throw new IllegalStateException("failed to fetch more rows. nextPage(" + PagedViewIterator.rowToString(this.nextPage) + ")");
        }
        if (this.lastResult instanceof NonReducedViewQueryResponse) {
            NonReducedViewQueryResponse nonReducedLastResult = (NonReducedViewQueryResponse)this.lastResult;
            log.info("got result, totalRows({}), offset({}), rows({}), nextPage({})", new Object[]{nonReducedLastResult.getTotalRows(), nonReducedLastResult.getOffset(), this.lastResult.getRows().size(), PagedViewIterator.rowToString(this.nextPage)});
        } else {
            log.info("got result, rows({}), nextPage({})", (Object)this.lastResult.getRows().size(), (Object)PagedViewIterator.rowToString(this.nextPage));
        }
        if (this.lastResult.getRows().size() <= this.pageSize) {
            this.updateNextPage(null);
        } else {
            RowReference trailingRow = (RowReference)this.lastResult.getRows().remove(this.lastResult.getRows().size() - 1);
            this.updateNextPage(trailingRow);
        }
        return this.lastResult;
    }

    private void updateNextPage(RowReference<KeyType> nextPage) {
        if (Objects.equals(this.nextPage, nextPage)) {
            if (this.lastResult instanceof NonReducedViewQueryResponse) {
                NonReducedViewQueryResponse nonReducedLastResult = (NonReducedViewQueryResponse)this.lastResult;
                int offset = nonReducedLastResult.getOffset() == null ? -1 : nonReducedLastResult.getOffset();
                log.info("nextPage hasn't changed: previous({}) == next({}), lastResult.offset({})", new Object[]{PagedViewIterator.rowToString(this.nextPage), PagedViewIterator.rowToString(nextPage), offset});
            } else {
                log.info("nextPage hasn't changed: previous({}) == next({})", (Object)PagedViewIterator.rowToString(this.nextPage), (Object)PagedViewIterator.rowToString(nextPage));
            }
            nextPage = null;
        }
        this.nextPage = nextPage;
    }
}

