/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.compose;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory;
import de.gesellix.docker.compose.ComposeFileReaderKt;
import de.gesellix.docker.compose.adapters.ListToExposeAdapter;
import de.gesellix.docker.compose.adapters.ListToPortConfigsAdapter;
import de.gesellix.docker.compose.adapters.ListToServiceConfigsAdapter;
import de.gesellix.docker.compose.adapters.ListToServiceSecretsAdapter;
import de.gesellix.docker.compose.adapters.ListToServiceVolumesAdapter;
import de.gesellix.docker.compose.adapters.MapOrListToEnvironmentAdapter;
import de.gesellix.docker.compose.adapters.MapOrListToExtraHosts;
import de.gesellix.docker.compose.adapters.MapOrListToLabelAdapter;
import de.gesellix.docker.compose.adapters.MapToDriverOptsAdapter;
import de.gesellix.docker.compose.adapters.MapToExternalAdapter;
import de.gesellix.docker.compose.adapters.StringOrListToCommandAdapter;
import de.gesellix.docker.compose.adapters.StringOrListToEntrypointAdapter;
import de.gesellix.docker.compose.adapters.StringToServiceNetworksAdapter;
import de.gesellix.docker.compose.interpolation.ComposeInterpolator;
import de.gesellix.docker.compose.types.ComposeConfig;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JN\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r2$\u0010\u000e\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\r\u0018\u00010\r2\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rH\u0002JN\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r2$\u0010\u000e\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\r\u0018\u00010\r2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rH\u0002JB\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2$\u0010\u000e\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\r\u0018\u00010\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0002J.\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\rJb\u0010\u0017\u001aV\u0012\u0004\u0012\u00020\u0005\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\r0\r0\u0004j*\u0012\u0004\u0012\u00020\u0005\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\r0\r`\u00062\u0006\u0010\u0013\u001a\u00020\u0014R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/gesellix/docker/compose/ComposeFileReader;", "", "()V", "deprecatedProperties", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "forbiddenProperties", "interpolator", "Lde/gesellix/docker/compose/interpolation/ComposeInterpolator;", "unsupportedProperties", "", "collectDeprecatedServiceProperties", "", "services", "collectForbiddenServiceProperties", "collectUnsupportedServiceProperties", "load", "Lde/gesellix/docker/compose/types/ComposeConfig;", "composeFile", "Ljava/io/InputStream;", "workingDir", "environment", "loadYaml", "docker-compose-v3"})
public final class ComposeFileReader {
    private final List<String> unsupportedProperties = CollectionsKt.listOf((Object[])new String[]{"build", "cap_add", "cap_drop", "cgroup_parent", "devices", "dns", "dns_search", "domainname", "external_links", "ipc", "links", "mac_address", "network_mode", "privileged", "read_only", "restart", "security_opt", "shm_size", "sysctls", "tmpfs", "userns_mode"});
    private final HashMap<String, String> deprecatedProperties;
    private final HashMap<String, String> forbiddenProperties;
    private final ComposeInterpolator interpolator;

    @NotNull
    public final HashMap<String, Map<String, Map<String, Object>>> loadYaml(@NotNull InputStream composeFile) {
        Intrinsics.checkParameterIsNotNull((Object)composeFile, (String)"composeFile");
        Object object = new Yaml().loadAs(composeFile, Map.class);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.collections.Map<kotlin.String, kotlin.collections.Map<kotlin.String, kotlin.Any?>?>>");
        }
        Map composeContent = (Map)object;
        ComposeFileReaderKt.access$getLog$p().info("composeContent: " + composeContent + '}');
        boolean bl = false;
        HashMap<String, Map<String, Map<String, Object>>> hashMap = new HashMap<String, Map<String, Map<String, Object>>>();
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap<String, Map<String, Map<String, Object>>> $this$apply = hashMap;
        boolean bl4 = false;
        $this$apply.putAll(composeContent);
        return hashMap;
    }

    @Nullable
    public final ComposeConfig load(@NotNull InputStream composeFile, @NotNull String workingDir, @NotNull Map<String, String> environment) {
        Map<String, String> deprecatedProperties;
        Map<String, String> forbiddenProperties;
        Intrinsics.checkParameterIsNotNull((Object)composeFile, (String)"composeFile");
        Intrinsics.checkParameterIsNotNull((Object)workingDir, (String)"workingDir");
        Intrinsics.checkParameterIsNotNull(environment, (String)"environment");
        HashMap<String, Map<String, Map<String, Object>>> composeContent = this.loadYaml(composeFile);
        Map<String, String> map = forbiddenProperties = this.collectForbiddenServiceProperties(composeContent.get("services"), (Map<String, String>)this.forbiddenProperties);
        boolean bl = false;
        if (!map.isEmpty()) {
            ComposeFileReaderKt.access$getLog$p().error("Configuration contains forbidden properties: " + forbiddenProperties);
            throw (Throwable)new IllegalStateException("Configuration contains forbidden properties");
        }
        composeContent.putAll(this.interpolator.interpolate((Map<String, ? extends Map<String, ? extends Map<String, ? extends Object>>>)composeContent, environment));
        ComposeConfig cfg = (ComposeConfig)new Moshi.Builder().add((JsonAdapter.Factory)new KotlinJsonAdapterFactory()).add((Object)new ListToExposeAdapter()).add((Object)new ListToPortConfigsAdapter()).add((Object)new ListToServiceSecretsAdapter()).add((Object)new ListToServiceVolumesAdapter()).add((Object)new ListToServiceConfigsAdapter()).add((Object)new MapOrListToEnvironmentAdapter()).add((Object)new MapOrListToExtraHosts()).add((Object)new MapOrListToLabelAdapter()).add((Object)new MapToDriverOptsAdapter()).add((Object)new MapToExternalAdapter()).add((Object)new StringOrListToEntrypointAdapter()).add((Object)new StringOrListToCommandAdapter()).add((Object)new StringToServiceNetworksAdapter()).build().adapter(ComposeConfig.class).fromJsonValue(composeContent);
        List<String> unsupportedProperties = this.collectUnsupportedServiceProperties(composeContent.get("services"), this.unsupportedProperties);
        Collection collection = unsupportedProperties;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            ComposeFileReaderKt.access$getLog$p().warn("Ignoring unsupported options: " + CollectionsKt.joinToString$default((Iterable)unsupportedProperties, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        Map<String, String> map2 = deprecatedProperties = this.collectDeprecatedServiceProperties(composeContent.get("services"), (Map<String, String>)this.deprecatedProperties);
        boolean bl3 = false;
        if (!map2.isEmpty()) {
            ComposeFileReaderKt.access$getLog$p().warn("Ignoring deprecated options: " + deprecatedProperties);
        }
        return cfg;
    }

    public static /* synthetic */ ComposeConfig load$default(ComposeFileReader composeFileReader, InputStream inputStream, String string, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            Map<String, String> map2 = System.getenv();
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"System.getenv()");
            map = map2;
        }
        return composeFileReader.load(inputStream, string, map);
    }

    private final Map<String, String> collectForbiddenServiceProperties(Map<String, ? extends Map<String, ? extends Object>> services, Map<String, String> forbiddenProperties) {
        HashMap hits;
        block0: {
            boolean bl = false;
            hits = new HashMap();
            Map<String, ? extends Map<String, ? extends Object>> map = services;
            if (map == null) break block0;
            map.forEach((BiConsumer<String, ? extends Map<String, ? extends Object>>)new BiConsumer<String, Map<String, ? extends Object>>(forbiddenProperties, hits){
                final /* synthetic */ Map $forbiddenProperties;
                final /* synthetic */ HashMap $hits;

                /*
                 * WARNING - void declaration
                 */
                public final void accept(@NotNull String service, @Nullable Map<String, ? extends Object> serviceConfig) {
                    Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
                    if (serviceConfig != null) {
                        Map $this$forEach$iv = this.$forbiddenProperties;
                        boolean $i$f$forEach = false;
                        Map map = $this$forEach$iv;
                        boolean bl = false;
                        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void property;
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> $dstr$property$description = element$iv = iterator.next();
                            boolean bl2 = false;
                            Map.Entry<K, V> entry = $dstr$property$description;
                            boolean bl3 = false;
                            String string = (String)entry.getKey();
                            entry = $dstr$property$description;
                            bl3 = false;
                            String description = (String)entry.getValue();
                            if (!serviceConfig.containsKey(property)) continue;
                            ((Map)this.$hits).put(service + '.' + (String)property, description);
                        }
                    }
                }
                {
                    this.$forbiddenProperties = map;
                    this.$hits = hashMap;
                }
            });
        }
        return hits;
    }

    private final List<String> collectUnsupportedServiceProperties(Map<String, ? extends Map<String, ? extends Object>> services, List<String> unsupportedProperties) {
        ArrayList hits;
        block0: {
            boolean bl = false;
            hits = new ArrayList();
            Map<String, ? extends Map<String, ? extends Object>> map = services;
            if (map == null) break block0;
            map.forEach((BiConsumer<String, ? extends Map<String, ? extends Object>>)new BiConsumer<String, Map<String, ? extends Object>>(unsupportedProperties, hits){
                final /* synthetic */ List $unsupportedProperties;
                final /* synthetic */ ArrayList $hits;

                public final void accept(@NotNull String service, @Nullable Map<String, ? extends Object> serviceConfig) {
                    Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
                    if (serviceConfig != null) {
                        Iterable $this$forEach$iv = this.$unsupportedProperties;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String property = (String)element$iv;
                            boolean bl = false;
                            if (!serviceConfig.containsKey(property)) continue;
                            this.$hits.add(service + '.' + property);
                        }
                    }
                }
                {
                    this.$unsupportedProperties = list;
                    this.$hits = arrayList;
                }
            });
        }
        return hits;
    }

    private final Map<String, String> collectDeprecatedServiceProperties(Map<String, ? extends Map<String, ? extends Object>> services, Map<String, String> deprecatedProperties) {
        HashMap hits;
        block0: {
            boolean bl = false;
            hits = new HashMap();
            Map<String, ? extends Map<String, ? extends Object>> map = services;
            if (map == null) break block0;
            map.forEach((BiConsumer<String, ? extends Map<String, ? extends Object>>)new BiConsumer<String, Map<String, ? extends Object>>(deprecatedProperties, hits){
                final /* synthetic */ Map $deprecatedProperties;
                final /* synthetic */ HashMap $hits;

                /*
                 * WARNING - void declaration
                 */
                public final void accept(@NotNull String service, @Nullable Map<String, ? extends Object> serviceConfig) {
                    Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
                    if (serviceConfig != null) {
                        Map $this$forEach$iv = this.$deprecatedProperties;
                        boolean $i$f$forEach = false;
                        Map map = $this$forEach$iv;
                        boolean bl = false;
                        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void property;
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> $dstr$property$description = element$iv = iterator.next();
                            boolean bl2 = false;
                            Map.Entry<K, V> entry = $dstr$property$description;
                            boolean bl3 = false;
                            String string = (String)entry.getKey();
                            entry = $dstr$property$description;
                            bl3 = false;
                            String description = (String)entry.getValue();
                            if (!serviceConfig.containsKey(property)) continue;
                            ((Map)this.$hits).put(service + '.' + (String)property, description);
                        }
                    }
                }
                {
                    this.$deprecatedProperties = map;
                    this.$hits = hashMap;
                }
            });
        }
        return hits;
    }

    public ComposeFileReader() {
        HashMap hashMap;
        ComposeFileReader composeFileReader = this;
        boolean bl = false;
        HashMap hashMap2 = hashMap = new HashMap();
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap it = hashMap2;
        boolean bl4 = false;
        ((Map)it).put("container_name", "Setting the container name is not supported.");
        ((Map)it).put("expose", "Exposing ports is unnecessary - services on the same network can access each other's containers on any port.");
        hashMap = it;
        composeFileReader.deprecatedProperties = hashMap;
        composeFileReader = this;
        boolean bl5 = false;
        HashMap hashMap3 = hashMap = new HashMap();
        bl2 = false;
        bl3 = false;
        it = hashMap3;
        boolean bl6 = false;
        ((Map)it).put("extends", "Support for `extends` is not implemented yet.");
        ((Map)it).put("volume_driver", "Instead of setting the volume driver on the service, define a volume using the top-level `volumes` option and specify the driver there.");
        ((Map)it).put("volumes_from", "To share a volume between services, define it using the top-level `volumes` option and reference it from each service that shares it using the service-level `volumes` option.");
        ((Map)it).put("cpu_quota", "Set resource limits using deploy.resources");
        ((Map)it).put("cpu_shares", "Set resource limits using deploy.resources");
        ((Map)it).put("cpuset", "Set resource limits using deploy.resources");
        ((Map)it).put("mem_limit", "Set resource limits using deploy.resources");
        ((Map)it).put("memswap_limit", "Set resource limits using deploy.resources");
        hashMap = it;
        composeFileReader.forbiddenProperties = hashMap;
        this.interpolator = new ComposeInterpolator();
    }
}

