/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.compose.adapters;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.ToJson;
import de.gesellix.docker.compose.adapters.ReflectionUtilKt;
import de.gesellix.docker.compose.adapters.ServiceVolumesType;
import de.gesellix.docker.compose.types.MountPropagation;
import de.gesellix.docker.compose.types.ServiceVolume;
import de.gesellix.docker.compose.types.ServiceVolumeBind;
import de.gesellix.docker.compose.types.ServiceVolumeType;
import de.gesellix.docker.compose.types.ServiceVolumeVolume;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J4\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u001c0\u00142\u0018\b\u0001\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006H\u0007\u00a8\u0006\u001e"}, d2={"Lde/gesellix/docker/compose/adapters/ListToServiceVolumesAdapter;", "", "()V", "fromJson", "Ljava/util/ArrayList;", "Lde/gesellix/docker/compose/types/ServiceVolume;", "Lkotlin/collections/ArrayList;", "reader", "Lcom/squareup/moshi/JsonReader;", "isBindOption", "", "option", "", "isFilePath", "source", "isWindowsDrive", "buf", "c", "", "parseServiceVolumeEntry", "", "populateFieldFromBuffer", "", "char", "buffer", "volume", "populateType", "toJson", "", "volumes", "docker-compose-v3"})
public final class ListToServiceVolumesAdapter {
    @ToJson
    @NotNull
    public final List<Map<String, Object>> toJson(@ServiceVolumesType @NotNull ArrayList<ServiceVolume> volumes) {
        Intrinsics.checkNotNullParameter(volumes, (String)"volumes");
        throw new UnsupportedOperationException();
    }

    @FromJson
    @ServiceVolumesType
    @NotNull
    public final ArrayList<ServiceVolume> fromJson(@NotNull JsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        ArrayList<ServiceVolume> result = new ArrayList<ServiceVolume>();
        JsonReader.Token token = reader.peek();
        if ((token == null ? -1 : WhenMappings.$EnumSwitchMapping$0[token.ordinal()]) == 1) {
            reader.beginArray();
            while (reader.hasNext()) {
                result.addAll((Collection<ServiceVolume>)this.parseServiceVolumeEntry(reader));
            }
            reader.endArray();
        }
        return result;
    }

    private final List<ServiceVolume> parseServiceVolumeEntry(JsonReader reader) {
        JsonReader.Token token = reader.peek();
        switch (token == null ? -1 : WhenMappings.$EnumSwitchMapping$0[token.ordinal()]) {
            case 3: {
                String value = reader.nextString();
                CharSequence charSequence = value;
                if (charSequence == null || charSequence.length() == 0) {
                    throw new IllegalStateException("invalid empty volume spec");
                }
                if (value.length() == 1 || value.length() == 2) {
                    String string = ServiceVolumeType.TypeVolume.getTypeName();
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    return CollectionsKt.listOf((Object)new ServiceVolume(string, null, value, false, null, null, null, 122, null));
                }
                char endOfSpec = '0';
                String spec = value + endOfSpec;
                ServiceVolume volume = new ServiceVolume(null, null, null, false, null, null, null, 127, null);
                String buf = "";
                int n = spec.length();
                for (int i = 0; i < n; ++i) {
                    String string;
                    char c = spec.charAt(i);
                    if (this.isWindowsDrive(buf, c)) {
                        string = buf + c;
                    } else if (c == ':' || c == endOfSpec) {
                        this.populateFieldFromBuffer(c, buf, volume);
                        string = "";
                    } else {
                        string = buf + c;
                    }
                    buf = string;
                }
                this.populateType(volume);
                return CollectionsKt.listOf((Object)volume);
            }
            case 5: {
                reader.beginObject();
                ServiceVolume volume = new ServiceVolume(null, null, null, false, null, null, null, 127, null);
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    JsonReader.Token token2 = reader.peek();
                    switch (token2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[token2.ordinal()]) {
                        case 3: {
                            String value = reader.nextString();
                            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                            ReflectionUtilKt.writePropery(volume, name, value);
                            break;
                        }
                        case 4: {
                            int value = reader.nextInt();
                            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                            ReflectionUtilKt.writePropery(volume, name, value);
                            break;
                        }
                        case 5: {
                            reader.beginObject();
                            ServiceVolumeVolume volumeVolume = new ServiceVolumeVolume(false, 1, null);
                            while (reader.hasNext()) {
                                String name2 = reader.nextName();
                                JsonReader.Token token3 = reader.peek();
                                if ((token3 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[token3.ordinal()]) != 2) continue;
                                boolean value = reader.nextBoolean();
                                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
                                ReflectionUtilKt.writePropery(volumeVolume, name2, value);
                            }
                            reader.endObject();
                            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                            ReflectionUtilKt.writePropery(volume, name, volumeVolume);
                        }
                    }
                }
                reader.endObject();
                this.populateType(volume);
                return CollectionsKt.listOf((Object)volume);
            }
        }
        return CollectionsKt.emptyList();
    }

    private final boolean isWindowsDrive(String buf, char c) {
        return c == ':' && buf.length() == 1 && Character.isLetter(buf.charAt(0));
    }

    private final void populateFieldFromBuffer(char c, String buffer, ServiceVolume volume) {
        if (((CharSequence)buffer).length() == 0) {
            throw new IllegalStateException("empty section between colons");
        }
        if (((CharSequence)volume.getSource()).length() == 0 && c == '0') {
            volume.setTarget(buffer);
            return;
        }
        if (((CharSequence)volume.getSource()).length() == 0) {
            volume.setSource(buffer);
            return;
        }
        if (((CharSequence)volume.getTarget()).length() == 0) {
            volume.setTarget(buffer);
            return;
        }
        if (c == ':') {
            throw new IllegalStateException("too many colons");
        }
        Object object = new char[]{','};
        List options = StringsKt.split$default((CharSequence)buffer, (char[])object, (boolean)false, (int)0, (int)6, null);
        object = options.iterator();
        while (object.hasNext()) {
            String option = (String)object.next();
            if (Intrinsics.areEqual((Object)option, (Object)"ro")) {
                volume.setReadOnly(true);
            }
            if (Intrinsics.areEqual((Object)option, (Object)"rw")) {
                volume.setReadOnly(false);
            }
            if (Intrinsics.areEqual((Object)option, (Object)"nocopy")) {
                volume.setVolume(new ServiceVolumeVolume(true));
            }
            if (!this.isBindOption(option)) continue;
            volume.setBind(new ServiceVolumeBind(option));
        }
    }

    private final boolean isBindOption(String option) {
        MountPropagation mountPropagation;
        block1: {
            MountPropagation[] mountPropagationArray = MountPropagation.values();
            int n = mountPropagationArray.length;
            for (int i = 0; i < n; ++i) {
                MountPropagation mountPropagation2;
                MountPropagation it = mountPropagation2 = mountPropagationArray[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getPropagation(), (Object)option)) continue;
                mountPropagation = mountPropagation2;
                break block1;
            }
            mountPropagation = null;
        }
        return mountPropagation != null;
    }

    private final void populateType(ServiceVolume volume) {
        if (((CharSequence)volume.getType()).length() > 0) {
            return;
        }
        if (((CharSequence)volume.getSource()).length() == 0) {
            volume.setType(ServiceVolumeType.TypeVolume.getTypeName());
        } else if (this.isFilePath(volume.getSource())) {
            volume.setType(ServiceVolumeType.TypeBind.getTypeName());
        } else {
            volume.setType(ServiceVolumeType.TypeVolume.getTypeName());
        }
    }

    private final boolean isFilePath(String source) {
        Object[] objectArray = new Character[]{Character.valueOf('.'), Character.valueOf('/'), Character.valueOf('~')};
        if (CollectionsKt.listOf((Object[])objectArray).contains(Character.valueOf(StringsKt.first((CharSequence)source)))) {
            return true;
        }
        String firstTwoChars = StringsKt.slice((String)source, (IntRange)new IntRange(0, 1));
        return this.isWindowsDrive(String.valueOf(StringsKt.first((CharSequence)firstTwoChars)), StringsKt.last((CharSequence)firstTwoChars));
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonReader.Token.values().length];
            nArray[JsonReader.Token.BEGIN_ARRAY.ordinal()] = 1;
            nArray[JsonReader.Token.BOOLEAN.ordinal()] = 2;
            nArray[JsonReader.Token.STRING.ordinal()] = 3;
            nArray[JsonReader.Token.NUMBER.ordinal()] = 4;
            nArray[JsonReader.Token.BEGIN_OBJECT.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

