/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.compose.adapters;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.ToJson;
import de.gesellix.docker.compose.adapters.PortConfigsType;
import de.gesellix.docker.compose.adapters.ReflectionUtilKt;
import de.gesellix.docker.compose.types.PortConfig;
import de.gesellix.docker.compose.types.PortConfigs;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000f\u001a\u00020\bJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0014\u001a\u00020\bH\u0002J$\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00170\f2\b\b\u0001\u0010\u0018\u001a\u00020\u0004H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u001b"}, d2={"Lde/gesellix/docker/compose/adapters/ListToPortConfigsAdapter;", "", "()V", "fromJson", "Lde/gesellix/docker/compose/types/PortConfigs;", "reader", "Lcom/squareup/moshi/JsonReader;", "newPort", "", "proto", "port", "parsePortConfigEntry", "", "Lde/gesellix/docker/compose/types/PortConfig;", "parsePortDefinition", "portSpec", "parsePortRange", "", "ports", "splitParts", "rawPort", "splitProto", "toJson", "", "portConfigs", "validateProto", "", "docker-compose-v3"})
@SourceDebugExtension(value={"SMAP\nListToPortConfigsAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListToPortConfigsAdapter.kt\nde/gesellix/docker/compose/adapters/ListToPortConfigsAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n1855#2,2:227\n1855#2:229\n1855#2,2:230\n1856#2:232\n*S KotlinDebug\n*F\n+ 1 ListToPortConfigsAdapter.kt\nde/gesellix/docker/compose/adapters/ListToPortConfigsAdapter\n*L\n135#1:227,2\n146#1:229\n147#1:230,2\n146#1:232\n*E\n"})
public final class ListToPortConfigsAdapter {
    @ToJson
    @NotNull
    public final List<Map<String, Object>> toJson(@PortConfigsType @NotNull PortConfigs portConfigs) {
        Intrinsics.checkNotNullParameter((Object)portConfigs, (String)"portConfigs");
        throw new UnsupportedOperationException();
    }

    @FromJson
    @PortConfigsType
    @NotNull
    public final PortConfigs fromJson(@NotNull JsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        ArrayList portConfigs = new ArrayList();
        JsonReader.Token token = reader.peek();
        if ((token == null ? -1 : WhenMappings.$EnumSwitchMapping$0[token.ordinal()]) == 1) {
            reader.beginArray();
            while (reader.hasNext()) {
                portConfigs.addAll(this.parsePortConfigEntry(reader));
            }
            reader.endArray();
        }
        return new PortConfigs(portConfigs);
    }

    @NotNull
    public final List<PortConfig> parsePortConfigEntry(@NotNull JsonReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        JsonReader.Token token = reader.peek();
        switch (token == null ? -1 : WhenMappings.$EnumSwitchMapping$0[token.ordinal()]) {
            case 3: {
                String value = String.valueOf(reader.nextInt());
                return this.parsePortDefinition(value);
            }
            case 2: {
                String value = reader.nextString();
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                return this.parsePortDefinition(value);
            }
            case 4: {
                reader.beginObject();
                PortConfig portConfig = new PortConfig("", 0, 0, "");
                while (reader.hasNext()) {
                    String name = reader.nextName();
                    JsonReader.Token token2 = reader.peek();
                    switch (token2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[token2.ordinal()]) {
                        case 2: {
                            String value = reader.nextString();
                            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                            ReflectionUtilKt.writePropery(portConfig, name, value);
                            break;
                        }
                        case 3: {
                            int value = reader.nextInt();
                            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                            ReflectionUtilKt.writePropery(portConfig, name, value);
                        }
                    }
                }
                reader.endObject();
                return CollectionsKt.listOf((Object)portConfig);
            }
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final List<PortConfig> parsePortDefinition(@NotNull String portSpec) {
        int parsedEnd;
        Intrinsics.checkNotNullParameter((Object)portSpec, (String)"portSpec");
        List<String> list = this.splitParts(portSpec);
        String rawIP = null;
        rawIP = list.get(0);
        String hostPort = null;
        hostPort = list.get(1);
        String containerPort = list.get(2);
        List<String> list2 = this.splitProto(containerPort);
        String proto = list2.get(0);
        String plainContainerPort = list2.get(1);
        if (((CharSequence)plainContainerPort).length() == 0) {
            throw new IllegalStateException("No port specified: '" + portSpec + '\'');
        }
        this.validateProto(proto);
        if (!StringsKt.isBlank((CharSequence)rawIP)) {
            InetAddress address = InetAddress.getByName(rawIP);
            String string = address.getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"address.hostAddress");
            rawIP = string;
        }
        List<Integer> list3 = this.parsePortRange(plainContainerPort);
        int startPort = ((Number)list3.get(0)).intValue();
        int endPort = ((Number)list3.get(1)).intValue();
        Object[] objectArray = new Integer[]{0, 0};
        List list4 = CollectionsKt.listOf((Object[])objectArray);
        int startHostPort = ((Number)list4.get(0)).intValue();
        int endHostPort = ((Number)list4.get(1)).intValue();
        if (((CharSequence)hostPort).length() > 0) {
            List<Integer> list5 = this.parsePortRange(hostPort);
            int parsedStart = ((Number)list5.get(0)).intValue();
            parsedEnd = ((Number)list5.get(1)).intValue();
            if (endPort - startPort != parsedEnd - parsedStart && endPort != startPort) {
                throw new IllegalStateException("Invalid ranges specified for container and host Ports: '" + containerPort + "' and '" + hostPort + '\'');
            }
            startHostPort = parsedStart;
            endHostPort = parsedEnd;
        }
        ArrayList portMappings = new ArrayList();
        int i = 0;
        parsedEnd = endPort - startPort;
        if (i <= parsedEnd) {
            while (true) {
                Iterator mapping;
                containerPort = String.valueOf(startPort + i);
                if (((CharSequence)hostPort).length() > 0) {
                    hostPort = String.valueOf(startHostPort + i);
                }
                if (startPort == endPort && startHostPort != endHostPort) {
                    hostPort = hostPort + '-' + endHostPort;
                }
                String string = proto.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
                String port = this.newPort(string, containerPort);
                HashMap hashMap = new HashMap();
                ArrayList arrayList = portMappings;
                boolean bl = false;
                ((Map)((Object)mapping)).put("port", port);
                Map map = (Map)((Object)mapping);
                String string2 = "binding";
                HashMap binding = new HashMap();
                boolean bl2 = false;
                Map map2 = binding;
                String string3 = proto.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
                map2.put("proto", string3);
                ((Map)binding).put("hostIP", rawIP);
                ((Map)binding).put("hostPort", hostPort);
                HashMap hashMap2 = binding;
                map.put(string2, hashMap2);
                arrayList.add(mapping);
                if (i == parsedEnd) break;
                ++i;
            }
        }
        TreeSet exposedPorts = SetsKt.sortedSetOf((Object[])new String[0]);
        HashMap bindings = new HashMap();
        Iterable $this$forEach$iv = portMappings;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map portMapping = (Map)element$iv;
            boolean bl = false;
            Object v = portMapping.get("port");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            String port = (String)v;
            exposedPorts.add(port);
            if (!bindings.containsKey(port)) {
                ((Map)bindings).put(port, new ArrayList());
            }
            ArrayList arrayList = (ArrayList)bindings.get(port);
            if (arrayList == null) continue;
            Object v2 = portMapping.get("binding");
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            arrayList.add((Map)v2);
        }
        ArrayList<PortConfig> portConfigs = new ArrayList<PortConfig>();
        Iterable $this$forEach$iv2 = exposedPorts;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            ArrayList arrayList;
            String port = (String)element$iv;
            boolean bl = false;
            ArrayList arrayList2 = arrayList = (ArrayList)bindings.get(port);
            if (arrayList2 == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)arrayList2, (String)"bindings[port]");
            Iterable $this$forEach$iv3 = arrayList;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                Map binding = (Map)element$iv2;
                boolean bl3 = false;
                int hostPortAsInt = 0;
                if (!Intrinsics.areEqual(binding.get("hostPort"), (Object)"")) {
                    Object v = binding.get("hostPort");
                    Integer n = v != null && (v = v.toString()) != null ? Integer.valueOf(Integer.parseInt(v)) : null;
                    Intrinsics.checkNotNull(n);
                    hostPortAsInt = n;
                }
                String string = String.valueOf(binding.get("proto"));
                char[] cArray = new char[]{'/'};
                int n = Integer.parseInt((String)StringsKt.split$default((CharSequence)port, (char[])cArray, (boolean)false, (int)0, (int)6, null).get(0));
                int n2 = hostPortAsInt;
                portConfigs.add(new PortConfig("ingress", n, n2, string));
            }
        }
        return portConfigs;
    }

    private final String newPort(String proto, String port) {
        Object[] objectArray = new Integer[]{0, 0};
        List list = CollectionsKt.listOf((Object[])objectArray);
        int portStartInt = ((Number)list.get(0)).intValue();
        int portEndInt = ((Number)list.get(1)).intValue();
        if (((CharSequence)port).length() > 0) {
            List<Integer> list2 = this.parsePortRange(port);
            int parsedStart = ((Number)list2.get(0)).intValue();
            int parsedEnd = ((Number)list2.get(1)).intValue();
            portStartInt = parsedStart;
            portEndInt = parsedEnd;
        }
        if (portStartInt == portEndInt) {
            return "" + portStartInt + '/' + proto;
        }
        return "" + portStartInt + '-' + portEndInt + '/' + proto;
    }

    private final List<Integer> parsePortRange(String ports) {
        if (!StringsKt.contains$default((CharSequence)ports, (char)'-', (boolean)false, (int)2, null)) {
            Object[] objectArray = new Integer[]{Integer.parseInt(ports), Integer.parseInt(ports)};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        char[] cArray = new char[]{'-'};
        List startAndEnd = StringsKt.split$default((CharSequence)ports, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        int start = Integer.parseInt((String)startAndEnd.get(0));
        int end = Integer.parseInt((String)startAndEnd.get(1));
        if (end < start) {
            throw new IllegalStateException("Invalid range specified for the Port '" + ports + '\'');
        }
        Object[] objectArray = new Integer[]{start, end};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void validateProto(String proto) {
        Object[] objectArray = new String[]{"tcp", "udp"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        String string = proto.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
        if (!list.contains(string)) {
            throw new IllegalStateException("Invalid proto '" + proto + '\'');
        }
    }

    private final List<String> splitProto(String rawPort) {
        Object[] objectArray = new char[]{'/'};
        List parts = StringsKt.split$default((CharSequence)rawPort, (char[])objectArray, (boolean)false, (int)0, (int)6, null);
        if (((CharSequence)rawPort).length() == 0 || parts.isEmpty() || ((CharSequence)parts.get(0)).length() == 0) {
            objectArray = new String[2];
            objectArray[0] = (char)"";
            objectArray[1] = (char)"";
            return CollectionsKt.listOf((Object[])objectArray);
        }
        if (parts.size() == 1) {
            objectArray = new String[2];
            objectArray[0] = (char)"tcp";
            objectArray[1] = (char)rawPort;
            return CollectionsKt.listOf((Object[])objectArray);
        }
        if (((CharSequence)parts.get(1)).length() == 0) {
            objectArray = new String[2];
            objectArray[0] = (char)"tcp";
            objectArray[1] = (char)((String)parts.get(0));
            return CollectionsKt.listOf((Object[])objectArray);
        }
        objectArray = new String[2];
        objectArray[0] = (char)((String)parts.get(1));
        objectArray[1] = (char)((String)parts.get(0));
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<String> splitParts(String rawPort) {
        List list;
        char[] cArray = new char[]{':'};
        List parts = StringsKt.split$default((CharSequence)rawPort, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        switch (parts.size()) {
            case 1: {
                Object[] objectArray = new String[]{"", "", (String)parts.get(0)};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case 2: {
                Object[] objectArray = new String[]{"", (String)parts.get(0), (String)parts.get(1)};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case 3: {
                Object[] objectArray = new String[]{(String)parts.get(0), (String)parts.get(1), (String)parts.get(2)};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            default: {
                Object[] objectArray = new String[]{CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)parts, (int)(parts.size() - 2)), (CharSequence)":", null, null, (int)0, null, null, (int)62, null), (String)parts.get(parts.size() - 2), String.valueOf(parts.size() - 1)};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
        }
        return list;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonReader.Token.values().length];
            try {
                nArray[JsonReader.Token.BEGIN_ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonReader.Token.STRING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonReader.Token.NUMBER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonReader.Token.BEGIN_OBJECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

