/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.engine;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import de.gesellix.docker.client.filesocket.NamedPipeSocket;
import de.gesellix.docker.client.filesocket.NamedPipeSocketFactory;
import de.gesellix.docker.client.filesocket.UnixSocket;
import de.gesellix.docker.client.filesocket.UnixSocketFactory;
import de.gesellix.docker.client.filesocket.UnixSocketFactorySupport;
import de.gesellix.docker.engine.AttachConfig;
import de.gesellix.docker.engine.ConnectionProvider;
import de.gesellix.docker.engine.DockerClientConfig;
import de.gesellix.docker.engine.EngineClient;
import de.gesellix.docker.engine.EngineResponse;
import de.gesellix.docker.engine.EngineResponseStatus;
import de.gesellix.docker.engine.OkResponseCallback;
import de.gesellix.docker.json.CustomObjectAdapterFactory;
import de.gesellix.docker.rawstream.RawInputStream;
import de.gesellix.docker.response.JsonContentHandler;
import de.gesellix.docker.ssl.DockerSslSocket;
import de.gesellix.docker.ssl.SslSocketConfigFactory;
import de.gesellix.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dns;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkDockerClient
implements EngineClient {
    private static final Logger log = LoggerFactory.getLogger(OkDockerClient.class);
    private final Map<String, Object> socketFactories = new LinkedHashMap<String, Object>();
    private final DockerClientConfig dockerClientConfig;
    private Proxy proxy;
    private final Moshi moshi;

    public OkDockerClient() {
        this(new DockerClientConfig());
    }

    public OkDockerClient(String dockerHost) {
        this(new DockerClientConfig(dockerHost));
    }

    public OkDockerClient(DockerClientConfig dockerClientConfig) {
        this(dockerClientConfig, Proxy.NO_PROXY);
    }

    public OkDockerClient(DockerClientConfig dockerClientConfig, Proxy proxy) {
        if (new UnixSocketFactorySupport().isSupported()) {
            this.socketFactories.put("unix", new UnixSocketFactory());
        }
        this.socketFactories.put("npipe", new NamedPipeSocketFactory());
        this.socketFactories.put("https", new SslSocketConfigFactory());
        this.dockerClientConfig = dockerClientConfig;
        this.proxy = proxy;
        this.moshi = new Moshi.Builder().add((JsonAdapter.Factory)new CustomObjectAdapterFactory()).build();
    }

    @Override
    public EngineResponse head(Map<String, Object> requestConfig) {
        Map<String, Object> config = this.ensureValidRequestConfig(requestConfig);
        config.put("method", "HEAD");
        return this.request(config);
    }

    @Override
    public EngineResponse get(Map<String, Object> requestConfig) {
        Map<String, Object> config = this.ensureValidRequestConfig(requestConfig);
        config.put("method", "GET");
        return this.request(config);
    }

    @Override
    public EngineResponse put(Map<String, Object> requestConfig) {
        Map<String, Object> config = this.ensureValidRequestConfig(requestConfig);
        config.put("method", "PUT");
        return this.request(config);
    }

    @Override
    public EngineResponse post(Map<String, Object> requestConfig) {
        Map<String, Object> config = this.ensureValidRequestConfig(requestConfig);
        config.put("method", "POST");
        return this.request(config);
    }

    @Override
    public EngineResponse delete(Map<String, Object> requestConfig) {
        Map<String, Object> config = this.ensureValidRequestConfig(requestConfig);
        config.put("method", "DELETE");
        return this.request(config);
    }

    @Override
    public WebSocket webSocket(Map<String, Object> requestConfig, WebSocketListener listener) {
        Map<String, Object> config = this.ensureValidRequestConfig(requestConfig);
        config.put("method", "GET");
        Request.Builder requestBuilder = this.prepareRequest(new Request.Builder(), config);
        Request request = requestBuilder.build();
        int timeout = config.get("timeout") == null ? 0 : (Integer)config.get("timeout");
        OkHttpClient.Builder clientBuilder = this.prepareClient(new OkHttpClient.Builder(), timeout);
        OkHttpClient client = this.newClient(clientBuilder);
        return client.newWebSocket(request, listener);
    }

    public EngineResponse request(Map<String, Object> requestConfig) {
        EngineResponse dockerResponse;
        Map<String, Object> config = this.ensureValidRequestConfig(requestConfig);
        AttachConfig attachConfig = null;
        if (requestConfig.get("attach") != null) {
            HashMap<String, String> headers = (HashMap<String, String>)config.get("headers");
            if (headers == null) {
                headers = new HashMap<String, String>();
            }
            config.put("headers", headers);
            headers.put("Upgrade", "tcp");
            headers.put("Connection", "Upgrade");
            attachConfig = (AttachConfig)requestConfig.get("attach");
        }
        Request.Builder requestBuilder = this.prepareRequest(new Request.Builder(), config);
        Request request = requestBuilder.build();
        int timeout = config.get("timeout") == null ? 0 : (Integer)config.get("timeout");
        OkHttpClient.Builder clientBuilder = this.prepareClient(new OkHttpClient.Builder(), timeout);
        OkResponseCallback responseCallback = null;
        if (attachConfig != null) {
            ConnectionProvider connectionProvider = new ConnectionProvider();
            clientBuilder.addNetworkInterceptor((Interceptor)connectionProvider);
            responseCallback = new OkResponseCallback(connectionProvider, attachConfig);
        }
        OkHttpClient client = this.newClient(clientBuilder);
        log.debug(request.method() + " " + request.url() + " using proxy: " + client.proxy());
        Call call = client.newCall(request);
        if (responseCallback != null) {
            call.enqueue((Callback)responseCallback);
            log.debug("request enqueued");
            EngineResponse dockerResponse2 = new EngineResponse();
            dockerResponse2.setResponseCallback(responseCallback);
            return dockerResponse2;
        }
        try {
            Response response = call.execute();
            log.debug("response: " + response);
            dockerResponse = this.handleResponse(response, config);
            if (dockerResponse.getStream() == null) {
                response.close();
            }
        }
        catch (Exception e) {
            log.error("Request failed", (Throwable)e);
            throw new RuntimeException("Request failed", e);
        }
        return dockerResponse;
    }

    private Request.Builder prepareRequest(Request.Builder builder, Map<String, Object> config) {
        String method = (String)config.get("method");
        String contentType = (String)config.get("requestContentType");
        Map additionalHeaders = (Map)config.get("headers");
        Object body = config.get("body");
        String protocol = this.dockerClientConfig.getScheme();
        String host = this.dockerClientConfig.getHost();
        int port = this.dockerClientConfig.getPort();
        String path = (String)config.get("path");
        if (config.get("apiVersion") != null) {
            path = config.get("apiVersion") + "/" + path;
        }
        String queryAsString = config.get("query") != null ? this.queryToString((Map)config.get("query")) : "";
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().addPathSegments(path);
        if (queryAsString != null && !queryAsString.isEmpty()) {
            urlBuilder = urlBuilder.encodedQuery(queryAsString);
        }
        HttpUrl httpUrl = this.createUrl(urlBuilder, protocol, host, port);
        RequestBody requestBody = this.createRequestBody(method, contentType, body);
        builder.method(method, requestBody).url(httpUrl).cacheControl(CacheControl.FORCE_NETWORK);
        if (additionalHeaders != null) {
            additionalHeaders.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        }
        return builder;
    }

    private OkHttpClient.Builder prepareClient(OkHttpClient.Builder builder, int currentTimeout) {
        String protocol;
        switch (protocol = this.dockerClientConfig.getScheme()) {
            case "unix": {
                if (!this.socketFactories.containsKey(protocol)) {
                    log.error("Unix domain socket not supported, but configured (using defaults?). Please consider changing the DOCKER_HOST environment setting to use tcp.");
                    throw new IllegalStateException("Unix domain socket not supported.");
                }
                UnixSocketFactory unixSocketFactory = (UnixSocketFactory)this.socketFactories.get(protocol);
                builder.socketFactory((SocketFactory)unixSocketFactory).dns((Dns)unixSocketFactory).build();
                break;
            }
            case "npipe": {
                NamedPipeSocketFactory npipeSocketFactory = (NamedPipeSocketFactory)this.socketFactories.get(protocol);
                builder.socketFactory((SocketFactory)npipeSocketFactory).dns((Dns)npipeSocketFactory).build();
                break;
            }
            case "https": {
                String certPath = this.dockerClientConfig.getCertPath();
                SslSocketConfigFactory sslSocketFactory = (SslSocketConfigFactory)this.socketFactories.get(protocol);
                DockerSslSocket dockerSslSocket = sslSocketFactory.createDockerSslSocket(certPath);
                if (dockerSslSocket == null) break;
                builder.sslSocketFactory(dockerSslSocket.getSslSocketFactory(), dockerSslSocket.getTrustManager()).build();
            }
        }
        builder.proxy(this.proxy);
        builder.connectTimeout((long)currentTimeout, TimeUnit.MILLISECONDS).readTimeout((long)currentTimeout, TimeUnit.MILLISECONDS);
        return builder;
    }

    public OkHttpClient newClient(OkHttpClient.Builder clientBuilder) {
        return clientBuilder.build();
    }

    private HttpUrl createUrl(HttpUrl.Builder urlBuilder, String protocol, String host, int port) {
        HttpUrl httpUrl;
        switch (protocol) {
            case "unix": {
                httpUrl = urlBuilder.scheme("http").host(new UnixSocket().encodeHostname(host)).build();
                break;
            }
            case "npipe": {
                httpUrl = urlBuilder.scheme("http").host(new NamedPipeSocket().encodeHostname(host)).build();
                break;
            }
            default: {
                httpUrl = urlBuilder.scheme(protocol).host(host).port(port).build();
            }
        }
        return httpUrl;
    }

    private RequestBody createRequestBody(String method, String contentType, Object body) {
        if (body == null && HttpMethod.requiresRequestBody((String)method)) {
            return RequestBody.create((String)"", (MediaType)MediaType.parse((String)"application/json"));
        }
        RequestBody requestBody = null;
        if (body != null) {
            switch (contentType) {
                case "application/json": {
                    requestBody = RequestBody.create((String)this.moshi.adapter(Map.class).toJson((Object)((Map)body)), (MediaType)MediaType.parse((String)contentType));
                    break;
                }
                default: {
                    Source source = Okio.source((InputStream)((InputStream)body));
                    BufferedSource buffer = Okio.buffer((Source)source);
                    try {
                        requestBody = RequestBody.create((byte[])buffer.readByteArray(), (MediaType)MediaType.parse((String)contentType));
                        break;
                    }
                    catch (IOException e) {
                        log.error("Failed to read request body", (Throwable)e);
                        throw new RuntimeException("Failed to read request body", e);
                    }
                }
            }
        }
        return requestBody;
    }

    public EngineResponse handleResponse(Response httpResponse, Map config) throws IOException {
        EngineResponse response = this.readHeaders(httpResponse);
        if (response.getStatus().getCode() == 204) {
            if (response.getStream() != null) {
                IOUtils.consumeToDevNull(response.getStream());
            }
            return response;
        }
        String mimeType = response.getMimeType();
        if (mimeType == null) {
            mimeType = "";
        }
        switch (mimeType) {
            case "application/vnd.docker.raw-stream": {
                RawInputStream rawStream = new RawInputStream(httpResponse.body().byteStream());
                if (config.get("stdout") != null) {
                    log.debug("redirecting to stdout.");
                    IOUtils.copy(rawStream, (OutputStream)config.get("stdout"));
                    response.setStream(null);
                    break;
                }
                response.setStream(rawStream);
                break;
            }
            case "application/json": {
                if (config.get("async") != null && ((Boolean)config.get("async")).booleanValue()) {
                    this.consumeResponseBody(response, httpResponse.body().source(), config);
                    break;
                }
                Object content = new JsonContentHandler().getContent((Source)httpResponse.body().source());
                this.consumeResponseBody(response, content, config);
                break;
            }
            case "text/html": 
            case "text/plain": {
                InputStream text = httpResponse.body().byteStream();
                this.consumeResponseBody(response, text, config);
                break;
            }
            case "application/octet-stream": {
                InputStream octet = httpResponse.body().byteStream();
                log.debug("passing through via `response.stream`.");
                if (config.get("stdout") != null) {
                    IOUtils.copy(octet, (OutputStream)config.get("stdout"));
                    response.setStream(null);
                    break;
                }
                response.setStream(octet);
                break;
            }
            case "application/x-tar": {
                if (response.getStream() == null) break;
                if (config.get("stdout") != null) {
                    log.debug("redirecting to stdout.");
                    IOUtils.copy(response.getStream(), (OutputStream)config.get("stdout"));
                    response.setStream(null);
                    break;
                }
                log.info(response.getMimeType() + " stream won't be consumed, but is available in the response.");
                break;
            }
            default: {
                log.debug("unexpected mime type '" + response.getMimeType() + "'.");
                ResponseBody body = httpResponse.body();
                if (body.contentLength() == -1L) {
                    InputStream stream = body.byteStream();
                    log.debug("passing through via `response.stream`.");
                    if (config.get("stdout") != null) {
                        IOUtils.copy(stream, (OutputStream)config.get("stdout"));
                        response.setStream(null);
                        break;
                    }
                    response.setStream(stream);
                    break;
                }
                log.debug("passing through via `response.content`.");
                response.setContent(body.string());
                response.setStream(null);
            }
        }
        return response;
    }

    private EngineResponse readHeaders(Response httpResponse) {
        EngineResponse dockerResponse = new EngineResponse();
        EngineResponseStatus status = new EngineResponseStatus();
        status.setText(httpResponse.message());
        status.setCode(httpResponse.code());
        status.setSuccess(httpResponse.isSuccessful());
        dockerResponse.setStatus(status);
        log.debug("status: " + dockerResponse.getStatus());
        Headers headers = httpResponse.headers();
        log.debug("headers: \n" + headers);
        dockerResponse.setHeaders(headers);
        String contentType = headers.get("content-type");
        dockerResponse.setContentType(contentType);
        String contentLength = headers.get("content-length");
        if (contentLength == null) {
            contentLength = "-1";
        }
        dockerResponse.setContentLength(contentLength);
        String mimeType = this.getMimeType(contentType);
        dockerResponse.setMimeType(mimeType);
        if (dockerResponse.getStatus().getSuccess()) {
            dockerResponse.setStream(httpResponse.body().byteStream());
        } else {
            dockerResponse.setStream(null);
        }
        return dockerResponse;
    }

    private void consumeResponseBody(EngineResponse response, Object content, Map config) throws IOException {
        if (content instanceof Source) {
            if (config.get("async") != null && ((Boolean)config.get("async")).booleanValue()) {
                response.setStream(Okio.buffer((Source)((Source)content)).inputStream());
            } else if (config.get("stdout") != null) {
                response.setStream(null);
                Okio.buffer((Sink)Okio.sink((OutputStream)((OutputStream)config.get("stdout")))).writeAll((Source)content);
            } else if (response.getContentLength() != null && Integer.parseInt(response.getContentLength()) >= 0) {
                response.setStream(null);
                response.setContent(Okio.buffer((Source)((Source)content)).readUtf8());
            } else {
                response.setStream(Okio.buffer((Source)((Source)content)).inputStream());
            }
        } else if (content instanceof InputStream) {
            if (config.get("async") != null && ((Boolean)config.get("async")).booleanValue()) {
                response.setStream((InputStream)content);
            } else if (config.get("stdout") != null) {
                IOUtils.copy((InputStream)content, (OutputStream)config.get("stdout"));
                response.setStream(null);
            } else if (response.getContentLength() != null && Integer.parseInt(response.getContentLength()) >= 0) {
                response.setContent(IOUtils.toString((InputStream)content));
                response.setStream(null);
            } else {
                response.setStream((InputStream)content);
            }
        } else {
            response.setContent(content);
            response.setStream(null);
        }
    }

    private Map<String, Object> ensureValidRequestConfig(Map<String, Object> config) {
        if (config == null || config.get("path") == null) {
            log.error("bad request config: " + config);
            throw new IllegalArgumentException("bad request config");
        }
        if (((String)config.get("path")).startsWith("/")) {
            config.put("path", ((String)config.get("path")).substring("/".length()));
        }
        return config;
    }

    public String queryToString(Map<String, Object> queryParameters) {
        if (queryParameters == null || queryParameters.isEmpty()) {
            return "";
        }
        return queryParameters.entrySet().stream().map(e -> {
            String key = (String)e.getKey();
            Object value = e.getValue();
            if (value instanceof String[]) {
                return Arrays.stream((String[])value).map(s -> this.asUrlEncodedQuery(key, (String)s)).collect(Collectors.joining("&"));
            }
            if (value instanceof Collection) {
                return ((Collection)value).stream().map(s -> this.asUrlEncodedQuery(key, (String)s)).collect(Collectors.joining("&"));
            }
            if (value != null) {
                return this.asUrlEncodedQuery(key, value.toString());
            }
            return this.asUrlEncodedQuery(key, "");
        }).collect(Collectors.joining("&"));
    }

    private String asUrlEncodedQuery(String key, String value) {
        try {
            return URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Url encoding failed for key=" + key + ",value=" + value, (Throwable)e);
            throw new RuntimeException("Url encoding failed", e);
        }
    }

    public String getMimeType(String contentTypeHeader) {
        if (contentTypeHeader == null) {
            return null;
        }
        return contentTypeHeader.replace(" ", "").split(";")[0];
    }

    public String getCharset(String contentTypeHeader) {
        String charset = "utf-8";
        Matcher matcher = Pattern.compile("[^;]+;\\s*charset=([^;]+)(;[^;]*)*").matcher(contentTypeHeader);
        if (matcher.find()) {
            charset = matcher.group(1);
        }
        return charset;
    }

    Map<String, Object> getSocketFactories() {
        return this.socketFactories;
    }

    DockerClientConfig getDockerClientConfig() {
        return this.dockerClientConfig;
    }

    void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

