/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.response;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.Moshi;
import de.gesellix.docker.json.CustomObjectAdapterFactory;
import de.gesellix.docker.response.Reader;
import java.io.IOException;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public class JsonChunksReader
implements Reader {
    private final JsonReader reader;
    private final Moshi moshi = new Moshi.Builder().add((JsonAdapter.Factory)new CustomObjectAdapterFactory()).build();

    public JsonChunksReader(Source source) {
        this.reader = JsonReader.of((BufferedSource)Okio.buffer((Source)source));
        this.reader.setLenient(true);
    }

    @Override
    public Object readNext() throws IOException {
        return this.moshi.adapter(Object.class).fromJson(this.reader);
    }

    @Override
    public boolean hasNext() throws IOException {
        return !Thread.currentThread().isInterrupted() && this.reader.hasNext();
    }
}

