/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class IOUtils {
    public static long consumeToDevNull(InputStream source) throws IOException {
        return IOUtils.copy(Okio.source((InputStream)source), Okio.blackhole());
    }

    public static long copy(InputStream source, OutputStream sink) throws IOException {
        return IOUtils.copy(Okio.source((InputStream)source), Okio.sink((OutputStream)sink));
    }

    public static long copy(Source source, Sink sink) throws IOException {
        BufferedSink buffer = Okio.buffer((Sink)sink);
        long count = buffer.writeAll(source);
        buffer.flush();
        return count;
    }

    public static String toString(InputStream source) throws IOException {
        return Okio.buffer((Source)Okio.source((InputStream)source)).readUtf8();
    }

    public static void closeQuietly(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuietly(Source source) {
        try {
            if (source != null) {
                source.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

