/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.engine;

import java.io.IOException;
import java.net.Socket;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Response;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionProvider
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ConnectionProvider.class);
    private Sink sink = null;
    private Source source = null;

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Connection connection = chain.connection();
        if (connection == null) {
            throw new IllegalStateException("Connection is null. This one should only be used as a network interceptor, not as application interceptor.");
        }
        if (this.source != null) {
            log.warn("overwriting source");
        }
        this.source = Okio.source((Socket)connection.socket());
        if (this.sink != null) {
            log.warn("overwriting sink");
        }
        this.sink = Okio.sink((Socket)connection.socket());
        return chain.proceed(chain.request());
    }

    public Sink getSink() {
        return this.sink;
    }

    public Source getSource() {
        return this.source;
    }
}

