/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.engine;

import de.gesellix.docker.engine.AttachConfig;
import de.gesellix.docker.engine.ConnectionProvider;
import de.gesellix.docker.engine.TcpUpgradeVerificator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkResponseCallback
implements Callback {
    private static final Logger log = LoggerFactory.getLogger(OkResponseCallback.class);
    private final ConnectionProvider connectionProvider;
    private final AttachConfig attachConfig;

    public OkResponseCallback(ConnectionProvider connectionProvider, AttachConfig attachConfig) {
        this.connectionProvider = connectionProvider;
        this.attachConfig = attachConfig;
    }

    public void onFailure(@NotNull Call call, @NotNull IOException e) {
        log.error("connection failed: " + e.getMessage(), (Throwable)e);
        this.attachConfig.onFailure(e);
    }

    public void onFailure(Exception e) {
        log.error("error", (Throwable)e);
        this.attachConfig.onFailure(e);
    }

    public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        TcpUpgradeVerificator.ensureTcpUpgrade(response);
        if (this.attachConfig.getStreams().getStdin() != null) {
            Source stdinSource = Okio.source((InputStream)this.attachConfig.getStreams().getStdin());
            Thread writer = new Thread(() -> {
                try {
                    BufferedSink bufferedSink = Okio.buffer((Sink)this.getConnectionProvider().getSink());
                    bufferedSink.writeAll(stdinSource);
                    bufferedSink.flush();
                    this.attachConfig.onSinkWritten(response);
                    CountDownLatch done = new CountDownLatch(1);
                    OkResponseCallback.delayed(100L, "writer", () -> {
                        try {
                            bufferedSink.close();
                            this.attachConfig.onSinkClosed(response);
                        }
                        catch (Exception e) {
                            log.warn("error", (Throwable)e);
                        }
                        return null;
                    }, done);
                    done.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.debug("stdin->sink interrupted", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
                finally {
                    log.trace("writer finished");
                }
            });
            writer.setName("stdin-writer " + call.request().url().encodedPath());
            writer.start();
        } else {
            log.debug("no stdin.");
        }
        if (this.attachConfig.getStreams().getStdout() != null) {
            BufferedSink bufferedStdout = Okio.buffer((Sink)Okio.sink((OutputStream)this.attachConfig.getStreams().getStdout()));
            Thread reader = new Thread(() -> {
                try {
                    bufferedStdout.writeAll(this.getConnectionProvider().getSource());
                    bufferedStdout.flush();
                    CountDownLatch done = new CountDownLatch(1);
                    OkResponseCallback.delayed(100L, "reader", () -> {
                        this.attachConfig.onSourceConsumed();
                        return null;
                    }, done);
                    done.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.debug("source->stdout interrupted", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
                finally {
                    log.trace("reader finished");
                }
            });
            reader.setName("stdout-reader " + call.request().url().encodedPath());
            reader.start();
        } else {
            log.debug("no stdout.");
        }
        this.attachConfig.onResponse(response);
    }

    public static void delayed(long delay, final String name, final Supplier<?> action, final CountDownLatch done) {
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("Delayed " + name + " action (" + Thread.currentThread().getName() + ")");
                try {
                    action.get();
                }
                finally {
                    done.countDown();
                    this.cancel();
                }
            }
        }, delay);
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }
}

