/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.builder;

import de.gesellix.docker.builder.DockerignoreFileFilter;
import de.gesellix.util.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import okio.Okio;
import okio.Source;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildContextBuilder {
    private static final Logger log = LoggerFactory.getLogger(BuildContextBuilder.class);

    public static void archiveTarFilesRecursively(File base, File targetFile) throws IOException {
        List<File> filenames = new DockerignoreFileFilter(base, new ArrayList<String>(Collections.singletonList(targetFile.getAbsolutePath()))).collectFiles(base);
        log.debug("found {} files in buildContext.", (Object)filenames.size());
        BuildContextBuilder.archiveTarFiles(base, filenames.stream().map(File::getAbsolutePath).collect(Collectors.toList()), targetFile);
    }

    public static void archiveTarFilesRecursively(File base, OutputStream target) throws IOException {
        List<File> filenames = new DockerignoreFileFilter(base, new ArrayList<String>()).collectFiles(base);
        log.debug("found {} files in buildContext.", (Object)filenames.size());
        BuildContextBuilder.archiveTarFiles(base, filenames.stream().map(File::getAbsolutePath).collect(Collectors.toList()), target);
    }

    public static void archiveTarFiles(File base, List<String> filenames, File targetFile) throws IOException {
        BuildContextBuilder.archiveTarFiles(base, filenames, new FileOutputStream(targetFile));
    }

    public static void archiveTarFiles(File base, List<String> filenames, OutputStream target) throws IOException {
        try (TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)new GZIPOutputStream(target));){
            tos.setLongFileMode(2);
            for (String filename : filenames) {
                String relativeFileName = BuildContextBuilder.relativize(base, new File(filename));
                log.debug("adding {} as {}", (Object)filename, (Object)relativeFileName);
                BuildContextBuilder.addAsTarEntry(new File(filename), relativeFileName, tos);
            }
        }
    }

    public static void addAsTarEntry(File file, String relativeFileName, TarArchiveOutputStream tos) throws IOException {
        TarArchiveEntry tarEntry = new TarArchiveEntry(file);
        tarEntry.setName(relativeFileName);
        if (!file.isDirectory() && Files.isExecutable(file.toPath())) {
            tarEntry.setMode(tarEntry.getMode() | 0x1ED);
        }
        tos.putArchiveEntry((ArchiveEntry)tarEntry);
        if (!file.isDirectory()) {
            BuildContextBuilder.copyFile(file, (OutputStream)tos);
        }
        tos.closeArchiveEntry();
    }

    public static String relativize(File base, File absolute) {
        return base.toPath().relativize(absolute.toPath()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyFile(File input, OutputStream output) throws IOException {
        Source source = null;
        try {
            source = Okio.source((File)input);
            long l = IOUtils.copy(source, Okio.sink((OutputStream)output));
            return l;
        }
        finally {
            IOUtils.closeQuietly(source);
        }
    }
}

