/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.engine;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import de.gesellix.docker.client.filesocket.NamedPipeSocket;
import de.gesellix.docker.client.filesocket.NamedPipeSocketFactory;
import de.gesellix.docker.client.filesocket.UnixSocket;
import de.gesellix.docker.client.filesocket.UnixSocketFactory;
import de.gesellix.docker.client.filesocket.UnixSocketFactorySupport;
import de.gesellix.docker.engine.AttachConfig;
import de.gesellix.docker.engine.ConnectionProvider;
import de.gesellix.docker.engine.DockerClientConfig;
import de.gesellix.docker.engine.EngineClient;
import de.gesellix.docker.engine.EngineRequest;
import de.gesellix.docker.engine.EngineResponse;
import de.gesellix.docker.engine.EngineResponseStatus;
import de.gesellix.docker.engine.OkResponseCallback;
import de.gesellix.docker.engine.RequestMethod;
import de.gesellix.docker.json.CustomObjectAdapterFactory;
import de.gesellix.docker.rawstream.RawInputStream;
import de.gesellix.docker.response.JsonContentHandler;
import de.gesellix.docker.ssl.DockerSslSocket;
import de.gesellix.docker.ssl.SslSocketConfigFactory;
import de.gesellix.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dns;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkDockerClient
implements EngineClient {
    private static final Logger log = LoggerFactory.getLogger(OkDockerClient.class);
    private final Map<String, Object> socketFactories = new LinkedHashMap<String, Object>();
    private final DockerClientConfig dockerClientConfig;
    private Proxy proxy;
    private final Moshi moshi;

    public OkDockerClient() {
        this(new DockerClientConfig());
    }

    public OkDockerClient(String dockerHost) {
        this(new DockerClientConfig(dockerHost));
    }

    public OkDockerClient(DockerClientConfig dockerClientConfig) {
        this(dockerClientConfig, Proxy.NO_PROXY);
    }

    public OkDockerClient(DockerClientConfig dockerClientConfig, Proxy proxy) {
        if (new UnixSocketFactorySupport().isSupported()) {
            this.socketFactories.put("unix", new UnixSocketFactory());
        }
        this.socketFactories.put("npipe", new NamedPipeSocketFactory());
        this.socketFactories.put("https", new SslSocketConfigFactory());
        this.dockerClientConfig = dockerClientConfig;
        this.proxy = proxy;
        this.moshi = new Moshi.Builder().add((JsonAdapter.Factory)new CustomObjectAdapterFactory()).build();
    }

    @Override
    public EngineResponse head(Map<String, Object> requestConfig) {
        EngineRequest engineRequest = this.ensureValidRequestConfig(requestConfig, RequestMethod.HEAD);
        return this.request(engineRequest);
    }

    @Override
    public EngineResponse get(Map<String, Object> requestConfig) {
        EngineRequest engineRequest = this.ensureValidRequestConfig(requestConfig, RequestMethod.GET);
        return this.request(engineRequest);
    }

    @Override
    public EngineResponse put(Map<String, Object> requestConfig) {
        EngineRequest engineRequest = this.ensureValidRequestConfig(requestConfig, RequestMethod.PUT);
        return this.request(engineRequest);
    }

    @Override
    public EngineResponse post(Map<String, Object> requestConfig) {
        EngineRequest engineRequest = this.ensureValidRequestConfig(requestConfig, RequestMethod.POST);
        return this.request(engineRequest);
    }

    @Override
    public EngineResponse delete(Map<String, Object> requestConfig) {
        EngineRequest engineRequest = this.ensureValidRequestConfig(requestConfig, RequestMethod.DELETE);
        return this.request(engineRequest);
    }

    @Override
    public WebSocket webSocket(Map<String, Object> requestConfig, WebSocketListener listener) {
        EngineRequest engineRequest = this.ensureValidRequestConfig(requestConfig, RequestMethod.GET);
        Request.Builder requestBuilder = this.prepareRequest(new Request.Builder(), engineRequest);
        Request request = requestBuilder.build();
        OkHttpClient.Builder clientBuilder = this.prepareClient(new OkHttpClient.Builder(), engineRequest.getTimeout());
        OkHttpClient client = this.newClient(clientBuilder);
        return client.newWebSocket(request, listener);
    }

    @Override
    public EngineResponse request(EngineRequest requestConfig) {
        EngineResponse dockerResponse;
        EngineRequest config = this.ensureValidRequestConfig(requestConfig);
        AttachConfig attachConfig = null;
        if (config.getAttach() != null) {
            Map<String, String> headers = config.getHeaders();
            if (headers == null) {
                headers = new HashMap<String, String>();
            }
            config.setHeaders(headers);
            headers.put("Upgrade", "tcp");
            headers.put("Connection", "Upgrade");
            attachConfig = config.getAttach();
        }
        Request.Builder requestBuilder = this.prepareRequest(new Request.Builder(), config);
        Request request = requestBuilder.build();
        OkHttpClient.Builder clientBuilder = this.prepareClient(new OkHttpClient.Builder(), config.getTimeout());
        OkResponseCallback responseCallback = null;
        if (attachConfig != null) {
            ConnectionProvider connectionProvider = new ConnectionProvider();
            clientBuilder.addNetworkInterceptor((Interceptor)connectionProvider);
            responseCallback = new OkResponseCallback(connectionProvider, attachConfig);
        }
        OkHttpClient client = this.newClient(clientBuilder);
        log.debug(request.method() + " " + request.url() + " using proxy: " + client.proxy());
        Call call = client.newCall(request);
        if (responseCallback != null) {
            call.enqueue((Callback)responseCallback);
            log.debug("request enqueued");
            EngineResponse dockerResponse2 = new EngineResponse();
            dockerResponse2.setResponseCallback(responseCallback);
            return dockerResponse2;
        }
        try {
            Response response = call.execute();
            log.debug("response: " + response);
            dockerResponse = this.handleResponse(response, config);
            if (dockerResponse.getStream() == null) {
                response.close();
            }
        }
        catch (Exception e) {
            log.error("Request failed", (Throwable)e);
            throw new RuntimeException("Request failed", e);
        }
        return dockerResponse;
    }

    private Request.Builder prepareRequest(Request.Builder builder, EngineRequest config) {
        String method = config.getMethod().name();
        String contentType = config.getContentType();
        Map<String, String> additionalHeaders = config.getHeaders();
        Object body = config.getBody();
        String protocol = this.dockerClientConfig.getScheme();
        String host = this.dockerClientConfig.getHost();
        int port = this.dockerClientConfig.getPort();
        String path = config.getPath();
        if (config.getApiVersion() != null) {
            path = config.getApiVersion() + "/" + path;
        }
        String queryAsString = config.getQuery() != null ? this.queryToString(config.getQuery()) : "";
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().addPathSegments(path);
        if (queryAsString != null && !queryAsString.isEmpty()) {
            urlBuilder = urlBuilder.encodedQuery(queryAsString);
        }
        HttpUrl httpUrl = this.createUrl(urlBuilder, protocol, host, port);
        RequestBody requestBody = this.createRequestBody(method, contentType, body);
        builder.method(method, requestBody).url(httpUrl).cacheControl(CacheControl.FORCE_NETWORK);
        if (additionalHeaders != null) {
            additionalHeaders.forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        }
        return builder;
    }

    private OkHttpClient.Builder prepareClient(OkHttpClient.Builder builder, int currentTimeout) {
        String protocol;
        switch (protocol = this.dockerClientConfig.getScheme()) {
            case "unix": {
                if (!this.socketFactories.containsKey(protocol)) {
                    log.error("Unix domain socket not supported, but configured (using defaults?). Please consider changing the DOCKER_HOST environment setting to use tcp.");
                    throw new IllegalStateException("Unix domain socket not supported.");
                }
                UnixSocketFactory unixSocketFactory = (UnixSocketFactory)this.socketFactories.get(protocol);
                builder.socketFactory((SocketFactory)unixSocketFactory).dns((Dns)unixSocketFactory).build();
                break;
            }
            case "npipe": {
                NamedPipeSocketFactory npipeSocketFactory = (NamedPipeSocketFactory)this.socketFactories.get(protocol);
                builder.socketFactory((SocketFactory)npipeSocketFactory).dns((Dns)npipeSocketFactory).build();
                break;
            }
            case "https": {
                String certPath = this.dockerClientConfig.getCertPath();
                SslSocketConfigFactory sslSocketFactory = (SslSocketConfigFactory)this.socketFactories.get(protocol);
                DockerSslSocket dockerSslSocket = sslSocketFactory.createDockerSslSocket(certPath);
                if (dockerSslSocket == null) break;
                builder.sslSocketFactory(dockerSslSocket.getSslSocketFactory(), dockerSslSocket.getTrustManager()).build();
            }
        }
        builder.proxy(this.proxy);
        builder.connectTimeout((long)currentTimeout, TimeUnit.MILLISECONDS).readTimeout((long)currentTimeout, TimeUnit.MILLISECONDS);
        return builder;
    }

    public OkHttpClient newClient(OkHttpClient.Builder clientBuilder) {
        return clientBuilder.build();
    }

    private HttpUrl createUrl(HttpUrl.Builder urlBuilder, String protocol, String host, int port) {
        HttpUrl httpUrl;
        switch (protocol) {
            case "unix": {
                httpUrl = urlBuilder.scheme("http").host(new UnixSocket().encodeHostname(host)).build();
                break;
            }
            case "npipe": {
                httpUrl = urlBuilder.scheme("http").host(new NamedPipeSocket().encodeHostname(host)).build();
                break;
            }
            default: {
                httpUrl = urlBuilder.scheme(protocol).host(host).port(port).build();
            }
        }
        return httpUrl;
    }

    private RequestBody createRequestBody(String method, String contentType, Object body) {
        if (body == null && HttpMethod.requiresRequestBody((String)method)) {
            return RequestBody.create((String)"", (MediaType)MediaType.parse((String)"application/json"));
        }
        RequestBody requestBody = null;
        if (body != null) {
            switch (contentType) {
                case "application/json": {
                    requestBody = RequestBody.create((String)this.moshi.adapter(Map.class).toJson((Object)((Map)body)), (MediaType)MediaType.parse((String)contentType));
                    break;
                }
                default: {
                    Source source = Okio.source((InputStream)((InputStream)body));
                    BufferedSource buffer = Okio.buffer((Source)source);
                    try {
                        requestBody = RequestBody.create((byte[])buffer.readByteArray(), (MediaType)MediaType.parse((String)contentType));
                        break;
                    }
                    catch (IOException e) {
                        log.error("Failed to read request body", (Throwable)e);
                        throw new RuntimeException("Failed to read request body", e);
                    }
                }
            }
        }
        return requestBody;
    }

    public EngineResponse handleResponse(Response httpResponse, EngineRequest config) throws IOException {
        EngineResponse response = this.readHeaders(httpResponse);
        if (response.getStatus().getCode() == 204) {
            if (response.getStream() != null) {
                IOUtils.consumeToDevNull(response.getStream());
            }
            return response;
        }
        String mimeType = response.getMimeType();
        if (mimeType == null) {
            mimeType = "";
        }
        switch (mimeType) {
            case "application/vnd.docker.raw-stream": {
                RawInputStream rawStream = new RawInputStream(httpResponse.body().byteStream());
                if (config.getStdout() != null) {
                    log.debug("redirecting to stdout.");
                    IOUtils.copy(rawStream, config.getStdout());
                    response.setStream(null);
                    break;
                }
                response.setStream(rawStream);
                break;
            }
            case "application/json": {
                if (config.isAsync()) {
                    this.consumeResponseBody(response, httpResponse.body().source(), config);
                    break;
                }
                Object content = new JsonContentHandler().getContent((Source)httpResponse.body().source());
                this.consumeResponseBody(response, content, config);
                break;
            }
            case "text/html": 
            case "text/plain": {
                InputStream text = httpResponse.body().byteStream();
                this.consumeResponseBody(response, text, config);
                break;
            }
            case "application/octet-stream": {
                InputStream octet = httpResponse.body().byteStream();
                log.debug("passing through via `response.stream`.");
                if (config.getStdout() != null) {
                    IOUtils.copy(octet, config.getStdout());
                    response.setStream(null);
                    break;
                }
                response.setStream(octet);
                break;
            }
            case "application/x-tar": {
                if (response.getStream() == null) break;
                if (config.getStdout() != null) {
                    log.debug("redirecting to stdout.");
                    IOUtils.copy(response.getStream(), config.getStdout());
                    response.setStream(null);
                    break;
                }
                log.info(response.getMimeType() + " stream won't be consumed, but is available in the response.");
                break;
            }
            default: {
                log.debug("unexpected mime type '" + response.getMimeType() + "'.");
                ResponseBody body = httpResponse.body();
                if (body.contentLength() == -1L) {
                    InputStream stream = body.byteStream();
                    log.debug("passing through via `response.stream`.");
                    if (config.getStdout() != null) {
                        IOUtils.copy(stream, config.getStdout());
                        response.setStream(null);
                        break;
                    }
                    response.setStream(stream);
                    break;
                }
                log.debug("passing through via `response.content`.");
                response.setContent(body.string());
                response.setStream(null);
            }
        }
        return response;
    }

    private EngineResponse readHeaders(Response httpResponse) {
        EngineResponse dockerResponse = new EngineResponse();
        EngineResponseStatus status = new EngineResponseStatus();
        status.setText(httpResponse.message());
        status.setCode(httpResponse.code());
        status.setSuccess(httpResponse.isSuccessful());
        dockerResponse.setStatus(status);
        log.debug("status: " + dockerResponse.getStatus());
        Headers headers = httpResponse.headers();
        log.debug("headers: \n" + headers);
        dockerResponse.setHeaders(headers);
        String contentType = headers.get("content-type");
        dockerResponse.setContentType(contentType);
        String contentLength = headers.get("content-length");
        if (contentLength == null) {
            contentLength = "-1";
        }
        dockerResponse.setContentLength(contentLength);
        String mimeType = this.getMimeType(contentType);
        dockerResponse.setMimeType(mimeType);
        if (dockerResponse.getStatus().getSuccess()) {
            dockerResponse.setStream(httpResponse.body().byteStream());
        } else {
            dockerResponse.setStream(null);
        }
        return dockerResponse;
    }

    private void consumeResponseBody(EngineResponse response, Object content, EngineRequest config) throws IOException {
        if (content instanceof Source) {
            if (config.isAsync()) {
                response.setStream(Okio.buffer((Source)((Source)content)).inputStream());
            } else if (config.getStdout() != null) {
                response.setStream(null);
                Okio.buffer((Sink)Okio.sink((OutputStream)config.getStdout())).writeAll((Source)content);
            } else if (response.getContentLength() != null && Integer.parseInt(response.getContentLength()) >= 0) {
                response.setStream(null);
                response.setContent(Okio.buffer((Source)((Source)content)).readUtf8());
            } else {
                response.setStream(Okio.buffer((Source)((Source)content)).inputStream());
            }
        } else if (content instanceof InputStream) {
            if (config.isAsync()) {
                response.setStream((InputStream)content);
            } else if (config.getStdout() != null) {
                IOUtils.copy((InputStream)content, config.getStdout());
                response.setStream(null);
            } else if (response.getContentLength() != null && Integer.parseInt(response.getContentLength()) >= 0) {
                response.setContent(IOUtils.toString((InputStream)content));
                response.setStream(null);
            } else {
                response.setStream((InputStream)content);
            }
        } else {
            response.setContent(content);
            response.setStream(null);
        }
    }

    @Deprecated
    private EngineRequest ensureValidRequestConfig(Map<String, Object> config, RequestMethod method) {
        if (config == null || config.get("path") == null) {
            log.error("bad request config: " + config);
            throw new IllegalArgumentException("bad request config");
        }
        if (((String)config.get("path")).startsWith("/")) {
            config.put("path", ((String)config.get("path")).substring("/".length()));
        }
        config.put("method", method.name());
        EngineRequest engineRequest = new EngineRequest(method, (String)config.get("path"));
        engineRequest.setTimeout(config.get("timeout") == null ? 0 : (Integer)config.get("timeout"));
        engineRequest.setHeaders((Map)config.get("headers"));
        Map query = (Map)config.get("query");
        engineRequest.setQuery(this.coerceValuesToListOfString(query));
        engineRequest.setContentType((String)config.get("requestContentType"));
        engineRequest.setBody(config.get("body"));
        engineRequest.setAsync(config.get("async") != null && (Boolean)config.get("async") != false);
        engineRequest.setAttach((AttachConfig)config.get("attach"));
        engineRequest.setStdout((OutputStream)config.get("stdout"));
        engineRequest.setApiVersion((String)config.get("apiVersion"));
        return engineRequest;
    }

    private EngineRequest ensureValidRequestConfig(EngineRequest config) {
        if (config == null || config.getPath() == null) {
            log.error("bad request config: " + config);
            throw new IllegalArgumentException("bad request config");
        }
        if (config.getPath().startsWith("/")) {
            config.setPath(config.getPath().substring("/".length()));
        }
        return config;
    }

    private Map<String, List<String>> coerceValuesToListOfString(Map<String, Object> queryParameters) {
        if (queryParameters == null || queryParameters.isEmpty()) {
            return new HashMap<String, List<String>>();
        }
        return queryParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.convert(e.getValue())));
    }

    private List<String> convert(Object value) {
        if (value instanceof String[]) {
            return Arrays.stream((String[])value).collect(Collectors.toList());
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(Object::toString).collect(Collectors.toList());
        }
        if (value != null) {
            return Collections.singletonList(value.toString());
        }
        return Collections.singletonList("");
    }

    public String queryToString(Map<String, List<String>> queryParameters) {
        if (queryParameters == null || queryParameters.isEmpty()) {
            return "";
        }
        return queryParameters.entrySet().stream().map(e -> {
            String key = (String)e.getKey();
            List value = (List)e.getValue();
            if (value != null) {
                return value.stream().map(s -> this.asUrlEncodedQuery(key, (String)s)).collect(Collectors.joining("&"));
            }
            return this.asUrlEncodedQuery(key, "");
        }).collect(Collectors.joining("&"));
    }

    private String asUrlEncodedQuery(String key, String value) {
        try {
            return URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Url encoding failed for key=" + key + ",value=" + value, (Throwable)e);
            throw new RuntimeException("Url encoding failed", e);
        }
    }

    public String getMimeType(String contentTypeHeader) {
        if (contentTypeHeader == null) {
            return null;
        }
        return contentTypeHeader.replace(" ", "").split(";")[0];
    }

    public String getCharset(String contentTypeHeader) {
        String charset = "utf-8";
        Matcher matcher = Pattern.compile("[^;]+;\\s*charset=([^;]+)(;[^;]*)*").matcher(contentTypeHeader);
        if (matcher.find()) {
            charset = matcher.group(1);
        }
        return charset;
    }

    Map<String, Object> getSocketFactories() {
        return this.socketFactories;
    }

    DockerClientConfig getDockerClientConfig() {
        return this.dockerClientConfig;
    }

    void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }
}

