/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.engine;

import java.io.File;

public class DockerEnv {
    private String dockerHost;
    private int defaultTlsPort = 2376;
    private String tlsVerify = System.getProperty("docker.tls.verify", System.getenv("DOCKER_TLS_VERIFY"));
    private String certPath = System.getProperty("docker.cert.path", System.getenv("DOCKER_CERT_PATH"));
    private String defaultCertPath = new File((String)System.getProperties().get("user.home"), ".docker").getAbsolutePath();
    private final String indexUrl_v1 = "https://index.docker.io/v1/";
    private final String indexUrl_v2 = "https://registry-1.docker.io";
    private File configFile = new File(System.getProperty("user.home") + "/.docker", "config.json");
    private File legacyConfigFile = new File(System.getProperty("user.home"), ".dockercfg");
    private File dockerConfigFile = null;
    private String apiVersion = System.getProperty("docker.api.version", System.getenv("DOCKER_API_VERSION"));
    private String tmpdir = System.getProperty("docker.tmpdir", System.getenv("DOCKER_TMPDIR"));
    private String dockerContentTrust = System.getProperty("docker.content.trust", System.getenv("DOCKER_CONTENT_TRUST"));
    private String contentTrustServer = System.getProperty("docker.content.trust.server", System.getenv("DOCKER_CONTENT_TRUST_SERVER"));
    private String officialNotaryServer = "https://notary.docker.io";

    public DockerEnv() {
        this(DockerEnv.getDockerHostOrDefault());
    }

    public DockerEnv(String dockerHost) {
        this.dockerHost = dockerHost;
    }

    public static String getDockerHostOrDefault() {
        String configuredDockerHost = System.getProperty("docker.host", System.getenv("DOCKER_HOST"));
        if (configuredDockerHost != null && !configuredDockerHost.isEmpty()) {
            return configuredDockerHost;
        }
        if (((String)System.getProperties().get("os.name")).toLowerCase().contains("windows")) {
            return "npipe:////./pipe/docker_engine";
        }
        return "unix:///var/run/docker.sock";
    }

    public void setDockerConfigFile(File dockerConfigFile) {
        this.dockerConfigFile = dockerConfigFile;
    }

    public File getDockerConfigFile() {
        if (this.dockerConfigFile == null) {
            String dockerConfig = System.getProperty("docker.config", System.getenv("DOCKER_CONFIG"));
            if (dockerConfig != null && !dockerConfig.isEmpty()) {
                this.dockerConfigFile = new File(dockerConfig, "config.json");
            } else if (this.configFile.exists()) {
                this.dockerConfigFile = this.configFile;
            } else if (this.legacyConfigFile.exists()) {
                this.dockerConfigFile = this.legacyConfigFile;
            }
        }
        return this.dockerConfigFile;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    public void setDockerHost(String dockerHost) {
        this.dockerHost = dockerHost;
    }

    public int getDefaultTlsPort() {
        return this.defaultTlsPort;
    }

    public void setDefaultTlsPort(int defaultTlsPort) {
        this.defaultTlsPort = defaultTlsPort;
    }

    public String getTlsVerify() {
        return this.tlsVerify;
    }

    public void setTlsVerify(String tlsVerify) {
        this.tlsVerify = tlsVerify;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getDefaultCertPath() {
        return this.defaultCertPath;
    }

    public void setDefaultCertPath(String defaultCertPath) {
        this.defaultCertPath = defaultCertPath;
    }

    public String getIndexUrl_v1() {
        return "https://index.docker.io/v1/";
    }

    public String getIndexUrl_v2() {
        return "https://registry-1.docker.io";
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public File getLegacyConfigFile() {
        return this.legacyConfigFile;
    }

    public void setLegacyConfigFile(File legacyConfigFile) {
        this.legacyConfigFile = legacyConfigFile;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getTmpdir() {
        return this.tmpdir;
    }

    public void setTmpdir(String tmpdir) {
        this.tmpdir = tmpdir;
    }

    public String getDockerContentTrust() {
        return this.dockerContentTrust;
    }

    public void setDockerContentTrust(String dockerContentTrust) {
        this.dockerContentTrust = dockerContentTrust;
    }

    public String getContentTrustServer() {
        return this.contentTrustServer;
    }

    public void setContentTrustServer(String contentTrustServer) {
        this.contentTrustServer = contentTrustServer;
    }

    public String getOfficialNotaryServer() {
        return this.officialNotaryServer;
    }

    public void setOfficialNotaryServer(String officialNotaryServer) {
        this.officialNotaryServer = officialNotaryServer;
    }
}

