/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.authentication;

import de.gesellix.docker.authentication.AuthConfig;
import de.gesellix.docker.authentication.CredsStore;
import de.gesellix.docker.authentication.CredsStoreHelper;
import de.gesellix.docker.authentication.CredsStoreHelperResult;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeStore
implements CredsStore {
    private static final Logger log = LoggerFactory.getLogger(NativeStore.class);
    private final String credStoreName;
    CredsStoreHelper credsStoreHelper;

    public NativeStore(String credStoreName) {
        this.credStoreName = credStoreName;
        this.credsStoreHelper = new CredsStoreHelper();
    }

    @Override
    public AuthConfig getAuthConfig(String registry) {
        CredsStoreHelperResult creds = this.credsStoreHelper.getAuthentication(this.credStoreName, registry);
        if (creds.getError() != null && !creds.getError().trim().isEmpty()) {
            log.info("Error reading credentials from 'credsStore={}' for authentication at {}: {}", new Object[]{this.credStoreName, registry, creds.getError()});
            return AuthConfig.EMPTY_AUTH_CONFIG;
        }
        if (creds.getData() != null && !creds.getData().isEmpty()) {
            log.info("Got credentials from 'credsStore={}'", (Object)this.credStoreName);
            AuthConfig result = this.parseCreds(creds.getData());
            result.setServeraddress(registry);
            return result;
        }
        log.warn("Using 'credsStore={}' for authentication at {} is currently not supported", (Object)this.credStoreName, (Object)registry);
        return AuthConfig.EMPTY_AUTH_CONFIG;
    }

    @Override
    public Map<String, AuthConfig> getAuthConfigs() {
        HashMap<String, AuthConfig> result = new HashMap<String, AuthConfig>();
        CredsStoreHelperResult creds = this.credsStoreHelper.getAllAuthentications(this.credStoreName);
        if (creds.getError() != null && !creds.getError().trim().isEmpty()) {
            log.info("Error reading credentials from 'credsStore={}': {}", (Object)this.credStoreName, (Object)creds.getError());
            return result;
        }
        if (creds.getData() != null && !creds.getData().isEmpty()) {
            log.info("Got credentials from 'credsStore={}'", (Object)this.credStoreName);
            return creds.getData().keySet().stream().collect(Collectors.toMap(k -> k, this::getAuthConfig));
        }
        log.warn("Using 'credsStore={}' is currently not supported", (Object)this.credStoreName);
        return result;
    }

    private AuthConfig parseCreds(Map<String, Object> creds) {
        AuthConfig authDetails;
        if ("<token>".equals(creds.get("Username"))) {
            authDetails = new AuthConfig();
            authDetails.setIdentitytoken((String)creds.get("Secret"));
        } else {
            authDetails = new AuthConfig();
            authDetails.setUsername((String)creds.get("Username"));
            authDetails.setPassword((String)creds.get("Secret"));
        }
        return authDetails;
    }
}

