/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.engine;

import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamingRequestBody
extends RequestBody {
    private final MediaType contentType;
    private final Source body;

    public StreamingRequestBody(MediaType contentType, Source body) {
        this.contentType = contentType;
        this.body = body;
    }

    @Nullable
    public MediaType contentType() {
        return this.contentType;
    }

    public long contentLength() {
        return -1L;
    }

    public boolean isOneShot() {
        return true;
    }

    public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
        Exception exception = null;
        try {
            bufferedSink.writeAll(this.body);
        }
        catch (Exception e) {
            exception = e;
            throw e;
        }
        finally {
            if (exception == null) {
                this.body.close();
            } else {
                try {
                    this.body.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

