/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.authentication;

import de.gesellix.docker.authentication.AuthConfig;
import de.gesellix.docker.authentication.CredsStore;
import java.util.Base64;
import java.util.Map;
import java.util.stream.Collectors;

public class FileStore
implements CredsStore {
    private final Map<String, Map> config;
    private transient Map<String, AuthConfig> allAuthConfigs;

    public FileStore(Map<String, Map> config) {
        this.config = config.containsKey("auths") ? config.get("auths") : config;
    }

    @Override
    public AuthConfig getAuthConfig(String registry) {
        AuthConfig authConfig = this.getAuthConfigs().get(registry);
        return authConfig != null ? authConfig : AuthConfig.EMPTY_AUTH_CONFIG;
    }

    @Override
    public Map<String, AuthConfig> getAuthConfigs() {
        if (this.allAuthConfigs == null) {
            this.allAuthConfigs = this.config.entrySet().stream().filter(e -> e.getValue() != null && (((Map)e.getValue()).get("auth") != null || ((Map)e.getValue()).containsKey("identitytoken"))).collect(Collectors.toMap(Map.Entry::getKey, e -> {
                String registry = (String)e.getKey();
                Map value = (Map)e.getValue();
                AuthConfig authConfig = new AuthConfig();
                authConfig.setServeraddress(registry);
                if (value.containsKey("identitytoken")) {
                    authConfig.setIdentitytoken((String)value.get("identitytoken"));
                } else {
                    String[] login = new String(Base64.getDecoder().decode((String)value.get("auth"))).split(":");
                    String username = login[0];
                    String password = login[1];
                    authConfig.setUsername(username);
                    authConfig.setPassword(password);
                    authConfig.setEmail((String)value.get("email"));
                }
                return authConfig;
            }));
        }
        return this.allAuthConfigs;
    }
}

