/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class DockerVersion
implements Comparable<DockerVersion> {
    private int major;
    private int minor;
    private int patch;
    private String meta;

    public static DockerVersion parseDockerVersion(String version) {
        Pattern versionPattern = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\d+)(.*))?");
        DockerVersion parsedVersion = new DockerVersion();
        Matcher matcher = versionPattern.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Version does not match the expected version pattern: '%s'", version));
        }
        parsedVersion.setMajor(Integer.parseInt(matcher.group(1)));
        parsedVersion.setMinor(Integer.parseInt(matcher.group(2)));
        String s = matcher.group(3);
        parsedVersion.setPatch(Integer.parseInt(s != null && !s.isEmpty() ? s : "0"));
        String s1 = matcher.group(4);
        parsedVersion.setMeta(s1 != null && !s1.isEmpty() ? s1 : "");
        return parsedVersion;
    }

    public String toString() {
        return this.getMajor() + "." + this.getMinor() + "." + this.getPatch() + this.getMeta();
    }

    @Override
    public int compareTo(DockerVersion other) {
        ArrayList<Integer> self = new ArrayList<Integer>(Arrays.asList(this.major, this.minor, this.patch));
        ArrayList<Integer> that = new ArrayList<Integer>(Arrays.asList(other.getMajor(), other.getMinor(), other.getPatch()));
        AtomicInteger result = new AtomicInteger(0);
        IntStream.range(0, 2).forEach(index -> {
            int compared = ((Integer)self.get(index)).compareTo((Integer)that.get(index));
            if (compared != 0 && result.get() == 0) {
                result.set(compared);
            }
        });
        return result.get();
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public void setPatch(int patch) {
        this.patch = patch;
    }

    public String getMeta() {
        return this.meta;
    }

    public void setMeta(String meta) {
        this.meta = meta;
    }
}

