/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.rawstream;

import java.nio.charset.StandardCharsets;

public class Frame {
    private final StreamType streamType;
    private final byte[] payload;

    public Frame(StreamType streamType, byte[] payload) {
        this.streamType = streamType;
        this.payload = payload;
    }

    public StreamType getStreamType() {
        return this.streamType;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getPayloadAsString() {
        if (this.payload == null) {
            return null;
        }
        return new String(this.payload, StandardCharsets.UTF_8).trim();
    }

    public String toString() {
        return "Frame{streamType=" + (Object)((Object)this.streamType) + ", payload=" + this.getPayloadAsString() + '}';
    }

    public static enum StreamType {
        RAW((byte)-1),
        STDIN((byte)0),
        STDOUT((byte)1),
        STDERR((byte)2),
        SYSTEMERR((byte)3);

        private final byte streamTypeId;

        private StreamType(Object streamTypeId) {
            this.streamTypeId = (Byte)streamTypeId;
        }

        public static StreamType valueOf(byte b) {
            switch (b) {
                case 0: {
                    return STDIN;
                }
                case 1: {
                    return STDOUT;
                }
                case 2: {
                    return STDERR;
                }
                case 3: {
                    return SYSTEMERR;
                }
            }
            throw new IllegalArgumentException("no enum value for " + String.valueOf(b) + " found.");
        }

        public byte getStreamTypeId() {
            return this.streamTypeId;
        }
    }
}

