/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.builder;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobsMatcher {
    private static final Logger log = LoggerFactory.getLogger(GlobsMatcher.class);
    private final File base;
    private final List<String> globs;
    private List<Matcher> matchers;

    public GlobsMatcher(File base, List<String> globs) {
        this.base = base;
        this.globs = globs;
    }

    public void initMatchers() {
        if (this.matchers == null) {
            FileSystem fileSystem = FileSystems.getDefault();
            this.matchers = new ArrayList<Matcher>();
            this.globs.stream().flatMap(glob -> {
                if (glob.endsWith("/")) {
                    return Stream.of(new Matcher(fileSystem, glob.replaceAll("/$", "")), new Matcher(fileSystem, glob.replaceAll("/$", "/**")));
                }
                return Stream.of(new Matcher(fileSystem, (String)glob));
            }).collect(Collectors.toCollection(ArrayDeque::new)).descendingIterator().forEachRemaining(this.matchers::add);
            if (log.isDebugEnabled()) {
                this.matchers.forEach(m -> log.debug("pattern: " + m.getPattern()));
            }
        }
    }

    public boolean matches(File path) {
        this.initMatchers();
        Path relativePath = this.base.getAbsoluteFile().toPath().relativize(path.getAbsoluteFile().toPath());
        Optional<Matcher> matcher = this.matchers.stream().filter(m -> m.matches(relativePath)).findFirst();
        if (!matcher.isPresent() && relativePath.getParent() != null) {
            matcher = this.matchers.stream().filter(m -> m.matches(relativePath.getParent())).findFirst();
        }
        return matcher.isPresent() && !matcher.get().getNegate();
    }

    public List<Matcher> getMatchers() {
        return this.matchers;
    }

    public static class Matcher
    implements PathMatcher {
        private final String pattern;
        private final PathMatcher matcher;
        private final boolean negate;

        public Matcher(FileSystem fileSystem, String pattern) {
            String replacement = File.separatorChar == '\\' ? "\\\\" : File.separatorChar + "";
            this.pattern = String.join((CharSequence)replacement, pattern.replaceAll("/", replacement).split(replacement));
            String negation = "!";
            this.negate = pattern.startsWith(negation);
            if (this.negate) {
                String invertedPattern = this.pattern.substring(negation.length());
                this.matcher = Matcher.createGlob(fileSystem, invertedPattern);
            } else {
                this.matcher = Matcher.createGlob(fileSystem, this.pattern);
            }
        }

        public static PathMatcher createGlob(FileSystem fileSystem, String glob) {
            return fileSystem.getPathMatcher("glob:" + glob);
        }

        @Override
        public boolean matches(Path path) {
            return this.matcher.matches(path);
        }

        public String getPattern() {
            return this.pattern;
        }

        public boolean getNegate() {
            return this.negate;
        }

        public String toString() {
            return "matching " + (this.negate ? "!" : "") + this.pattern;
        }
    }
}

