/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.engine;

import de.gesellix.docker.engine.DockerEnv;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerClientConfig {
    private static final Logger log = LoggerFactory.getLogger(DockerClientConfig.class);
    private DockerEnv env;
    private String scheme;
    private String host;
    private int port;
    private String certPath;

    public DockerClientConfig() {
        this(new DockerEnv());
    }

    public DockerClientConfig(String dockerHost) {
        this(new DockerEnv(dockerHost));
    }

    public DockerClientConfig(DockerEnv config) {
        this.apply(config);
    }

    public void apply(DockerEnv env) {
        Map<String, String> dockerClientConfig;
        if (env.getDockerHost() == null || env.getDockerHost().isEmpty()) {
            throw new IllegalStateException("dockerHost must be set");
        }
        this.env = env;
        try {
            dockerClientConfig = this.getActualConfig(env);
        }
        catch (MalformedURLException e) {
            log.error("Invalid DOCKER_HOST " + env.getDockerHost(), (Throwable)e);
            throw new RuntimeException("Invalid DOCKER_HOST " + env.getDockerHost(), e);
        }
        this.scheme = dockerClientConfig.get("protocol");
        this.host = dockerClientConfig.get("host");
        this.port = Integer.parseInt(dockerClientConfig.get("port"));
        this.certPath = dockerClientConfig.get("certPath");
    }

    Map<String, String> getActualConfig(DockerEnv env) throws MalformedURLException {
        String oldProtocol;
        String dockerHost = env.getDockerHost();
        if (dockerHost == null || dockerHost.isEmpty()) {
            throw new IllegalStateException("dockerHost must be set");
        }
        String protocol = oldProtocol = dockerHost.split("://", 2)[0];
        HashMap<String, String> result = new HashMap<String, String>();
        switch (protocol) {
            case "http": 
            case "https": 
            case "tcp": {
                URL candidateURL = new URL(dockerHost.replaceFirst("^" + oldProtocol + "://", "https://"));
                TlsConfig tlsConfig = this.getTlsConfig(candidateURL, env);
                if (tlsConfig.getTlsVerify()) {
                    protocol = "https";
                    result.put("certPath", tlsConfig.getCertPath());
                } else {
                    protocol = "http";
                    result.put("certPath", null);
                }
                URL tcpUrl = new URL(dockerHost.replaceFirst("^" + oldProtocol + "://", protocol + "://"));
                result.put("protocol", tcpUrl.getProtocol());
                result.put("host", tcpUrl.getHost());
                result.put("port", String.valueOf(tcpUrl.getPort()));
                break;
            }
            case "unix": {
                String dockerUnixSocket = dockerHost.replaceFirst("unix://", "");
                result.put("protocol", "unix");
                result.put("host", dockerUnixSocket);
                result.put("port", String.valueOf(-1));
                result.put("certPath", null);
                break;
            }
            case "npipe": {
                String dockerNamedPipe = dockerHost.replaceFirst("npipe://", "");
                result.put("protocol", "npipe");
                result.put("host", dockerNamedPipe);
                result.put("port", String.valueOf(-1));
                result.put("certPath", null);
                break;
            }
            default: {
                log.warn("protocol '" + protocol + "' not supported");
                URL url = new URL(dockerHost);
                result.put("protocol", url.getProtocol());
                result.put("host", url.getHost());
                result.put("port", String.valueOf(url.getPort()));
                result.put("certPath", null);
            }
        }
        log.debug("selected dockerHost at '" + result + "'");
        return result;
    }

    public TlsConfig getTlsConfig(URL candidateURL, DockerEnv env) {
        if (env.getTlsVerify() != null && env.getTlsVerify().equals("")) {
            log.debug("dockerTlsVerify='" + env.getTlsVerify() + "'");
            return new TlsConfig(false, null);
        }
        String certPath = this.getCertPathOrNull(env);
        Boolean certsPathExists = certPath != null;
        if (env.getTlsVerify() != null && !env.getTlsVerify().isEmpty()) {
            if (!certsPathExists.booleanValue()) {
                throw new IllegalStateException("tlsverify='" + env.getTlsVerify() + "', but '" + env.getCertPath() + "' doesn't exist");
            }
            log.debug("certsPathExists=" + certsPathExists);
            return new TlsConfig(true, certPath);
        }
        Boolean isTlsPort = candidateURL.getPort() == env.getDefaultTlsPort();
        log.debug("certsPathExists=" + certsPathExists + ", isTlsPort=" + isTlsPort);
        return new TlsConfig(certsPathExists != false && isTlsPort != false, certPath);
    }

    public String getCertPathOrNull(DockerEnv env) {
        Boolean certsPathExists = env.getCertPath() != null && !env.getCertPath().isEmpty() && new File(env.getCertPath(), "").isDirectory();
        if (!certsPathExists.booleanValue()) {
            if (env.getDefaultCertPath() != null && !env.getDefaultCertPath().isEmpty() && new File(env.getDefaultCertPath(), "").isDirectory()) {
                log.debug("defaultDockerCertPath=" + env.getDefaultCertPath());
                return env.getDefaultCertPath();
            }
            return null;
        }
        log.debug("dockerCertPath=" + env.getCertPath());
        return env.getCertPath();
    }

    public Boolean isContentTrustEnabled(DockerEnv env) {
        if (env.getDockerContentTrust().trim().equals("") || DockerClientConfig.isFalsy(env.getDockerContentTrust()).booleanValue()) {
            return false;
        }
        return true;
    }

    public static Boolean isFalsy(String value) {
        String sanitizedValue = value.trim().toLowerCase();
        return Arrays.asList("0", "false", "no").contains(sanitizedValue);
    }

    public DockerEnv getEnv() {
        return this.env;
    }

    public void setEnv(DockerEnv env) {
        this.env = env;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public static class TlsConfig {
        private boolean tlsVerify = false;
        private String certPath = null;

        public TlsConfig(boolean tlsVerify, String certPath) {
            this.tlsVerify = tlsVerify;
            this.certPath = certPath;
        }

        public boolean getTlsVerify() {
            return this.tlsVerify;
        }

        public boolean isTlsVerify() {
            return this.tlsVerify;
        }

        public void setTlsVerify(boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
        }

        public String getCertPath() {
            return this.certPath;
        }

        public void setCertPath(String certPath) {
            this.certPath = certPath;
        }
    }
}

