/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.context;

import de.gesellix.docker.context.DockerContext;
import de.gesellix.docker.context.EndpointMetaBase;
import de.gesellix.docker.context.Metadata;
import de.gesellix.docker.context.MetadataStore;
import de.gesellix.docker.engine.DockerEnv;
import java.io.File;
import java.util.Objects;

public class ContextStore {
    private final MetadataStore metadataStore;

    public ContextStore(File dockerContextStoreDir) {
        File metaRoot = new File(dockerContextStoreDir, "meta");
        this.metadataStore = new MetadataStore(metaRoot);
    }

    public Metadata getMetadata(String contextName) {
        if (Objects.equals(contextName, "default")) {
            Metadata metadata = new Metadata("default");
            metadata.setMetadata(new DockerContext(""));
            metadata.getEndpoints().put("docker", new EndpointMetaBase(DockerEnv.getDockerHostFromSystemPropertyOrEnvironment(), false));
            return metadata;
        }
        return this.metadataStore.getMetadata(contextName);
    }
}

