/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.filesocket;

import de.gesellix.docker.client.filesocket.FileSocket;
import de.gesellix.docker.client.filesocket.NamedPipeDelegatingInputStream;
import de.gesellix.docker.client.filesocket.NamedPipeDelegatingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedPipeSocket
extends FileSocket {
    private static final Logger log = LoggerFactory.getLogger(NamedPipeSocket.class);
    private RandomAccessFile namedPipe = null;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private InputStream inputStream;
    private OutputStream outputStream;

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (!InetSocketAddress.class.isInstance(endpoint)) {
            throw new IllegalArgumentException("Expected endpoint to be a InetSocketAddress");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)endpoint;
        InetAddress address = inetSocketAddress.getAddress();
        String socketPath = this.decodeHostname(address);
        log.debug("connect via '{}'...", (Object)socketPath);
        socketPath = socketPath.replace("/", "\\\\");
        this.namedPipe = new RandomAccessFile(socketPath, "rw");
        this.inputStream = new NamedPipeDelegatingInputStream(this.namedPipe);
        this.outputStream = new NamedPipeDelegatingOutputStream(this.namedPipe);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            throw new SocketException("Socket is not initialized. Please call #connect.");
        }
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            throw new SocketException("Socket is not initialized. Please call #connect.");
        }
        return this.outputStream;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (this.namedPipe != null) {
            this.namedPipe.close();
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

