/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.filesocket;

import de.gesellix.docker.client.filesocket.FileSocket;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import org.newsclub.net.unix.AFUNIXSocket;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixSocket
extends FileSocket {
    private static final Logger log = LoggerFactory.getLogger(UnixSocket.class);
    private AFUNIXSocket socket = null;

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Expected endpoint to be a InetSocketAddress");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)endpoint;
        InetAddress address = inetSocketAddress.getAddress();
        String socketPath = this.decodeHostname(address);
        log.debug("connect via '{}'...", (Object)socketPath);
        int socketTimeout = Math.max(timeout, 0);
        File socketFile = new File(socketPath);
        this.socket = AFUNIXSocket.newInstance();
        this.socket.connect((SocketAddress)AFUNIXSocketAddress.of((File)socketFile), socketTimeout);
        this.socket.setSoTimeout(socketTimeout);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.socket == null) {
            throw new SocketException("Socket is not initialized");
        }
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            throw new SocketException("Socket is not initialized");
        }
        return this.socket.getOutputStream();
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        if (this.socket == null) {
            throw new SocketException("Socket is not initialized");
        }
        this.socket.bind(bindpoint);
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    @Override
    public boolean isClosed() {
        return this.socket != null && this.socket.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.socket != null) {
            UnixSocket unixSocket = this;
            synchronized (unixSocket) {
                this.socket.close();
            }
        }
    }
}

