/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.filesocket;

import java.util.ArrayList;
import okio.ByteString;

public class HostnameEncoder {
    private static final Integer MAX_LABEL_LENGTH = 63;
    private static final Integer MAX_HOSTNAME_LENGTH = MAX_LABEL_LENGTH * 4;

    public String encode(String toEncode) {
        String encoded = ByteString.encodeUtf8((String)toEncode).hex();
        if (encoded.length() > MAX_LABEL_LENGTH && encoded.length() < MAX_HOSTNAME_LENGTH) {
            ArrayList<String> labels = new ArrayList<String>();
            int labelCount = (int)Math.ceil((double)encoded.length() / MAX_LABEL_LENGTH.doubleValue());
            for (int step = 0; step < labelCount; ++step) {
                int from = step * MAX_LABEL_LENGTH;
                int to = from + MAX_LABEL_LENGTH;
                labels.add(encoded.substring(from, Math.min(to, encoded.length())));
            }
            return String.join((CharSequence)".", labels);
        }
        return encoded;
    }

    public String decode(String toDecode) {
        String decoded = toDecode;
        if (toDecode.contains(".")) {
            CharSequence[] labels = toDecode.split("\\.");
            decoded = String.join((CharSequence)"", labels);
        }
        return ByteString.decodeHex((String)decoded).utf8();
    }
}

