/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.docker.client.filesocket;

import de.gesellix.docker.client.filesocket.AsynchronousFileByteChannel;
import de.gesellix.docker.client.filesocket.FileSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channels;
import java.nio.file.FileSystemException;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedPipeSocket
extends FileSocket {
    private static final Logger log = LoggerFactory.getLogger(NamedPipeSocket.class);
    private AsynchronousFileByteChannel channel;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private InputStream inputStream;
    private OutputStream outputStream;

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Expected endpoint to be a InetSocketAddress");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)endpoint;
        InetAddress address = inetSocketAddress.getAddress();
        String socketPath = this.decodeHostname(address);
        log.debug("connect via '{}'...", (Object)socketPath);
        socketPath = socketPath.replace("/", "\\\\");
        long startedAt = System.currentTimeMillis();
        timeout = Math.max(timeout, 10000);
        while (true) {
            try {
                this.channel = new AsynchronousFileByteChannel(AsynchronousFileChannel.open(Paths.get(socketPath, new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE));
            }
            catch (FileSystemException e) {
                if (System.currentTimeMillis() - startedAt >= (long)timeout) {
                    throw new RuntimeException(e);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    @Override
    public InputStream getInputStream() {
        if (this.inputStream == null) {
            this.inputStream = Channels.newInputStream(this.channel);
        }
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = Channels.newOutputStream(this.channel);
        }
        return this.outputStream;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

