/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker;

import de.gesellix.docker.client.authentication.AuthConfig;
import java.net.Proxy;
import org.gradle.api.Project;

public class DockerPluginExtension {
    private final Project project;
    private String dockerHost;
    private String certPath;
    private Proxy proxy;
    private AuthConfig authConfig;

    public DockerPluginExtension(Project project) {
        this.project = project;
        this.dockerHost = System.getProperty("docker.host", System.getenv("DOCKER_HOST"));
        this.certPath = System.getProperty("docker.cert.path", System.getenv("DOCKER_CERT_PATH"));
    }

    @Deprecated
    public void setAuthConfigPlain(AuthConfig authConfigPlain) {
        this.project.getLogger().warn("The authConfigPlain property will be removed soon. Please use authConfig instead.");
        this.authConfig = authConfigPlain;
    }

    @Deprecated
    public void setAuthConfigEncoded(String ignored) {
        throw new UnsupportedOperationException("The authConfigEncoded property is not supported anymore. Please use authConfig instead.");
    }

    public void setCertPath(String path) {
        this.certPath = path;
    }

    public String getCertPath() {
        if (this.certPath != null && !this.certPath.isEmpty()) {
            return this.project.file((Object)this.certPath).getAbsolutePath();
        }
        return null;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    public void setDockerHost(String dockerHost) {
        this.dockerHost = dockerHost;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public AuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public void setAuthConfig(AuthConfig authConfig) {
        this.authConfig = authConfig;
    }
}

