/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.worker;

import de.gesellix.docker.client.builder.BuildContextBuilder;
import de.gesellix.gradle.docker.worker.BuildcontextArchiverWorkParameters;
import java.io.File;
import java.io.IOException;
import org.gradle.workers.WorkAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BuildcontextArchiver
implements WorkAction<BuildcontextArchiverWorkParameters> {
    private static final Logger log = LoggerFactory.getLogger(BuildcontextArchiver.class);

    public void execute() {
        File sourceDirectory = (File)((BuildcontextArchiverWorkParameters)this.getParameters()).getSourceDirectory().getAsFile().get();
        File targetFile = (File)((BuildcontextArchiverWorkParameters)this.getParameters()).getArchivedTargetFile().getAsFile().get();
        log.info("archiving " + sourceDirectory + " into " + targetFile + "...");
        targetFile.getParentFile().mkdirs();
        try {
            BuildContextBuilder.archiveTarFilesRecursively((File)sourceDirectory, (File)targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Archiving failed", e);
        }
        log.info("archiving finished");
    }
}

