/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import java.io.InputStream;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class DockerCopyToContainerTask
extends GenericDockerTask {
    private final Property<String> container;
    private final Property<String> targetPath;
    private final Property<InputStream> tarInputStream;

    @Input
    public Property<String> getContainer() {
        return this.container;
    }

    @Input
    public Property<String> getTargetPath() {
        return this.targetPath;
    }

    @Input
    public Property<InputStream> getTarInputStream() {
        return this.tarInputStream;
    }

    @Inject
    public DockerCopyToContainerTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Copy files/folders from your host to a container.");
        this.container = objectFactory.property(String.class);
        this.targetPath = objectFactory.property(String.class);
        this.tarInputStream = objectFactory.property(InputStream.class);
    }

    @TaskAction
    public void copyToContainer() {
        this.getLogger().info("docker cp to container");
        this.getDockerClient().putArchive((String)this.getContainer().get(), (String)this.getTargetPath().get(), (InputStream)this.getTarInputStream().get());
    }
}

