/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.remote.api.ExecConfig;
import de.gesellix.docker.remote.api.ExecStartConfig;
import de.gesellix.docker.remote.api.IdResponse;
import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class DockerExecTask
extends GenericDockerTask {
    private final Property<String> containerId;
    private final ListProperty<String> cmds;
    private final Property<String> cmd;

    @Input
    public Property<String> getContainerId() {
        return this.containerId;
    }

    @Input
    @Optional
    public ListProperty<String> getCmds() {
        return this.cmds;
    }

    @Input
    @Optional
    public Property<String> getCmd() {
        return this.cmd;
    }

    @Inject
    public DockerExecTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Run a command in a running container");
        this.containerId = objectFactory.property(String.class);
        this.cmds = objectFactory.listProperty(String.class);
        this.cmd = objectFactory.property(String.class);
    }

    @TaskAction
    public void exec() {
        this.getLogger().info("docker exec");
        List<String> commandline = !((List)this.cmds.get()).isEmpty() ? (List<String>)this.cmds.get() : Arrays.asList("sh", "-c", (String)this.cmd.getOrNull());
        ExecConfig execCreateConfig = new ExecConfig();
        execCreateConfig.setAttachStdin(Boolean.valueOf(false));
        execCreateConfig.setAttachStdout(Boolean.valueOf(true));
        execCreateConfig.setAttachStderr(Boolean.valueOf(true));
        execCreateConfig.setTty(Boolean.valueOf(false));
        execCreateConfig.setCmd(commandline);
        this.getLogger().debug("exec cmd: '" + execCreateConfig.getCmd() + "'");
        String execId = ((IdResponse)this.getDockerClient().createExec((String)this.containerId.get(), execCreateConfig).getContent()).getId();
        ExecStartConfig execStartConfig = new ExecStartConfig(Boolean.valueOf(false), Boolean.valueOf(false));
        this.getDockerClient().startExec(execId, execStartConfig, null, null);
    }
}

