/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.remote.api.core.Cancellable;
import de.gesellix.docker.remote.api.core.Frame;
import de.gesellix.docker.remote.api.core.StreamCallback;
import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class DockerLogsTask
extends GenericDockerTask {
    private final Property<String> containerId;
    public Duration logsTimeout = Duration.of(10L, ChronoUnit.MINUTES);
    private final MapProperty<String, Object> logOptions;

    @Input
    public Property<String> getContainerId() {
        return this.containerId;
    }

    @Internal
    public Duration getLogsTimeout() {
        return this.logsTimeout;
    }

    @Input
    @Optional
    public MapProperty<String, Object> getLogOptions() {
        return this.logOptions;
    }

    @Inject
    public DockerLogsTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Fetch the logs of a container");
        this.containerId = objectFactory.property(String.class);
        this.logOptions = objectFactory.mapProperty(String.class, Object.class);
        this.logOptions.convention(new HashMap());
        this.logOptions.put((Object)"follow", (Object)false);
    }

    @TaskAction
    public void logs() {
        this.getLogger().info("docker logs {}", this.containerId.get());
        final CountDownLatch logsFinished = new CountDownLatch(1);
        StreamCallback<Frame> callback = new StreamCallback<Frame>(){
            Cancellable cancellable;

            public void onStarting(Cancellable cancellable) {
                this.cancellable = cancellable;
            }

            public void onNext(Frame frame) {
                if (frame != null) {
                    DockerLogsTask.this.getLogger().info(frame.toString());
                }
            }

            public void onFailed(Exception e) {
                DockerLogsTask.this.getLogger().error("failed", (Throwable)e);
                logsFinished.countDown();
                this.cancellable.cancel();
            }

            public void onFinished() {
                DockerLogsTask.this.getLogger().info("finished");
                logsFinished.countDown();
            }
        };
        this.getDockerClient().logs((String)this.containerId.get(), (Map)this.logOptions.getOrNull(), (StreamCallback)callback, this.logsTimeout);
        try {
            this.getLogger().debug("Following the logs for  " + this.logsTimeout + "...");
            logsFinished.await(this.logsTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

