/*
 * Decompiled with CFR 0.152.
 */
package de.gesellix.gradle.docker.tasks;

import de.gesellix.docker.remote.api.PushImageInfo;
import de.gesellix.docker.remote.api.core.Cancellable;
import de.gesellix.docker.remote.api.core.StreamCallback;
import de.gesellix.gradle.docker.tasks.GenericDockerTask;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class DockerPushTask
extends GenericDockerTask {
    private final Property<String> repositoryName;
    private final Property<String> registry;
    public Duration pushTimeout = Duration.of(10L, ChronoUnit.MINUTES);

    @Input
    public Property<String> getRepositoryName() {
        return this.repositoryName;
    }

    @Input
    @Optional
    public Property<String> getRegistry() {
        return this.registry;
    }

    @Internal
    public Duration getPushTimeout() {
        return this.pushTimeout;
    }

    @Inject
    public DockerPushTask(ObjectFactory objectFactory) {
        super(objectFactory);
        this.setDescription("Push an image or a repository to a Docker registry server");
        this.repositoryName = objectFactory.property(String.class);
        this.registry = objectFactory.property(String.class);
    }

    @TaskAction
    public void push() {
        this.getLogger().info("docker push");
        final ArrayList infos = new ArrayList();
        final CountDownLatch pushFinished = new CountDownLatch(1);
        StreamCallback<PushImageInfo> callback = new StreamCallback<PushImageInfo>(){
            private Cancellable cancellable;

            public void onStarting(Cancellable cancellable) {
                this.cancellable = cancellable;
            }

            public void onNext(PushImageInfo element) {
                DockerPushTask.this.getLogger().info(element != null ? element.toString() : null);
                infos.add(element);
            }

            public void onFailed(Exception e) {
                DockerPushTask.this.getLogger().error("Push failed", (Throwable)e);
                pushFinished.countDown();
                this.cancellable.cancel();
            }

            public void onFinished() {
                DockerPushTask.this.getLogger().info("Push finished");
                pushFinished.countDown();
            }
        };
        this.getDockerClient().push((StreamCallback)callback, this.pushTimeout, (String)this.getRepositoryName().get(), this.getEncodedAuthConfig(), (String)this.getRegistry().getOrNull());
        try {
            this.getLogger().debug("Waiting " + this.pushTimeout + " for the build to finish...");
            pushFinished.await(this.pushTimeout.toMillis(), TimeUnit.MILLISECONDS);
            List errors = infos.stream().filter(i -> i.getError() != null).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                throw new GradleException("Push failed: " + errors.stream().findFirst().get());
            }
        }
        catch (InterruptedException e) {
            this.getLogger().error("Push didn't finish before timeout of " + pushFinished, (Throwable)e);
        }
    }
}

